/*
 * Decompiled with CFR 0.152.
 */
package evacSim.vehiclecontext;

import evacSim.ContextCreator;
import evacSim.GlobalVariables;
import evacSim.citycontext.House;
import evacSim.citycontext.Road;
import evacSim.routing.RouteV;
import evacSim.vehiclecontext.Vehicle;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import org.apache.log4j.Logger;
import repast.simphony.essentials.RepastEssentials;

public class Vehicle_less_frequent_routing
extends Vehicle {
    private Logger logger = ContextCreator.logger;

    public Vehicle_less_frequent_routing(House h) {
        super(h);
        this.setVehicleClass(3);
    }

    public Vehicle_less_frequent_routing(House h, float maximumAcceleration, float maximumDeceleration) {
        super(h, maximumAcceleration, maximumDeceleration);
    }

    @Override
    public void setNextRoad() {
        try {
            if (!this.atOrigin) {
                if (this.road.getLinkid() == this.destRoadID) {
                    this.nextRoad_ = null;
                    return;
                }
                if (Math.random() < GlobalVariables.PROBABILITY_OF_UPDATING_ROUTING) {
                    this.lastRouteTime = RouteV.getValidTime();
                }
                if (this.lastRouteTime < RouteV.getValidTime()) {
                    Map<Float, Queue<Road>> tempPathMap = RouteV.vehicleRoute(this, this.destZone);
                    Map.Entry<Float, Queue<Road>> entry = tempPathMap.entrySet().iterator().next();
                    Queue<Road> tempPathNew = entry.getValue();
                    float pathTimeNew = entry.getKey().floatValue();
                    int currentTick = (int)RepastEssentials.GetTickCount();
                    Queue<Road> tempPath = entry.getValue();
                    double pathTimeOldPath = this.travelTimeForPreviousRoute - (float)(currentTick - this.previousTick) * GlobalVariables.SIMULATION_STEP_SIZE;
                    if (pathTimeOldPath - (double)pathTimeNew > (double)this.indiffBand * pathTimeOldPath && pathTimeOldPath - (double)pathTimeNew > (double)GlobalVariables.TAU) {
                        tempPath = tempPathNew;
                        this.travelTimeForPreviousRoute = pathTimeNew;
                        this.previousTick = currentTick;
                    }
                    Iterator itr = this.roadPath.iterator();
                    itr.next();
                    if (this.checkNextLaneConnected((Road)itr.next())) {
                        this.clearShadowImpact();
                        this.roadPath = tempPath;
                        this.setShadowImpact();
                        this.lastRouteTime = (int)RepastEssentials.GetTickCount();
                        itr = this.roadPath.iterator();
                        itr.next();
                        this.nextRoad_ = (Road)itr.next();
                    } else {
                        this.removeShadowCount((Road)this.roadPath.peek());
                        this.roadPath.poll();
                        itr = this.roadPath.iterator();
                        itr.next();
                        this.nextRoad_ = (Road)itr.next();
                    }
                } else {
                    this.removeShadowCount((Road)this.roadPath.peek());
                    this.roadPath.poll();
                    Iterator itr = this.roadPath.iterator();
                    itr.next();
                    this.nextRoad_ = (Road)itr.next();
                }
            } else {
                Queue<Road> tempPath;
                this.clearShadowImpact();
                Map<Float, Queue<Road>> tempPathMap = RouteV.vehicleRoute(this, this.destZone);
                Map.Entry<Float, Queue<Road>> entry = tempPathMap.entrySet().iterator().next();
                this.roadPath = tempPath = entry.getValue();
                this.setShadowImpact();
                this.lastRouteTime = (int)RepastEssentials.GetTickCount();
                this.atOrigin = false;
                Iterator itr = this.roadPath.iterator();
                itr.next();
                this.nextRoad_ = (Road)itr.next();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info((Object)("No next road found for Vehicle " + this.vehicleID_ + " on Road " + this.road.getLinkid()));
            this.nextRoad_ = null;
        }
    }
}

