/*
 * Decompiled with CFR 0.152.
 */
package evacSim.routing;

import evacSim.ContextCreator;
import evacSim.citycontext.Road;
import evacSim.citycontext.Zone;
import evacSim.routing.HungarianAlgorithm_AALMI;
import evacSim.routing.RouteV;
import evacSim.vehiclecontext.Vehicle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jgrapht.Graph;
import org.jgrapht.alg.interfaces.MatchingAlgorithm;
import org.jgrapht.alg.matching.GreedyWeightedMatching;
import org.jgrapht.alg.matching.KuhnMunkresMinimalWeightBipartitePerfectMatching;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleWeightedGraph;

public class SOShelterRouting {
    Logger logger = ContextCreator.logger;
    private ArrayList<Zone> shelters;
    private ArrayList<Integer> shelterCapacity;
    private ArrayList<Integer> shelterRemaining;
    private ArrayList<Integer> relocateDemand;
    private Integer demandSum;
    private ArrayList<ArrayList<Double>> dMatrix;
    private Double maxDistance;

    public SOShelterRouting(ArrayList<Zone> allshelters) {
        this.shelters = allshelters;
        int nShelters = this.shelters.size();
        this.demandSum = 0;
        this.maxDistance = 0.0;
        this.shelterCapacity = new ArrayList(nShelters);
        this.shelterRemaining = new ArrayList(nShelters);
        this.relocateDemand = new ArrayList(nShelters);
        this.dMatrix = new ArrayList();
        int i = 0;
        while (i < nShelters) {
            this.shelterCapacity.add(this.shelters.get(i).getCapacity());
            this.shelterRemaining.add(this.shelters.get(i).getCapacity());
            this.relocateDemand.add(0);
            ArrayList<Double> dMatrixRow = new ArrayList<Double>(nShelters);
            int j = 0;
            while (j < nShelters) {
                dMatrixRow.add(0.0);
                ++j;
            }
            this.dMatrix.add(dMatrixRow);
            ++i;
        }
    }

    public ArrayList<Integer> getCapacity() {
        return this.shelterCapacity;
    }

    public ArrayList<Integer> updateRemaining() {
        int i = 0;
        while (i < this.shelters.size()) {
            int remaining = this.shelters.get(i).getCapacity() - this.shelters.get(i).getOccupancy();
            this.shelterRemaining.set(i, remaining);
            ++i;
        }
        return this.shelterRemaining;
    }

    public ArrayList<Integer> updateRelocateDemand() {
        this.demandSum = 0;
        int i = 0;
        while (i < this.shelters.size()) {
            Queue<Vehicle> waiting = this.shelters.get(i).getWaiting();
            if (waiting != null) {
                this.relocateDemand.set(i, waiting.size());
                this.demandSum = this.demandSum + waiting.size();
            }
            ++i;
        }
        return this.relocateDemand;
    }

    public ArrayList<ArrayList<Double>> updateDistMatrix() {
        double maxDist = 0.0;
        int i = 0;
        while (i < this.shelters.size()) {
            int j = i + 1;
            while (j < this.shelters.size()) {
                Zone orig = this.shelters.get(i);
                Zone dest = this.shelters.get(j);
                try {
                    if (orig.getDownJunc() == null) {
                        orig.setDownJunc(RouteV.getNearestDownStreamJunction(orig.getRoad()));
                    }
                    if (dest.getDownJunc() == null) {
                        dest.setDownJunc(RouteV.getNearestDownStreamJunction(dest.getRoad()));
                    }
                    Map<Float, Queue<Road>> shortPath = RouteV.vbr.computeRoute(orig.getRoad(), dest.getRoad(), orig.getDownJunc(), dest.getDownJunc());
                    Iterator<Float> iterator = shortPath.keySet().iterator();
                    while (iterator.hasNext()) {
                        double dist = iterator.next().floatValue();
                        this.dMatrix.get(i).set(j, dist);
                        this.dMatrix.get(j).set(i, dist);
                        if (!(dist > maxDist)) continue;
                        maxDist = dist;
                    }
                }
                catch (NullPointerException e) {
                    this.logger.error((Object)("Error in calc. dist. b/w " + orig + " & " + dest));
                }
                ++j;
            }
            ++i;
        }
        this.maxDistance = maxDist;
        return this.dMatrix;
    }

    public void assignMatching(String algorithm) {
        this.updateRemaining();
        this.updateRelocateDemand();
        if (this.demandSum == 0) {
            return;
        }
        this.updateDistMatrix();
        ArrayList<ArrayList<Integer>> matching = null;
        if (algorithm.equals("hungarian")) {
            matching = this.hungarianRouting();
        } else if (algorithm.equals("leda")) {
            matching = this.ledaRouting();
        } else if (algorithm.equals("greedy")) {
            matching = this.greedyRouting();
        } else if (algorithm.equals("hungarian_aalmi")) {
            matching = this.hungarianAlgorithm_AALMI();
        } else {
            throw new IllegalArgumentException("Algorithm should be one of 'hungarian', 'leda', 'greedy'");
        }
        if (matching == null) {
            this.logger.error((Object)"Null matching in shelter relocation for non-zero demand.");
            return;
        }
        int i = 0;
        while (i < matching.size()) {
            Zone origin = this.shelters.get(i);
            Queue<Vehicle> relocateVehicles = origin.getWaiting();
            ArrayList<Integer> matchingRow = matching.get(i);
            if (this.getSum(matchingRow) == relocateVehicles.size()) {
                int j = 0;
                while (j < matchingRow.size()) {
                    Zone dest = this.shelters.get(j);
                    int numAssigned = matchingRow.get(j);
                    int k = 0;
                    while (k < numAssigned) {
                        Vehicle veh = relocateVehicles.remove();
                        int curDestID = veh.getDestinationID();
                        if (curDestID != origin.getIntegerId()) {
                            this.logger.error((Object)("Shelter reassignment does not match for vehicle " + veh.getVehicleID() + " (current" + "plan destination: " + curDestID + ", current shelter: " + origin.getIntegerId() + ")"));
                        } else {
                            veh.setNewHouse(dest.getIntegerId());
                        }
                        ++k;
                    }
                    ++j;
                }
            } else {
                this.logger.error((Object)("Matching sizes do not match for shelter " + origin + ", required: " + relocateVehicles.size() + ", assigned:" + this.getSum(matchingRow)));
            }
            ++i;
        }
    }

    public ArrayList<ArrayList<Integer>> hungarianRouting() {
        String combine;
        String str2;
        String str1;
        SimpleWeightedGraph matchingGraph = new SimpleWeightedGraph(DefaultWeightedEdge.class);
        ArrayList<String> leftNode = new ArrayList<String>();
        ArrayList<String> rightNode = new ArrayList<String>();
        int i = 0;
        while (i < this.demandSum) {
            str1 = "de";
            str2 = Integer.toString(i + 1);
            combine = String.valueOf(str1) + str2;
            leftNode.add(combine);
            ++i;
        }
        i = 0;
        while (i < this.getSum(this.shelterRemaining) - this.demandSum) {
            str1 = "du";
            str2 = Integer.toString(i + 1);
            combine = String.valueOf(str1) + str2;
            leftNode.add(combine);
            ++i;
        }
        i = 0;
        while (i < this.getSum(this.shelterRemaining)) {
            str1 = "su";
            str2 = Integer.toString(i + 1);
            combine = String.valueOf(str1) + str2;
            rightNode.add(combine);
            ++i;
        }
        HashSet leftNodeSet = new HashSet(leftNode);
        HashSet rightNodeSet = new HashSet(rightNode);
        int i2 = 0;
        while (i2 < leftNode.size()) {
            matchingGraph.addVertex((Object)((String)leftNode.get(i2)));
            ++i2;
        }
        i2 = 0;
        while (i2 < rightNode.size()) {
            matchingGraph.addVertex((Object)((String)rightNode.get(i2)));
            ++i2;
        }
        i2 = 0;
        while (i2 < leftNode.size()) {
            int j = 0;
            while (j < rightNode.size()) {
                String str12 = (String)leftNode.get(i2);
                String str22 = (String)rightNode.get(j);
                matchingGraph.addEdge((Object)str12, (Object)str22);
                DefaultWeightedEdge edge = (DefaultWeightedEdge)matchingGraph.getEdge((Object)str12, (Object)str22);
                if (i2 < this.demandSum) {
                    int locationI = this.getLocation(this.relocateDemand, i2 + 1);
                    int locationJ = this.getLocation(this.shelterRemaining, j + 1);
                    matchingGraph.setEdgeWeight((Object)edge, this.dMatrix.get(locationI).get(locationJ).doubleValue());
                } else {
                    matchingGraph.setEdgeWeight((Object)edge, 0.0);
                }
                ++j;
            }
            ++i2;
        }
        KuhnMunkresMinimalWeightBipartitePerfectMatching Hmatching = new KuhnMunkresMinimalWeightBipartitePerfectMatching((Graph)matchingGraph, leftNodeSet, rightNodeSet);
        MatchingAlgorithm.Matching matching = Hmatching.getMatching();
        return this.returnPlan((SimpleWeightedGraph<String, DefaultWeightedEdge>)matchingGraph, (MatchingAlgorithm.Matching<String, DefaultWeightedEdge>)matching);
    }

    public ArrayList<ArrayList<Integer>> ledaRouting() {
        String combine;
        String str2;
        String str1;
        SimpleWeightedGraph matchingGraph = new SimpleWeightedGraph(DefaultWeightedEdge.class);
        ArrayList<String> leftNode = new ArrayList<String>();
        ArrayList<String> rightNode = new ArrayList<String>();
        int i = 0;
        while (i < this.demandSum) {
            str1 = "de";
            str2 = Integer.toString(i + 1);
            combine = String.valueOf(str1) + str2;
            leftNode.add(combine);
            ++i;
        }
        i = 0;
        while (i < this.getSum(this.shelterRemaining)) {
            str1 = "su";
            str2 = Integer.toString(i + 1);
            combine = String.valueOf(str1) + str2;
            rightNode.add(combine);
            ++i;
        }
        i = 0;
        while (i < leftNode.size()) {
            matchingGraph.addVertex((Object)((String)leftNode.get(i)));
            ++i;
        }
        i = 0;
        while (i < rightNode.size()) {
            matchingGraph.addVertex((Object)((String)rightNode.get(i)));
            ++i;
        }
        i = 0;
        while (i < leftNode.size()) {
            int j = 0;
            while (j < rightNode.size()) {
                String str12 = (String)leftNode.get(i);
                String str22 = (String)rightNode.get(j);
                matchingGraph.addEdge((Object)str12, (Object)str22);
                DefaultWeightedEdge edge = (DefaultWeightedEdge)matchingGraph.getEdge((Object)str12, (Object)str22);
                int locationI = this.getLocation(this.relocateDemand, i + 1);
                int locationJ = this.getLocation(this.shelterRemaining, j + 1);
                matchingGraph.setEdgeWeight((Object)edge, this.maxDistance - this.dMatrix.get(locationI).get(locationJ));
                ++j;
            }
            ++i;
        }
        boolean normalizeEdgeCosts = false;
        GreedyWeightedMatching Gmacthing = new GreedyWeightedMatching((Graph)matchingGraph, normalizeEdgeCosts);
        MatchingAlgorithm.Matching matching = Gmacthing.getMatching();
        return this.returnPlan((SimpleWeightedGraph<String, DefaultWeightedEdge>)matchingGraph, (MatchingAlgorithm.Matching<String, DefaultWeightedEdge>)matching);
    }

    public ArrayList<ArrayList<Integer>> greedyRouting() {
        String combine;
        String str2;
        String str1;
        SimpleWeightedGraph matchingGraph = new SimpleWeightedGraph(DefaultWeightedEdge.class);
        ArrayList<String> leftNode = new ArrayList<String>();
        ArrayList<String> rightNode = new ArrayList<String>();
        int i = 0;
        while (i < this.demandSum) {
            str1 = "de";
            str2 = Integer.toString(i + 1);
            combine = String.valueOf(str1) + str2;
            leftNode.add(combine);
            ++i;
        }
        i = 0;
        while (i < this.getSum(this.shelterRemaining)) {
            str1 = "su";
            str2 = Integer.toString(i + 1);
            combine = String.valueOf(str1) + str2;
            rightNode.add(combine);
            ++i;
        }
        i = 0;
        while (i < leftNode.size()) {
            matchingGraph.addVertex((Object)((String)leftNode.get(i)));
            ++i;
        }
        i = 0;
        while (i < rightNode.size()) {
            matchingGraph.addVertex((Object)((String)rightNode.get(i)));
            ++i;
        }
        i = 0;
        while (i < leftNode.size()) {
            int j = 0;
            while (j < rightNode.size()) {
                String str12 = (String)leftNode.get(i);
                String str22 = (String)rightNode.get(j);
                matchingGraph.addEdge((Object)str12, (Object)str22);
                DefaultWeightedEdge edge = (DefaultWeightedEdge)matchingGraph.getEdge((Object)str12, (Object)str22);
                int locationI = this.getLocation(this.relocateDemand, i + 1);
                int locationJ = this.getLocation(this.shelterRemaining, j + 1);
                double distance = this.dMatrix.get(locationI).get(locationJ);
                matchingGraph.setEdgeWeight((Object)edge, this.maxDistance - distance);
                ++j;
            }
            ++i;
        }
        boolean normalizeEdgeCosts = false;
        GreedyWeightedMatching Gmacthing = new GreedyWeightedMatching((Graph)matchingGraph, normalizeEdgeCosts);
        MatchingAlgorithm.Matching matching = Gmacthing.getMatching();
        ArrayList<ArrayList<Integer>> plan = this.returnPlan((SimpleWeightedGraph<String, DefaultWeightedEdge>)matchingGraph, (MatchingAlgorithm.Matching<String, DefaultWeightedEdge>)matching);
        return plan;
    }

    public ArrayList<ArrayList<Integer>> hungarianAlgorithm_AALMI() {
        int n_dimension = this.getSum(this.shelterRemaining);
        int[][] dataMatrix = new int[n_dimension][n_dimension];
        int i = 0;
        while (i < n_dimension) {
            int[] row = new int[n_dimension];
            int j = 0;
            while (j < n_dimension) {
                row[j] = 0;
                ++j;
            }
            dataMatrix[i] = row;
            ++i;
        }
        i = 0;
        while (i < this.demandSum) {
            int j = 0;
            while (j < n_dimension) {
                int locationI = this.getLocation(this.relocateDemand, i + 1);
                int locationJ = this.getLocation(this.shelterRemaining, j + 1);
                dataMatrix[i][j] = (int)Math.round(this.dMatrix.get(locationI).get(locationJ));
                ++j;
            }
            ++i;
        }
        HungarianAlgorithm_AALMI ha = new HungarianAlgorithm_AALMI(dataMatrix);
        int[][] assignment = ha.findOptimalAssignment();
        if (assignment.length > 0) {
            int i2 = 0;
            while (i2 < assignment.length) {
                ++i2;
            }
        }
        ArrayList<ArrayList<Integer>> AALMI_assignment = new ArrayList<ArrayList<Integer>>();
        if (assignment.length > 0) {
            this.logger.info((Object)assignment.length);
            int i3 = 0;
            while (i3 < assignment.length) {
                ArrayList<Integer> row = new ArrayList<Integer>();
                int j = 0;
                while (j < 2) {
                    row.add(assignment[i3][j]);
                    ++j;
                }
                AALMI_assignment.add(row);
                ++i3;
            }
        }
        this.logger.info((Object)"hungarian_aalmi algorithm");
        return this.returnPlan_AALMI(AALMI_assignment);
    }

    public ArrayList<ArrayList<Integer>> returnPlan_AALMI(ArrayList<ArrayList<Integer>> AALMI_assignment) {
        ArrayList<ArrayList<Integer>> result = new ArrayList<ArrayList<Integer>>();
        int i = 0;
        while (i < this.shelterRemaining.size()) {
            ArrayList<Integer> row = new ArrayList<Integer>();
            int j = 0;
            while (j < this.shelterRemaining.size()) {
                row.add(0);
                ++j;
            }
            result.add(row);
            ++i;
        }
        int count = 0;
        int i2 = 0;
        while (i2 < AALMI_assignment.size()) {
            ArrayList<Integer> assignment = AALMI_assignment.get(i2);
            int assignment_demand = assignment.get(1);
            int assignment_supply = assignment.get(0);
            if (assignment_demand < this.demandSum) {
                int locationI = this.getLocation(this.relocateDemand, assignment_demand + 1);
                int locationJ = this.getLocation(this.shelterRemaining, assignment_supply + 1);
                ++count;
                result.get(locationI).set(locationJ, result.get(locationI).get(locationJ) + 1);
            }
            ++i2;
        }
        return result;
    }

    public int getLocation(ArrayList<Integer> countList, int number) {
        int index = -1;
        int pointer = 0;
        int i = 0;
        while (i < countList.size()) {
            if ((pointer += countList.get(i).intValue()) >= number) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public ArrayList<ArrayList<Integer>> returnPlan(SimpleWeightedGraph<String, DefaultWeightedEdge> matchingGraph, MatchingAlgorithm.Matching<String, DefaultWeightedEdge> matching) {
        ArrayList<ArrayList<Integer>> result = new ArrayList<ArrayList<Integer>>();
        int i = 0;
        while (i < this.shelterRemaining.size()) {
            ArrayList<Integer> row = new ArrayList<Integer>();
            int j = 0;
            while (j < this.shelterRemaining.size()) {
                row.add(0);
                ++j;
            }
            result.add(row);
            ++i;
        }
        Set matchingEdges = matching.getEdges();
        for (DefaultWeightedEdge edge : matchingEdges) {
            int locationJ;
            int locationI;
            String str1 = (String)matchingGraph.getEdgeSource((Object)edge);
            String str2 = (String)matchingGraph.getEdgeTarget((Object)edge);
            String str1First = str1.substring(0, 2);
            int str1Number = Integer.parseInt(str1.substring(2));
            String str2First = str2.substring(0, 2);
            int str2Number = Integer.parseInt(str2.substring(2));
            if (str1First.equals("de") && str2First.equals("su")) {
                locationI = this.getLocation(this.relocateDemand, str1Number);
                locationJ = this.getLocation(this.shelterRemaining, str2Number);
                result.get(locationI).set(locationJ, result.get(locationI).get(locationJ) + 1);
            }
            if (!str1First.equals("su") || !str2First.equals("de")) continue;
            locationI = this.getLocation(this.relocateDemand, str2Number);
            locationJ = this.getLocation(this.shelterRemaining, str1Number);
            result.get(locationI).set(locationJ, result.get(locationI).get(locationJ) + 1);
        }
        return result;
    }

    public int getSum(ArrayList<Integer> xList) {
        int xSum = 0;
        int i = 0;
        while (i < xList.size()) {
            xSum += xList.get(i).intValue();
            ++i;
        }
        return xSum;
    }
}

