/*
 * Decompiled with CFR 0.152.
 */
package evacSim.routing;

import evacSim.ContextCreator;
import java.util.Arrays;
import java.util.LinkedHashSet;

public class HungarianAlgorithm_AALMI {
    int[][] matrix;
    int[] squareInRow;
    int[] squareInCol;
    int[] rowIsCovered;
    int[] colIsCovered;
    int[] staredZeroesInRow;

    public HungarianAlgorithm_AALMI(int[][] matrix) {
        if (matrix.length != matrix[0].length) {
            try {
                throw new IllegalAccessException("The matrix is not square!");
            }
            catch (IllegalAccessException ex) {
                ContextCreator.logger.error((Object)ex);
                System.exit(1);
            }
        }
        this.matrix = matrix;
        this.squareInRow = new int[matrix.length];
        this.squareInCol = new int[matrix[0].length];
        this.rowIsCovered = new int[matrix.length];
        this.colIsCovered = new int[matrix[0].length];
        this.staredZeroesInRow = new int[matrix.length];
        Arrays.fill(this.staredZeroesInRow, -1);
        Arrays.fill(this.squareInRow, -1);
        Arrays.fill(this.squareInCol, -1);
    }

    public int[][] findOptimalAssignment() {
        this.step1();
        this.step2();
        this.step3();
        while (!this.allColumnsAreCovered()) {
            int[] mainZero = this.step4();
            while (mainZero == null) {
                this.step7();
                mainZero = this.step4();
            }
            if (this.squareInRow[mainZero[0]] == -1) {
                this.step6(mainZero);
                this.step3();
                continue;
            }
            this.rowIsCovered[mainZero[0]] = 1;
            this.colIsCovered[this.squareInRow[mainZero[0]]] = 0;
            this.step7();
        }
        int[][] optimalAssignment = new int[this.matrix.length][];
        int i = 0;
        while (i < this.squareInCol.length) {
            optimalAssignment[i] = new int[]{i, this.squareInCol[i]};
            ++i;
        }
        return optimalAssignment;
    }

    private boolean allColumnsAreCovered() {
        int[] nArray = this.colIsCovered;
        int n = this.colIsCovered.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (i == 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void step1() {
        int k;
        int j;
        int i = 0;
        while (i < this.matrix.length) {
            int currentRowMin = Integer.MAX_VALUE;
            j = 0;
            while (j < this.matrix[i].length) {
                if (this.matrix[i][j] < currentRowMin) {
                    currentRowMin = this.matrix[i][j];
                }
                ++j;
            }
            k = 0;
            while (k < this.matrix[i].length) {
                int[] nArray = this.matrix[i];
                int n = k++;
                nArray[n] = nArray[n] - currentRowMin;
            }
            ++i;
        }
        i = 0;
        while (i < this.matrix[0].length) {
            int currentColMin = Integer.MAX_VALUE;
            j = 0;
            while (j < this.matrix.length) {
                if (this.matrix[j][i] < currentColMin) {
                    currentColMin = this.matrix[j][i];
                }
                ++j;
            }
            k = 0;
            while (k < this.matrix.length) {
                int[] nArray = this.matrix[k];
                int n = i;
                nArray[n] = nArray[n] - currentColMin;
                ++k;
            }
            ++i;
        }
    }

    private void step2() {
        int[] rowHasSquare = new int[this.matrix.length];
        int[] colHasSquare = new int[this.matrix[0].length];
        int i = 0;
        while (i < this.matrix.length) {
            int j = 0;
            while (j < this.matrix.length) {
                if (this.matrix[i][j] == 0 && rowHasSquare[i] == 0 && colHasSquare[j] == 0) {
                    rowHasSquare[i] = 1;
                    colHasSquare[j] = 1;
                    this.squareInRow[i] = j;
                    this.squareInCol[j] = i;
                }
                ++j;
            }
            ++i;
        }
    }

    private void step3() {
        int i = 0;
        while (i < this.squareInCol.length) {
            this.colIsCovered[i] = this.squareInCol[i] != -1 ? 1 : 0;
            ++i;
        }
    }

    private void step7() {
        int j;
        int minUncoveredValue = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.matrix.length) {
            if (this.rowIsCovered[i] != 1) {
                j = 0;
                while (j < this.matrix[0].length) {
                    if (this.colIsCovered[j] == 0 && this.matrix[i][j] < minUncoveredValue) {
                        minUncoveredValue = this.matrix[i][j];
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (minUncoveredValue > 0) {
            i = 0;
            while (i < this.matrix.length) {
                j = 0;
                while (j < this.matrix[0].length) {
                    if (this.rowIsCovered[i] == 1 && this.colIsCovered[j] == 1) {
                        int[] nArray = this.matrix[i];
                        int n = j;
                        nArray[n] = nArray[n] + minUncoveredValue;
                    } else if (this.rowIsCovered[i] == 0 && this.colIsCovered[j] == 0) {
                        int[] nArray = this.matrix[i];
                        int n = j;
                        nArray[n] = nArray[n] - minUncoveredValue;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private int[] step4() {
        int i = 0;
        while (i < this.matrix.length) {
            if (this.rowIsCovered[i] == 0) {
                int j = 0;
                while (j < this.matrix[i].length) {
                    if (this.matrix[i][j] == 0 && this.colIsCovered[j] == 0) {
                        this.staredZeroesInRow[i] = j;
                        return new int[]{i, j};
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    private void step6(int[] mainZero) {
        int i = mainZero[0];
        int j = mainZero[1];
        LinkedHashSet<int[]> K = new LinkedHashSet<int[]>();
        K.add(mainZero);
        boolean found = false;
        do {
            if (this.squareInCol[j] != -1) {
                K.add(new int[]{this.squareInCol[j], j});
                found = true;
            } else {
                found = false;
            }
            if (!found) break;
            i = this.squareInCol[j];
            if ((j = this.staredZeroesInRow[i]) != -1) {
                K.add(new int[]{i, j});
                found = true;
                continue;
            }
            found = false;
        } while (found);
        for (int[] zero : K) {
            if (this.squareInCol[zero[1]] == zero[0]) {
                this.squareInCol[zero[1]] = -1;
                this.squareInRow[zero[0]] = -1;
            }
            if (this.staredZeroesInRow[zero[0]] != zero[1]) continue;
            this.squareInRow[zero[0]] = zero[1];
            this.squareInCol[zero[1]] = zero[0];
        }
        Arrays.fill(this.staredZeroesInRow, -1);
        Arrays.fill(this.rowIsCovered, 0);
        Arrays.fill(this.colIsCovered, 0);
    }
}

