/*
 * Decompiled with CFR 0.152.
 */
package evacSim.partition;

import evacSim.partition.KeyValue;
import evacSim.partition.ListNode;
import evacSim.partition.MetisNode;
import galois.objects.graph.GNode;
import java.util.Arrays;

public class PQueue {
    private int nnodes = 0;
    private int type;
    private int maxgain;
    private int pgainspan;
    private int ngainspan;
    private ListNode[] nodes;
    private ListNode[] buckets;
    private int bucketIndex;
    private KeyValue[] heap;
    private int[] locator;
    private final int PLUS_GAINSPAN = 500;
    private final int NEG_GAINSPAN = 500;

    public PQueue(int maxnodes, int maxgain) {
        this.type = maxgain > 500 || maxnodes < 500 ? 2 : 1;
        if (this.type == 1) {
            this.pgainspan = Math.min(500, maxgain);
            this.ngainspan = Math.min(500, maxgain);
            int j = this.ngainspan + this.pgainspan + 1;
            this.nodes = new ListNode[maxnodes];
            this.buckets = new ListNode[j];
            this.bucketIndex = this.ngainspan;
            this.maxgain -= this.ngainspan;
        } else {
            this.heap = new KeyValue[maxnodes];
            int i = 0;
            while (i < maxnodes) {
                this.heap[i] = new KeyValue();
                ++i;
            }
            this.locator = new int[maxnodes];
            Arrays.fill(this.locator, -1);
        }
    }

    public void insert(GNode<MetisNode> node, int gain) {
        if (this.type == 1) {
            ++this.nnodes;
            int id = node.getData().getNodeId();
            this.nodes[id] = new ListNode(node);
            ListNode newNode = this.nodes[id];
            newNode.next = this.buckets[gain + this.bucketIndex];
            if (newNode.next != null) {
                newNode.next.prev = newNode;
            }
            this.buckets[gain + this.bucketIndex] = newNode;
            if (this.maxgain < gain) {
                this.maxgain = gain;
            }
        } else {
            int i = this.nnodes++;
            while (i > 0) {
                int j = (i - 1) / 2;
                if (this.heap[j].key >= gain) break;
                this.heap[i].key = this.heap[j].key;
                this.heap[i].value = this.heap[j].value;
                this.locator[this.heap[i].value.getData().getNodeId()] = i;
                i = j;
            }
            this.heap[i].key = gain;
            this.heap[i].value = node;
            this.locator[node.getData().getNodeId()] = i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void delete(GNode<MetisNode> value, int gain) {
        block15: {
            block14: {
                if (this.type != 1) break block14;
                --this.nnodes;
                node = this.nodes[value.getData().getNodeId()];
                if (node.prev != null) {
                    node.prev.next = node.next;
                } else {
                    this.buckets[gain + this.bucketIndex] = node.next;
                }
                if (node.next != null) {
                    node.next.prev = node.prev;
                }
                if (this.buckets[gain + this.bucketIndex] != null || gain != this.maxgain) break block15;
                if (this.nnodes != 0) ** GOTO lbl15
                this.maxgain = -this.ngainspan;
                break block15;
lbl-1000:
                // 1 sources

                {
                    --this.maxgain;
lbl15:
                    // 2 sources

                    ** while (this.buckets[this.maxgain + this.bucketIndex] == null)
                }
lbl16:
                // 1 sources

                break block15;
            }
            id = value.getData().getNodeId();
            i = this.locator[id];
            this.locator[id] = -1;
            if (--this.nnodes > 0 && this.heap[this.nnodes].value.getData().getNodeId() != id) {
                value = this.heap[this.nnodes].value;
                oldgain = this.heap[i].key;
                newgain = this.heap[this.nnodes].key;
                if (oldgain < newgain) {
                    while (i > 0) {
                        j = i - 1 >> 1;
                        if (this.heap[j].key < newgain) {
                            this.heap[i].value = this.heap[j].value;
                            this.heap[i].key = this.heap[j].key;
                            this.locator[this.heap[i].value.getData().getNodeId()] = i;
                            i = j;
                            continue;
                        }
                        break;
                    }
                } else {
                    j = 0;
                    while ((j = 2 * i + 1) < this.nnodes) {
                        if (this.heap[j].key > newgain) {
                            if (j + 1 < this.nnodes && this.heap[j + 1].key > this.heap[j].key) {
                                ++j;
                            }
                            this.heap[i].value = this.heap[j].value;
                            this.heap[i].key = this.heap[j].key;
                            this.locator[this.heap[i].value.getData().getNodeId()] = i;
                            i = j;
                            continue;
                        }
                        if (j + 1 < this.nnodes && this.heap[j + 1].key > newgain) {
                            this.heap[i].value = this.heap[++j].value;
                            this.heap[i].key = this.heap[j].key;
                            this.locator[this.heap[i].value.getData().getNodeId()] = i;
                            i = j;
                            continue;
                        }
                        break;
                    }
                }
                this.heap[i].key = newgain;
                this.heap[i].value = value;
                this.locator[value.getData().getNodeId()] = i;
            }
        }
    }

    public void update(GNode<MetisNode> value, int oldgain, int newgain) {
        if (this.type == 1) {
            this.delete(value, oldgain);
            this.insert(value, newgain);
        } else {
            int i = this.locator[value.getData().getNodeId()];
            if (oldgain < newgain) {
                while (i > 0) {
                    int j = i - 1 >> 1;
                    if (this.heap[j].key < newgain) {
                        this.heap[i].value = this.heap[j].value;
                        this.heap[i].key = this.heap[j].key;
                        this.locator[this.heap[i].value.getData().getNodeId()] = i;
                        i = j;
                        continue;
                    }
                    break;
                }
            } else {
                int j = 0;
                while ((j = 2 * i + 1) < this.nnodes) {
                    if (this.heap[j].key > newgain) {
                        if (j + 1 < this.nnodes && this.heap[j + 1].key > this.heap[j].key) {
                            ++j;
                        }
                        this.heap[i].value = this.heap[j].value;
                        this.heap[i].key = this.heap[j].key;
                        this.locator[this.heap[i].value.getData().getNodeId()] = i;
                        i = j;
                        continue;
                    }
                    if (j + 1 < this.nnodes && this.heap[j + 1].key > newgain) {
                        this.heap[i].value = this.heap[++j].value;
                        this.heap[i].key = this.heap[j].key;
                        this.locator[this.heap[i].value.getData().getNodeId()] = i;
                        i = j;
                        continue;
                    }
                    break;
                }
            }
            this.heap[i].key = newgain;
            this.heap[i].value = value;
            this.locator[value.getData().getNodeId()] = i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public GNode<MetisNode> getMax() {
        block6: {
            block8: {
                block7: {
                    if (this.nnodes == 0) {
                        return null;
                    }
                    tptr = null;
                    --this.nnodes;
                    if (this.type != 1) break block6;
                    tptr = this.buckets[this.maxgain + this.bucketIndex];
                    this.buckets[this.maxgain + this.bucketIndex] = tptr.next;
                    if (tptr.next == null) break block7;
                    tptr.next.prev = null;
                    break block8;
                }
                if (this.nnodes != 0) ** GOTO lbl16
                this.maxgain = -this.ngainspan;
                break block8;
lbl-1000:
                // 1 sources

                {
                    --this.maxgain;
lbl16:
                    // 2 sources

                    ** while (this.buckets[this.maxgain + this.bucketIndex] == null)
                }
            }
            return tptr.value;
        }
        vtx = this.heap[0].value;
        this.locator[vtx.getData().getNodeId()] = -1;
        i = this.nnodes;
        if (i > 0) {
            gain = this.heap[i].key;
            node = this.heap[i].value;
            i = 0;
            j = 0;
            while ((j = 2 * i + 1) < this.nnodes) {
                if (this.heap[j].key > gain) {
                    if (j + 1 < this.nnodes && this.heap[j + 1].key > this.heap[j].key) {
                        ++j;
                    }
                    this.heap[i].value = this.heap[j].value;
                    this.heap[i].key = this.heap[j].key;
                    this.locator[this.heap[i].value.getData().getNodeId()] = i;
                    i = j;
                    continue;
                }
                if (j + 1 >= this.nnodes || this.heap[j + 1].key <= gain) break;
                this.heap[i].value = this.heap[++j].value;
                this.heap[i].key = this.heap[j].key;
                this.locator[this.heap[i].value.getData().getNodeId()] = i;
                i = j;
            }
            this.heap[i].key = gain;
            this.heap[i].value = node;
            this.locator[node.getData().getNodeId()] = i;
        }
        return vtx;
    }

    public void reset() {
        this.nnodes = 0;
        if (this.type == 1) {
            this.maxgain = -this.ngainspan;
            int j = this.ngainspan + this.pgainspan + 1;
            int i = 0;
            while (i < j) {
                this.buckets[i] = null;
                ++i;
            }
            this.bucketIndex = this.ngainspan;
        } else {
            Arrays.fill(this.locator, -1);
        }
    }
}

