/*
 * Decompiled with CFR 0.152.
 */
package evacSim.partition;

import evacSim.partition.Coarsener;
import evacSim.partition.GrowBisection;
import evacSim.partition.MetisGraph;
import evacSim.partition.MetisNode;
import evacSim.partition.Refiner;
import galois.objects.graph.GNode;
import galois.objects.graph.IntGraph;
import galois.objects.graph.MorphGraph;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import util.fn.Lambda2Void;
import util.fn.LambdaVoid;

public class PMetis {
    public static double UB_FACTOR = 1.0;
    public static Coarsener coarsener;

    public PMetis(int coasenTo, int maxVertexWeight) {
        coarsener = new Coarsener(true, coasenTo, maxVertexWeight);
    }

    public static void partition(MetisGraph metisGraph, int nparts) throws ExecutionException {
        int maxVertexWeight = (int)(1.5 * ((double)metisGraph.getGraph().size() / 0.9));
        MetisGraph.nparts = 2;
        float[] totalPartitionWeights = new float[nparts];
        Arrays.fill(totalPartitionWeights, 1.0f / (float)nparts);
        metisGraph.computeAdjWgtSums();
        PMetis pmetis = new PMetis(maxVertexWeight, 20);
        pmetis.mlevelRecursiveBisection(metisGraph, nparts, totalPartitionWeights, 0, 0);
    }

    protected void mlevelRecursiveBisection(MetisGraph metisGraph, int nparts, float[] totalPartWeights, int tpindex, final int partStartIndex) throws ExecutionException {
        int[] bisectionWeights;
        IntGraph<MetisNode> graph = metisGraph.getGraph();
        TotalWeightClosure totalWeightClosure = new TotalWeightClosure();
        graph.map(totalWeightClosure);
        int totalVertexWeight = totalWeightClosure.totalVertexWeight;
        float vertexWeightRatio = 0.0f;
        int i = 0;
        while (i < nparts / 2) {
            vertexWeightRatio += totalPartWeights[tpindex + i];
            ++i;
        }
        bisectionWeights = new int[]{(int)((float)totalVertexWeight * vertexWeightRatio), totalVertexWeight - bisectionWeights[0]};
        MetisGraph mcg = coarsener.coarsen(metisGraph);
        GrowBisection.bisection(mcg, bisectionWeights, coarsener.getCoarsenTo());
        Refiner.refineTwoWay(mcg, metisGraph, bisectionWeights);
        if (nparts <= 2) {
            graph.map(new LambdaVoid<GNode<MetisNode>>(){

                @Override
                public void call(GNode<MetisNode> node) {
                    node.getData().setPartition(node.getData().getPartition() + partStartIndex);
                }
            });
        } else {
            int i2 = 0;
            while (i2 < nparts / 2) {
                int n = i2 + tpindex;
                totalPartWeights[n] = totalPartWeights[n] * (1.0f / vertexWeightRatio);
                ++i2;
            }
            i2 = 0;
            while (i2 < nparts - nparts / 2) {
                int n = i2 + tpindex + nparts / 2;
                totalPartWeights[n] = totalPartWeights[n] * (1.0f / vertexWeightRatio);
                ++i2;
            }
            MetisGraph[] subGraphs = PMetis.splitGraph(metisGraph);
            if (nparts > 3) {
                this.mlevelRecursiveBisection(subGraphs[0], nparts / 2, totalPartWeights, tpindex, partStartIndex);
                this.mlevelRecursiveBisection(subGraphs[1], nparts - nparts / 2, totalPartWeights, tpindex + nparts / 2, partStartIndex + nparts / 2);
                metisGraph.setMinCut(metisGraph.getMinCut() + subGraphs[0].getMinCut() + subGraphs[1].getMinCut());
            } else if (nparts == 3) {
                subGraphs[0].getGraph().map(new LambdaVoid<GNode<MetisNode>>(){

                    @Override
                    public void call(GNode<MetisNode> node) {
                        MetisNode nodeData = node.getData();
                        nodeData.setPartition(nodeData.getPartition() + partStartIndex);
                    }
                });
                this.mlevelRecursiveBisection(subGraphs[1], nparts - nparts / 2, totalPartWeights, tpindex + nparts / 2, partStartIndex + nparts / 2);
                metisGraph.setMinCut(metisGraph.getMinCut() + subGraphs[1].getMinCut());
            }
            graph.map(new LambdaVoid<GNode<MetisNode>>(){

                @Override
                public void call(GNode<MetisNode> node) {
                    MetisNode nodeData = node.getData();
                    nodeData.setPartition(nodeData.getSubGraphMap().getData().getPartition());
                }
            });
        }
    }

    private static MetisGraph[] splitGraph(MetisGraph metisGraph) {
        final int[] subGraphNodeNum = new int[2];
        final IntGraph<MetisNode> graph = metisGraph.getGraph();
        final MetisGraph[] subGraphs = new MetisGraph[]{new MetisGraph(), new MetisGraph()};
        IntGraph<MetisNode> empty = new MorphGraph.IntGraphBuilder().backedByVector(true).directed(true).serial(true).create();
        subGraphs[0].setGraph(empty);
        empty = new MorphGraph.IntGraphBuilder().backedByVector(true).directed(true).serial(true).create();
        subGraphs[1].setGraph(empty);
        graph.map(new LambdaVoid<GNode<MetisNode>>(){

            @Override
            public void call(GNode<MetisNode> node) {
                MetisNode nodeData = node.getData();
                GNode<MetisNode> newNode = subGraphs[nodeData.getPartition()].getGraph().createNode(new MetisNode(subGraphNodeNum[nodeData.getPartition()], nodeData.getWeight()));
                nodeData.setSubGraphMap(newNode);
                int n = nodeData.getPartition();
                subGraphNodeNum[n] = subGraphNodeNum[n] + 1;
            }
        });
        graph.map(new LambdaVoid<GNode<MetisNode>>(){

            @Override
            public void call(GNode<MetisNode> node) {
                MetisNode nodeData = node.getData();
                subGraphs[nodeData.getPartition()].getGraph().add(nodeData.getSubGraphMap());
            }
        });
        graph.map(new LambdaVoid<GNode<MetisNode>>(){

            @Override
            public void call(GNode<MetisNode> node) {
                final MetisNode nodeData = node.getData();
                int index = nodeData.getPartition();
                final IntGraph<MetisNode> subGraph = subGraphs[index].getGraph();
                nodeData.getSubGraphMap().getData().setAdjWgtSum(nodeData.getAdjWgtSum());
                node.map(new Lambda2Void<GNode<MetisNode>, GNode<MetisNode>>(){

                    @Override
                    public void call(GNode<MetisNode> neighbor, GNode<MetisNode> node) {
                        MetisNode neighborData = neighbor.getData();
                        int edgeWeight = graph.getEdgeData(node, neighbor);
                        if (!nodeData.isBoundary() || nodeData.getPartition() == neighborData.getPartition()) {
                            subGraph.addEdge(nodeData.getSubGraphMap(), neighborData.getSubGraphMap(), edgeWeight);
                        } else {
                            nodeData.getSubGraphMap().getData().setAdjWgtSum(nodeData.getSubGraphMap().getData().getAdjWgtSum() - edgeWeight);
                        }
                    }
                }, node);
            }
        });
        return subGraphs;
    }

    public static class TotalWeightClosure
    implements LambdaVoid<GNode<MetisNode>> {
        int totalVertexWeight = 0;

        @Override
        public void call(GNode<MetisNode> node) {
            this.totalVertexWeight += node.getData().getWeight();
        }
    }
}

