/*
 * Decompiled with CFR 0.152.
 */
package evacSim.partition;

import evacSim.partition.MetisNode;
import galois.objects.graph.GNode;
import galois.objects.graph.IntGraph;
import util.fn.Lambda2Void;
import util.fn.LambdaVoid;

public class HEMatchingStrategy
implements LambdaVoid<GNode<MetisNode>> {
    private int maxVertexWeight;
    IntGraph<MetisNode> graph;
    IntGraph<MetisNode> coarseGraph;

    public HEMatchingStrategy(IntGraph<MetisNode> graph, IntGraph<MetisNode> coarseGraph, int maxVertexWeight) {
        this.graph = graph;
        this.coarseGraph = coarseGraph;
        this.maxVertexWeight = maxVertexWeight;
    }

    @Override
    public void call(GNode<MetisNode> node) {
        MetisNode nodeData = node.getData((byte)1, (byte)0);
        if (nodeData.isMatched()) {
            return;
        }
        FindMaxUnmatchedNeighborClosure closure = new FindMaxUnmatchedNeighborClosure(node);
        node.map(closure, node, (byte)1);
        GNode<MetisNode> match = closure.maxNode;
        MetisNode matchNodeData = match.getData((byte)0, (byte)0);
        nodeData.setMatch(match);
        matchNodeData.setMatch(node);
        int weight = nodeData.getWeight();
        if (node != match) {
            weight += matchNodeData.getWeight();
        }
        MetisNode newNodeData = new MetisNode(weight);
        GNode<MetisNode> newNode = this.coarseGraph.createNode(newNodeData);
        this.coarseGraph.add(newNode);
        nodeData.setMapTo(newNode);
        matchNodeData.setMapTo(newNode);
    }

    class FindMaxUnmatchedNeighborClosure
    implements Lambda2Void<GNode<MetisNode>, GNode<MetisNode>> {
        int maxwgt = Integer.MIN_VALUE;
        GNode<MetisNode> maxNode;
        GNode<MetisNode> temp;

        public FindMaxUnmatchedNeighborClosure(GNode<MetisNode> node) {
            this.maxNode = node;
            this.temp = node;
        }

        @Override
        public void call(GNode<MetisNode> neighbor, GNode<MetisNode> node) {
            assert (node == this.temp);
            assert (neighbor != this.temp);
            MetisNode nodeData = node.getData((byte)0, (byte)0);
            long edgeData = HEMatchingStrategy.this.graph.getEdgeData(node, neighbor, (byte)0);
            MetisNode neighborData = neighbor.getData((byte)0, (byte)0);
            if (!neighborData.isMatched() && (long)this.maxwgt < edgeData && nodeData.getWeight() + neighborData.getWeight() <= HEMatchingStrategy.this.maxVertexWeight) {
                this.maxwgt = neighborData.getWeight();
                this.maxNode = neighbor;
            }
        }
    }
}

