/*
 * Decompiled with CFR 0.152.
 */
package evacSim.partition;

import evacSim.partition.MetisGraph;
import evacSim.partition.MetisNode;
import evacSim.partition.PQueue;
import galois.objects.graph.GNode;
import galois.objects.graph.IntGraph;
import java.util.Arrays;
import util.fn.Lambda2Void;

public class FMTwoWayRefiner {
    static final UpdateNeighborClosure updateNeighborClosure = new UpdateNeighborClosure();
    private static final PQueue[] parts = new PQueue[2];

    public static void fmTwoWayEdgeRefine(MetisGraph metisGraph, int[] tpwgts, int npasses) {
        IntGraph<MetisNode> graph = metisGraph.getGraph();
        int numNodes = graph.size();
        GNode[] swaps = new GNode[numNodes];
        int[] moved = new int[numNodes];
        FMTwoWayRefiner.parts[0] = new PQueue(numNodes, metisGraph.getMaxAdjSum());
        FMTwoWayRefiner.parts[1] = new PQueue(numNodes, metisGraph.getMaxAdjSum());
        int limit = Math.min(Math.max((int)(0.01 * (double)numNodes), 15), 100);
        int totalWeight = metisGraph.getPartWeight(0) + metisGraph.getPartWeight(1);
        int avgvwgt = Math.min(totalWeight, 2 * totalWeight / numNodes);
        Arrays.fill(moved, -1);
        int origdiff = Math.abs(tpwgts[0] - metisGraph.getPartWeight(0));
        int pass = 0;
        while (pass < npasses) {
            int newcut;
            parts[0].reset();
            parts[1].reset();
            int mincut = newcut = metisGraph.getMinCut();
            int initcut = newcut;
            for (GNode<MetisNode> boundaryNode : metisGraph.getBoundaryNodes()) {
                MetisNode boundaryNodeData = boundaryNode.getData();
                boundaryNodeData.updateGain();
                parts[boundaryNodeData.getPartition()].insert(boundaryNode, boundaryNodeData.getGain());
            }
            int mindiff = Math.abs(tpwgts[0] - metisGraph.getPartWeight(0));
            int mincutorder = -1;
            int nswaps = 0;
            while (nswaps < numNodes) {
                GNode<MetisNode> higain;
                int from = 1;
                int to = 0;
                if (tpwgts[0] - metisGraph.getPartWeight(0) < tpwgts[1] - metisGraph.getPartWeight(1)) {
                    from = 0;
                    to = 1;
                }
                if ((higain = parts[from].getMax()) == null) break;
                MetisNode higainData = higain.getData();
                metisGraph.incPartWeight(from, -higainData.getWeight());
                metisGraph.incPartWeight(to, higainData.getWeight());
                if ((newcut -= higainData.getGain()) < mincut && Math.abs(tpwgts[0] - metisGraph.getPartWeight(0)) <= origdiff + avgvwgt || newcut == mincut && Math.abs(tpwgts[0] - metisGraph.getPartWeight(0)) < mindiff) {
                    mincut = newcut;
                    mindiff = Math.abs(tpwgts[0] - metisGraph.getPartWeight(0));
                    mincutorder = nswaps;
                } else if (nswaps - mincutorder > limit) {
                    newcut += higainData.getEdegree() - higainData.getIdegree();
                    metisGraph.incPartWeight(from, higainData.getWeight());
                    metisGraph.incPartWeight(to, -higainData.getWeight());
                    break;
                }
                FMTwoWayRefiner.moveNode(metisGraph, higain, to, moved, swaps, nswaps);
                ++nswaps;
            }
            int i = 0;
            while (i < nswaps) {
                moved[((MetisNode)swaps[i].getData()).getNodeId()] = -1;
                ++i;
            }
            --nswaps;
            while (nswaps > mincutorder) {
                FMTwoWayRefiner.moveBackNode(metisGraph, swaps[nswaps]);
                --nswaps;
            }
            metisGraph.setMinCut(mincut);
            if (mincutorder == -1 || mincut == initcut) break;
            ++pass;
        }
    }

    private static void moveNode(final MetisGraph metisGraph, final GNode<MetisNode> higain, final int to, final int[] moved, GNode<MetisNode>[] swaps, int nswaps) {
        final IntGraph<MetisNode> graph = metisGraph.getGraph();
        MetisNode higainData = higain.getData();
        higainData.setPartition(to);
        moved[higainData.getNodeId()] = nswaps;
        swaps[nswaps] = higain;
        higainData.swapEDAndID();
        higainData.updateGain();
        if (higainData.getEdegree() == 0 && graph.outNeighborsSize(higain) > 0) {
            metisGraph.unsetBoundaryNode(higain);
        }
        higain.map(new Lambda2Void<GNode<MetisNode>, GNode<MetisNode>>(){

            @Override
            public void call(GNode<MetisNode> neighbor, GNode<MetisNode> node) {
                MetisNode neighborData = neighbor.getData();
                int oldgain = neighborData.getGain();
                int edgeWeight = graph.getEdgeData(higain, neighbor);
                int kwgt = to == neighborData.getPartition() ? edgeWeight : -edgeWeight;
                neighborData.setEdegree(neighborData.getEdegree() - kwgt);
                neighborData.setIdegree(neighborData.getIdegree() + kwgt);
                neighborData.updateGain();
                if (neighborData.isBoundary()) {
                    if (neighborData.getEdegree() == 0) {
                        metisGraph.unsetBoundaryNode(neighbor);
                        if (moved[neighborData.getNodeId()] == -1) {
                            parts[neighborData.getPartition()].delete(neighbor, oldgain);
                        }
                    } else if (moved[neighborData.getNodeId()] == -1) {
                        parts[neighborData.getPartition()].update(neighbor, oldgain, neighborData.getGain());
                    }
                } else if (neighborData.getEdegree() > 0) {
                    metisGraph.setBoundaryNode(neighbor);
                    if (moved[neighborData.getNodeId()] == -1) {
                        parts[neighborData.getPartition()].insert(neighbor, neighborData.getGain());
                    }
                }
            }
        }, higain);
    }

    private static void moveBackNode(MetisGraph metisGraph, GNode<MetisNode> higain) {
        IntGraph<MetisNode> graph = metisGraph.getGraph();
        MetisNode higainData = higain.getData();
        int to = (higainData.getPartition() + 1) % 2;
        higainData.setPartition(to);
        higainData.swapEDAndID();
        higainData.updateGain();
        if (higainData.getEdegree() == 0 && higainData.isBoundary() && graph.outNeighborsSize(higain) > 0) {
            metisGraph.unsetBoundaryNode(higain);
        } else if (higainData.getEdegree() > 0 && !higainData.isBoundary()) {
            metisGraph.setBoundaryNode(higain);
        }
        metisGraph.incPartWeight((to + 1) % 2, -higainData.getWeight());
        metisGraph.incPartWeight(to, higainData.getWeight());
        FMTwoWayRefiner.updateNeighborClosure.setParameters(metisGraph, higain, to);
        higain.map(updateNeighborClosure, higain);
    }

    private static final class UpdateNeighborClosure
    implements Lambda2Void<GNode<MetisNode>, GNode<MetisNode>> {
        private MetisGraph metisGraph;
        private GNode<MetisNode> higain;
        private int to;

        private UpdateNeighborClosure() {
        }

        private void setParameters(MetisGraph metisGraph, GNode<MetisNode> higain, int to) {
            this.metisGraph = metisGraph;
            this.higain = higain;
            this.to = to;
        }

        @Override
        public void call(GNode<MetisNode> neighbor, GNode<MetisNode> node) {
            MetisNode neighborData = neighbor.getData();
            int edgeWeight = this.metisGraph.getGraph().getEdgeData(this.higain, neighbor);
            int kwgt = this.to == neighborData.getPartition() ? edgeWeight : -edgeWeight;
            neighborData.setEdegree(neighborData.getEdegree() - kwgt);
            neighborData.setIdegree(neighborData.getIdegree() + kwgt);
            neighborData.updateGain();
            if (neighborData.isBoundary() && neighborData.getEdegree() == 0) {
                this.metisGraph.unsetBoundaryNode(neighbor);
            }
            if (!neighborData.isBoundary() && neighborData.getEdegree() > 0) {
                this.metisGraph.setBoundaryNode(neighbor);
            }
        }
    }
}

