/*
 * Decompiled with CFR 0.152.
 */
package evacSim.partition;

import evacSim.partition.HEMatchingStrategy;
import evacSim.partition.MetisGraph;
import evacSim.partition.MetisNode;
import evacSim.partition.RMMatchingStrategy;
import evacSim.partition.Utility;
import galois.objects.graph.GNode;
import galois.objects.graph.IntGraph;
import galois.objects.graph.MorphGraph;
import galois.runtime.ForeachContext;
import galois.runtime.GaloisRuntime;
import galois.runtime.wl.Priority;
import galois.runtime.wl.RandomPermutation;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import util.fn.Lambda2Void;
import util.fn.LambdaVoid;

public class Coarsener {
    private final int coarsenTo;
    public static final double COARSEN_FRACTION = 0.9;
    private final int maxVertexWeight;
    private final boolean useSerial;
    private IntGraph<MetisNode> graph;

    public Coarsener(boolean userSerial, int coarsenTo, int maxVertexWeight) {
        this.useSerial = userSerial;
        this.coarsenTo = coarsenTo;
        this.maxVertexWeight = maxVertexWeight;
    }

    public int getCoarsenTo() {
        return this.coarsenTo;
    }

    public MetisGraph coarsen(MetisGraph metisGraph) throws ExecutionException {
        boolean notFirstTime = false;
        do {
            if (metisGraph.getGraph().size() < this.coarsenTo) continue;
            MetisGraph coarseMetisGraph = new MetisGraph();
            IntGraph<MetisNode> coarser = null;
            coarser = this.useSerial ? new MorphGraph.IntGraphBuilder().backedByVector(true).directed(true).serial(true).create() : new MorphGraph.IntGraphBuilder().backedByVector(true).directed(true).create();
            coarseMetisGraph.setGraph(coarser);
            this.graph = metisGraph.getGraph();
            if (this.useSerial) {
                notFirstTime = this.serialMatch(notFirstTime, coarser);
                this.serialCreateCoarserGraph(coarseMetisGraph);
            } else {
                notFirstTime = this.parallelMatch(notFirstTime, coarser);
                this.parallelCreateCoarserGraph(coarseMetisGraph);
            }
            coarser.map(new LambdaVoid<GNode<MetisNode>>(){
                int id = 0;

                @Override
                public void call(GNode<MetisNode> node) {
                    node.getData().setNodeId(this.id++);
                }
            });
            coarseMetisGraph.setNumEdges(coarseMetisGraph.getNumEdges() / 2);
            coarseMetisGraph.setFinerGraph(metisGraph);
            metisGraph = coarseMetisGraph;
        } while (this.isDone(metisGraph));
        return metisGraph;
    }

    private final boolean serialMatch(boolean notFirstTime, IntGraph<MetisNode> coarser) {
        if (notFirstTime) {
            this.graph.map(new HEMatchingStrategy(this.graph, coarser, this.maxVertexWeight));
        } else {
            this.graph.map(new RMMatchingStrategy(this.graph, coarser, this.maxVertexWeight));
            notFirstTime = true;
        }
        return notFirstTime;
    }

    private final boolean parallelMatch(boolean notFirstTime, IntGraph<MetisNode> coarser) throws ExecutionException {
        if (notFirstTime) {
            GaloisRuntime.foreach(Utility.getAllNodes(this.graph), new Lambda2Void<GNode<MetisNode>, ForeachContext<GNode<MetisNode>>>(coarser){
                HEMatchingStrategy match;
                {
                    this.match = new HEMatchingStrategy(Coarsener.this.graph, intGraph, Coarsener.this.maxVertexWeight);
                }

                @Override
                public void call(GNode<MetisNode> item, ForeachContext<GNode<MetisNode>> ctx) {
                    this.match.call(item);
                }
            }, Priority.first(RandomPermutation.class, new Object[0]));
        } else {
            GaloisRuntime.foreach(Utility.getAllNodes(this.graph), new Lambda2Void<GNode<MetisNode>, ForeachContext<GNode<MetisNode>>>(coarser){
                RMMatchingStrategy match;
                {
                    this.match = new RMMatchingStrategy(Coarsener.this.graph, intGraph, Coarsener.this.maxVertexWeight);
                }

                @Override
                public void call(GNode<MetisNode> item, ForeachContext<GNode<MetisNode>> ctx) {
                    this.match.call(item);
                }
            }, Priority.first(RandomPermutation.class, new Object[0]));
            notFirstTime = true;
        }
        return notFirstTime;
    }

    private final boolean isDone(MetisGraph metisGraph) {
        IntGraph<MetisNode> graph = metisGraph.getGraph();
        int size = graph.size();
        return size > this.coarsenTo && (double)size < 0.9 * (double)metisGraph.getFinerGraph().getGraph().size() && metisGraph.getNumEdges() > size / 2;
    }

    private final MetisGraph serialCreateCoarserGraph(MetisGraph coarseMetisGraph) {
        boolean[] visited = new boolean[this.graph.size()];
        this.graph.map(new AddEdgesClosure(visited, coarseMetisGraph));
        return coarseMetisGraph;
    }

    private final MetisGraph parallelCreateCoarserGraph(MetisGraph coarseMetisGraph) throws ExecutionException {
        boolean[] visited = new boolean[this.graph.size()];
        final AddEdgesClosure closure = new AddEdgesClosure(visited, coarseMetisGraph);
        GaloisRuntime.foreach(Utility.getAllNodes(this.graph), new Lambda2Void<GNode<MetisNode>, ForeachContext<GNode<MetisNode>>>(){

            @Override
            public void call(GNode<MetisNode> item, ForeachContext<GNode<MetisNode>> ctx) {
                MetisNode nodeData = item.getData((byte)1, (byte)0);
                GNode<MetisNode> matched = nodeData.getMatch();
                if (!GaloisRuntime.getRuntime().useSerial()) {
                    matched.map(new Lambda2Void<GNode<MetisNode>, GNode<MetisNode>>(){

                        @Override
                        public void call(GNode<MetisNode> dst, GNode<MetisNode> src) {
                            dst.getData((byte)1, (byte)0).getMapTo().getData((byte)1, (byte)0);
                        }
                    }, matched, (byte)1);
                    item.map(new Lambda2Void<GNode<MetisNode>, GNode<MetisNode>>(){

                        @Override
                        public void call(GNode<MetisNode> dst, GNode<MetisNode> src) {
                            dst.getData((byte)1, (byte)0).getMapTo().getData((byte)1, (byte)0);
                        }
                    }, item, (byte)1);
                }
                closure.call(item);
            }
        }, Priority.first(RandomPermutation.class, new Object[0]));
        return coarseMetisGraph;
    }

    class AddEdgesClosure
    implements LambdaVoid<GNode<MetisNode>> {
        private boolean[] visited;
        private MetisGraph coarseMetisGraph;

        public AddEdgesClosure(boolean[] visited, MetisGraph coarseMetisGraph) {
            this.visited = visited;
            this.coarseMetisGraph = coarseMetisGraph;
        }

        @Override
        public void call(GNode<MetisNode> node) {
            MetisNode nodeData = node.getData((byte)0);
            if (this.visited[nodeData.getNodeId()]) {
                return;
            }
            LinkedHashMap<GNode<MetisNode>, Integer> map = new LinkedHashMap<GNode<MetisNode>, Integer>();
            GNode<MetisNode> matched = nodeData.getMatch();
            MetisNode matchedData = matched.getData((byte)0);
            node.map(new buildNeighborClosure(Coarsener.this.graph, this.coarseMetisGraph, node, matched, map), node);
            if (matched != node) {
                matched.map(new buildNeighborClosure(Coarsener.this.graph, this.coarseMetisGraph, matched, node, map), matched);
            }
            this.visited[matchedData.getNodeId()] = true;
        }
    }

    class buildNeighborClosure
    implements Lambda2Void<GNode<MetisNode>, GNode<MetisNode>> {
        IntGraph<MetisNode> graph;
        MetisGraph coarseMetisGraph;
        GNode<MetisNode> n;
        GNode<MetisNode> matched;
        IntGraph<MetisNode> coarseGraph;
        GNode<MetisNode> nodeMapTo;
        Map<GNode<MetisNode>, Integer> map;

        public buildNeighborClosure(IntGraph<MetisNode> graph, MetisGraph coarseMetisGraph, GNode<MetisNode> n, GNode<MetisNode> matched, Map<GNode<MetisNode>, Integer> map) {
            this.graph = graph;
            this.coarseMetisGraph = coarseMetisGraph;
            this.n = n;
            this.matched = matched;
            this.map = map;
            this.coarseGraph = coarseMetisGraph.getGraph();
            this.nodeMapTo = n.getData((byte)0, (byte)0).getMapTo();
        }

        @Override
        public void call(GNode<MetisNode> neighbor, GNode<MetisNode> src) {
            if (neighbor == this.matched) {
                return;
            }
            int edgeWeight = this.graph.getEdgeData(this.n, neighbor, (byte)0);
            GNode<MetisNode> neighborMapTo = neighbor.getData((byte)0).getMapTo();
            Integer newEdgeWeight = this.map.get(neighborMapTo);
            if (newEdgeWeight == null) {
                this.coarseGraph.addEdge(this.nodeMapTo, neighborMapTo, edgeWeight, (byte)0);
                this.coarseMetisGraph.incNumEdges();
                MetisNode nodeMapToData = this.nodeMapTo.getData((byte)0, (byte)0);
                nodeMapToData.incNumEdges();
                nodeMapToData.addEdgeWeight(edgeWeight);
                this.map.put(neighborMapTo, edgeWeight);
            } else {
                this.map.put(neighborMapTo, edgeWeight + newEdgeWeight);
                this.coarseGraph.setEdgeData(this.nodeMapTo, neighborMapTo, newEdgeWeight + edgeWeight, (byte)0);
                this.nodeMapTo.getData((byte)0, (byte)0).addEdgeWeight(edgeWeight);
            }
        }
    }
}

