/*
 * Decompiled with CFR 0.152.
 */
package evacSim.network;

import evacSim.ContextCreator;
import evacSim.GlobalVariables;
import evacSim.network.Connection;
import java.util.Vector;

public class ConnectionManager {
    private static ConnectionManager instance;
    private Vector<Connection> connections = new Vector();

    private ConnectionManager() {
        if (GlobalVariables.ENABLE_NETWORK) {
            Runnable startRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ConnectionManager.this.startGatewayConnection();
                }
            };
            Thread startThread = new Thread(startRunnable);
            startThread.start();
        }
    }

    public static ConnectionManager getInstance() {
        if (instance == null) {
            instance = new ConnectionManager();
        }
        return instance;
    }

    public void startGatewayConnection() {
        String gwAddr = GlobalVariables.GATEWAY_ADDRESS;
        int gwPort = GlobalVariables.GATEWAY_PORT;
        try {
            this.addConnection(gwAddr, gwPort);
        }
        catch (Throwable t) {
            ConnectionManager.printDebug("ERR", t.getMessage());
            return;
        }
    }

    public void addConnection(String address, int port) {
        if (address == null || address.trim().length() < 1) {
            throw new IllegalArgumentException("No remote host specified.");
        }
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("The port given is invalid.");
        }
        final Connection connection = new Connection(address, port);
        this.connections.add(connection);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    connection.open();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    public static void printDebug(String msg) {
        ConnectionManager.printDebug(null, msg);
    }

    public static void printDebug(String prefix, String msg) {
        if (GlobalVariables.DEBUG_NETWORK) {
            String debugMessage = "<<NET";
            if (prefix != null && prefix.trim().length() > 0) {
                debugMessage = String.valueOf(debugMessage) + ":" + prefix;
            }
            debugMessage = String.valueOf(debugMessage) + ">> " + msg;
            ContextCreator.logger.debug((Object)debugMessage);
        }
    }
}

