/*
 * Decompiled with CFR 0.152.
 */
package evacSim.network;

import evacSim.ContextCreator;
import evacSim.GlobalVariables;
import evacSim.NetworkEventObject;
import evacSim.data.DataCollector;
import evacSim.data.DataConsumer;
import evacSim.data.TickSnapshot;
import evacSim.network.ConnectionManager;
import evacSim.network.MessageSocket;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;
import repast.simphony.engine.environment.RunEnvironment;
import repast.simphony.engine.schedule.ISchedule;
import repast.simphony.essentials.RepastEssentials;

public class Connection
implements DataConsumer {
    private static int COUNTER = 0;
    private int id;
    private ConnectionManager manager = ConnectionManager.getInstance();
    private DataCollector collector = DataCollector.getInstance();
    private static final String EVENT_MSG = "EVENT";
    private static final String START_MSG = "START";
    private String host;
    private int port;
    private MessageSocket socket;
    private String modelId;
    private Thread sendingThread;
    private Thread heartbeatThread;
    private Thread receivingThread;
    private boolean consuming;
    private boolean paused;
    private double currentTick;
    private Logger logger = ContextCreator.logger;

    public Connection(String host, int port) {
        if (host == null || host.trim().length() < 1) {
            throw new IllegalArgumentException("Host address not specified.");
        }
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Port number not valid.");
        }
        this.host = host;
        this.port = port;
        this.id = ++COUNTER;
        this.currentTick = -1.0;
        this.consuming = false;
        this.paused = false;
        this.heartbeatThread = null;
        this.sendingThread = null;
        this.modelId = this.loadModelId();
        ConnectionManager.printDebug(String.valueOf(this.id) + "-CTRL", "Connection object created.");
    }

    public void open() throws IOException {
        if (this.socket != null) {
            if (this.socket.isOpen()) {
                return;
            }
            this.socket = null;
        }
        try {
            this.socket = new MessageSocket(this.host, this.port);
        }
        catch (Throwable t) {
            throw new IOException("Could not open socket to remote host.", t);
        }
        this.onConnect();
    }

    public void close() throws IOException {
        if (this.socket != null) {
            this.socket.disconnect();
        }
        this.socket = null;
    }

    @Override
    public void startConsumer() throws Throwable {
        if (this.consuming) {
            if (this.paused) {
                this.paused = false;
            }
            return;
        }
        this.consuming = true;
        this.paused = false;
        this.sendingThread = new Thread(new SendingRunnable());
        this.sendingThread.start();
    }

    @Override
    public void stopConsumer() throws Throwable {
        if (!this.consuming) {
            return;
        }
        this.paused = false;
        this.consuming = false;
        this.sendingThread.interrupt();
        this.sendingThread.join();
        this.sendingThread = null;
        this.currentTick = -1.0;
    }

    @Override
    public void pauseConsumer() throws Throwable {
        if (!this.consuming) {
            return;
        }
        this.paused = true;
        this.consuming = true;
    }

    @Override
    public void resetConsumer() throws Throwable {
        this.stopConsumer();
        this.paused = false;
        this.consuming = false;
        this.currentTick = -1.0;
    }

    @Override
    public double getTick() {
        return this.currentTick;
    }

    @Override
    public void setTick(double tick) throws Throwable {
        this.currentTick = tick;
    }

    public void onClose(int statusCode, String reason) {
        ConnectionManager.printDebug(String.valueOf(this.id) + "-CTRL", String.valueOf(statusCode) + ": " + reason);
    }

    public void onError(Throwable t) {
        ConnectionManager.printDebug(String.valueOf(this.id) + "-ERR", t.getMessage());
    }

    public void onConnect() {
        if (this.socket == null) {
            return;
        }
        ConnectionManager.printDebug(String.valueOf(this.id) + "-CTRL", "Connected to " + this.host + ".");
        this.collector.registerDataConsumer(this);
        this.heartbeatThread = new Thread(new HeartbeatRunnable());
        this.heartbeatThread.start();
        this.receivingThread = new Thread(new ReceivingRunnable());
        this.receivingThread.start();
        try {
            this.sendModelId();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void onMessage(String message) {
        block12: {
            System.out.println(message);
            ConnectionManager.printDebug(String.valueOf(this.id) + "-RECV", message);
            if (message.startsWith(START_MSG)) {
                try {
                    GlobalVariables.SIMULATION_SLEEPS = 1;
                }
                catch (NumberFormatException nfe) {
                    this.logger.error((Object)"ERROR IN RECEIVED NETWORK DATA", (Throwable)nfe);
                }
                catch (Throwable t) {
                    this.logger.error((Object)"ERROR IN RECEIVED NETWORK DATA", t);
                }
            } else if (message.startsWith(EVENT_MSG)) {
                try {
                    NetworkEventObject event = this.ParseString(message);
                    if (event.eventID != 2) break block12;
                    this.insertExternalEvent(event);
                    try {
                        DataCollector.getInstance().recordEventSnapshot(event, 3);
                    }
                    catch (Throwable t) {
                        DataCollector.printDebug("ERR" + t.getMessage());
                    }
                }
                catch (NumberFormatException nfe) {
                    this.logger.error((Object)"ERROR IN PARSING EVENT NETWORK MESSAGE", (Throwable)nfe);
                }
                catch (Throwable t) {
                    this.logger.error((Object)"ERROR CREATING EVENT SNAPSHOT FOR NETWORK", t);
                }
            } else {
                this.logger.error((Object)"Unknown Information");
            }
        }
    }

    private void sendModelId() throws IOException {
        String[] msg = new String[]{"MODEL_ID", this.modelId};
        if (this.socket != null) {
            this.socket.send(msg);
        }
    }

    private void sendTickSnapshot(TickSnapshot tick) throws IOException {
        if (tick == null) {
            return;
        }
        String message = Connection.createTickMessage(tick);
        if (message.trim().length() < 1) {
            return;
        }
        if (this.socket == null || !this.socket.isOpen()) {
            throw new IOException("Socket is not open.");
        }
        this.socket.send(new String[]{message});
    }

    public static String createTickMessage(TickSnapshot tick) {
        String line;
        if (tick == null) {
            return null;
        }
        double tickNum = tick.getTickNumber();
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("TICK," + tickNum);
        ArrayList<String> tickData = tick.createCSVTickLines();
        for (String dataLine : tickData) {
            lines.add(dataLine);
        }
        for (NetworkEventObject event : tick.getEventList().get(0)) {
            if (event == null || (line = Connection.createEventMessage(event)) == null) continue;
            line = "EVENT_START," + line;
            lines.add(line);
        }
        for (NetworkEventObject event : tick.getEventList().get(1)) {
            if (event == null || (line = Connection.createEventMessage(event)) == null) continue;
            line = "EVENT_END," + line;
            lines.add(line);
        }
        for (NetworkEventObject event : tick.getEventList().get(2)) {
            if (event == null || (line = Connection.createEventMessage(event)) == null) continue;
            line = "EVENT_FROM_REMOTE_ADDED," + line;
            lines.add(line);
        }
        return String.join((CharSequence)"\n", lines);
    }

    public static String createEventMessage(NetworkEventObject event) {
        if (event == null) {
            return null;
        }
        int startTime = event.startTime;
        int endTime = event.endTime;
        int eventID = event.eventID;
        int roadID = event.roadID;
        return String.valueOf(startTime) + "," + endTime + "," + eventID + "," + roadID;
    }

    public String loadModelId() {
        String unknownId = "UNKNOWN";
        String modelIdPath = GlobalVariables.MODEL_ID_FILE;
        if (modelIdPath == null || modelIdPath.trim().length() < 1) {
            return unknownId;
        }
        File modelIdFile = new File(modelIdPath);
        if (!modelIdFile.isFile()) {
            return unknownId;
        }
        try {
            FileReader fr = new FileReader(modelIdFile);
            BufferedReader br = new BufferedReader(fr);
            String id = br.readLine();
            br.close();
            if (id == null || id.trim().length() < 1) {
                return unknownId;
            }
            return id;
        }
        catch (Throwable t) {
            return unknownId;
        }
    }

    private NetworkEventObject ParseString(String message) {
        String delims = ",";
        String[] nextLine = message.split(delims);
        int startTime = Math.round((float)Integer.parseInt(nextLine[1]) / GlobalVariables.SIMULATION_STEP_SIZE);
        int endTime = Math.round((float)Integer.parseInt(nextLine[2]) / GlobalVariables.SIMULATION_STEP_SIZE);
        startTime -= startTime % GlobalVariables.EVENT_CHECK_FREQUENCY;
        endTime -= endTime % GlobalVariables.EVENT_CHECK_FREQUENCY;
        int eventID = Integer.parseInt(nextLine[3]);
        int roadID = Integer.parseInt(nextLine[4]);
        double value1 = 2.0;
        double value2 = -999.0;
        NetworkEventObject EventObject = new NetworkEventObject(startTime, endTime, eventID, roadID, value1, value2);
        return EventObject;
    }

    public void insertExternalEvent(NetworkEventObject event) {
        int startTimeExternalEvent = event.startTime;
        if (GlobalVariables.newEventQueue.peek() == null) {
            if ((int)RepastEssentials.GetTickCount() < event.endTime) {
                GlobalVariables.newEventQueue.add(event);
            }
        } else {
            boolean flag = true;
            int queueSize = GlobalVariables.newEventQueue.size();
            int index = 0;
            while (index < queueSize) {
                if (!flag) break;
                if (startTimeExternalEvent < GlobalVariables.newEventQueue.get((int)index).startTime) {
                    GlobalVariables.newEventQueue.add(index, event);
                    flag = false;
                }
                ++index;
            }
            if (flag) {
                GlobalVariables.newEventQueue.add(event);
            }
        }
    }

    private class HeartbeatRunnable
    implements Runnable {
        public HeartbeatRunnable() {
            ConnectionManager.printDebug(String.valueOf(Connection.this.id) + "-CTRL", "Created heartbeat thread.");
        }

        @Override
        public void run() {
            boolean count = false;
            boolean hasStarted = false;
            while (Connection.this.socket == null) {
                try {
                    Thread.sleep(GlobalVariables.NETWORK_STATUS_REFRESH);
                }
                catch (InterruptedException ie) {
                    ConnectionManager.printDebug(String.valueOf(Connection.this.id) + "-CTRL", "Heartbeat stop.");
                    return;
                }
            }
            while (Connection.this.socket.isOpen()) {
                try {
                    Thread.sleep(GlobalVariables.NETWORK_STATUS_REFRESH);
                }
                catch (InterruptedException ie) {
                    ConnectionManager.printDebug(String.valueOf(Connection.this.id) + "-CTRL", "Heartbeat stop.");
                    return;
                }
                try {
                    ISchedule schedule;
                    RunEnvironment runEnv = RunEnvironment.getInstance();
                    String state = "Not running";
                    if (runEnv != null && (schedule = runEnv.getCurrentSchedule()) != null) {
                        double tick = schedule.getTickCount();
                        hasStarted = true;
                        state = tick < 0.0 ? "Loading simulation" : "Running @ tick #" + tick;
                    }
                    String message = "STATUS," + new Date().toString() + "\n" + state;
                    Connection.this.socket.send(new String[]{message});
                }
                catch (IOException ioe) {
                    ConnectionManager.printDebug(String.valueOf(Connection.this.id) + "-ERR", ioe.getMessage());
                }
                catch (Throwable t) {
                    ConnectionManager.printDebug(String.valueOf(Connection.this.id) + "-ERR", t.getMessage());
                }
            }
            ConnectionManager.printDebug(String.valueOf(Connection.this.id) + "-SEND", "HEARTBEAT THREAD EXITING");
        }
    }

    public class ReceivingRunnable
    implements Runnable {
        public ReceivingRunnable() {
            ConnectionManager.printDebug(String.valueOf(Connection.this.id) + "-CTRL", "Created receiving thread.");
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block6: {
                delay = 500;
                while (Connection.access$1(Connection.this) == null) {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException ie) {
                        return;
                    }
                }
                {
                    break block6;
                    while ((message = Connection.access$1(Connection.this).nextMessage()) != null) {
                        Connection.this.onMessage(String.join((CharSequence)"\n", message));
lbl11:
                        // 2 sources

                        ** while (!Connection.access$1((Connection)Connection.this).hasNext())
lbl12:
                        // 1 sources

                    }
lbl13:
                    // 2 sources

                    Thread.sleep(delay);
                }
            }
            if (!Connection.access$1(Connection.this).isDone()) ** GOTO lbl11
        }
    }

    private class SendingRunnable
    implements Runnable {
        public SendingRunnable() {
            ConnectionManager.printDebug(String.valueOf(Connection.this.id) + "-SEND", "Created stream thread.");
        }

        @Override
        public void run() {
            while (Connection.this.socket == null) {
                try {
                    Thread.sleep(GlobalVariables.NETWORK_BUFFER_RERESH);
                }
                catch (InterruptedException ie) {
                    ConnectionManager.printDebug(String.valueOf(Connection.this.id) + "-SEND", "Send thread stop.");
                    return;
                }
            }
            int totalCount = 0;
            int sendCount = 0;
            boolean running = true;
            while (running) {
                if (!Connection.this.consuming) {
                    ConnectionManager.printDebug(String.valueOf(Connection.this.id) + "-SEND", "Not consuming.");
                    break;
                }
                if (Connection.this.paused) {
                    ConnectionManager.printDebug(String.valueOf(Connection.this.id) + "-SEND", "Paused.");
                    try {
                        Thread.sleep(GlobalVariables.NETWORK_BUFFER_RERESH);
                    }
                    catch (InterruptedException ie) {
                        break;
                    }
                }
                double nextTick = Connection.this.currentTick + (double)GlobalVariables.FREQ_RECORD_VEH_SNAPSHOT_FORVIZ;
                TickSnapshot snapshot = Connection.this.collector.getNextTick(nextTick);
                if (snapshot == null) {
                    if (sendCount > 0) {
                        String report = "Sent " + sendCount + " ticks to remote host (" + totalCount + " total)";
                        ConnectionManager.printDebug(String.valueOf(Connection.this.id) + "-SEND", report);
                        sendCount = 0;
                    }
                    if (!Connection.this.collector.isCollecting() && !Connection.this.collector.isPaused()) break;
                    try {
                        Thread.sleep(GlobalVariables.NETWORK_BUFFER_RERESH);
                        continue;
                    }
                    catch (InterruptedException ie) {
                        ConnectionManager.printDebug(String.valueOf(Connection.this.id) + "-SEND", "Stopped.");
                        break;
                    }
                }
                Connection.this.currentTick = snapshot.getTickNumber();
                try {
                    Connection.this.sendTickSnapshot(snapshot);
                    ++totalCount;
                    ++sendCount;
                }
                catch (Throwable t) {
                    ConnectionManager.printDebug(String.valueOf(Connection.this.id) + "-SEND", t.getMessage());
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException ie) {
                    ConnectionManager.printDebug(String.valueOf(Connection.this.id) + "-SEND", "Stopping.");
                    break;
                }
            }
            ConnectionManager.printDebug(String.valueOf(Connection.this.id) + "-SEND", "SEND THREAD EXITING");
            Connection.this.paused = false;
            Connection.this.consuming = false;
            Thread heartbeatThread = Connection.this.heartbeatThread;
            Thread receivingThread = Connection.this.receivingThread;
            try {
                if (heartbeatThread != null && heartbeatThread.isAlive()) {
                    heartbeatThread.interrupt();
                }
                if (receivingThread != null && receivingThread.isAlive()) {
                    receivingThread.interrupt();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Thread.sleep(5000L);
                Connection.this.socket.disconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

