/*
 * Decompiled with CFR 0.152.
 */
package evacSim.data;

import evacSim.ContextCreator;
import evacSim.GlobalVariables;
import evacSim.data.DataCollector;
import evacSim.data.DataConsumer;
import evacSim.data.TickSnapshot;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.simple.JSONObject;
import repast.simphony.essentials.RepastEssentials;

public class JsonOutputWriter
implements DataConsumer {
    private Logger logger = ContextCreator.logger;
    private boolean append;
    private boolean defaultFilenames;
    private File file;
    private int previousFileName = 1;
    private BufferedWriter writer;
    private int ticksWritten;
    private int fileSeriesNumber;
    private Thread writingThread;
    protected double currentTick;
    private boolean consuming;
    private boolean paused;
    private Map<String, Object> storeJsonObjects;

    public JsonOutputWriter() {
        this(new File(JsonOutputWriter.createDefaultFilePath()), false);
        this.logger.info((Object)("Creating JSON file " + JsonOutputWriter.createDefaultFilePath()));
    }

    public JsonOutputWriter(File file, boolean append) {
        this.append = append;
        this.file = file;
        this.defaultFilenames = file == null;
        this.consuming = false;
        this.paused = false;
        this.currentTick = 0.0;
        this.writer = null;
        this.writingThread = null;
        this.fileSeriesNumber = 1;
        this.ticksWritten = 0;
        this.storeJsonObjects = new HashMap<String, Object>();
        DataCollector.printDebug("JSON", "FILE: " + this.file.getAbsolutePath());
    }

    public boolean isAppending() {
        return this.append;
    }

    public void setAppending(boolean append) {
        this.append = append;
    }

    public File getOutputFile() {
        return this.file;
    }

    public void setOutputfile(File file) throws IOException {
        if (this.consuming || this.paused) {
            throw new IOException("Cannot change file while running.");
        }
        this.file = file;
        this.fileSeriesNumber = 1;
        this.defaultFilenames = this.file == null;
    }

    @Override
    public void startConsumer() throws Throwable {
        if (this.consuming) {
            if (this.paused) {
                this.paused = false;
            }
            return;
        }
        this.consuming = true;
        this.paused = false;
        if (this.defaultFilenames || this.file == null) {
            this.file = new File(JsonOutputWriter.createDefaultFilePath());
            this.previousFileName = 1;
        }
        this.openOutputFileWriter();
        Runnable writingRunnable = new Runnable(){

            @Override
            public void run() {
                DataCollector collector = DataCollector.getInstance();
                int totalCount = 0;
                int writeCount = 0;
                boolean running = true;
                while (running) {
                    if (!JsonOutputWriter.this.consuming) {
                        DataCollector.printDebug("JSON", "NOT CONSUMING");
                        break;
                    }
                    if (JsonOutputWriter.this.paused) {
                        DataCollector.printDebug("JSON", "PAUSED");
                        try {
                            JsonOutputWriter.this.logger.info((Object)("Sleeping JSON consumer at t=" + RepastEssentials.GetTickCount()));
                            Thread.sleep(GlobalVariables.JSON_BUFFER_REFRESH);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            break;
                        }
                    }
                    double nextTick = JsonOutputWriter.this.currentTick + (double)GlobalVariables.FREQ_RECORD_VEH_SNAPSHOT_FORVIZ;
                    TickSnapshot snapshot = collector.getNextTick(nextTick);
                    if (snapshot == null) {
                        if (writeCount > 0) {
                            String report = "Wrote " + writeCount + " ticks to disk (" + totalCount + " total)";
                            DataCollector.printDebug("JSON", report);
                            writeCount = 0;
                        }
                        if (!collector.isCollecting() && !collector.isPaused()) break;
                        try {
                            Thread.sleep(GlobalVariables.JSON_BUFFER_REFRESH);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            break;
                        }
                    }
                    JsonOutputWriter.this.currentTick = snapshot.getTickNumber();
                    try {
                        JsonOutputWriter.this.writeTickSnapshot(snapshot);
                        ++totalCount;
                        ++writeCount;
                    }
                    catch (IOException ioe) {
                        String errMsg = "WRITE ERROR: " + ioe.getMessage();
                        DataCollector.printDebug("JSON" + errMsg);
                    }
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException ie) {
                        break;
                    }
                }
                try {
                    JsonOutputWriter.this.closeOutputFileWriter();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                JsonOutputWriter.this.paused = false;
                JsonOutputWriter.this.consuming = false;
            }
        };
        this.writingThread = new Thread(writingRunnable);
        this.writingThread.start();
    }

    @Override
    public void stopConsumer() throws Throwable {
        if (!this.consuming) {
            return;
        }
        this.paused = false;
        this.consuming = false;
        this.writingThread.interrupt();
        this.writingThread.join();
        this.writingThread = null;
        this.currentTick = -1.0;
        this.closeOutputFileWriter();
        this.writer = null;
    }

    @Override
    public void pauseConsumer() throws Throwable {
        if (!this.consuming) {
            return;
        }
        this.paused = true;
        this.consuming = true;
    }

    @Override
    public void resetConsumer() throws Throwable {
        this.stopConsumer();
        this.paused = false;
        this.consuming = false;
        this.currentTick = -1.0;
    }

    @Override
    public double getTick() {
        return this.currentTick;
    }

    @Override
    public void setTick(double tick) throws Throwable {
        this.currentTick = tick;
    }

    private void openOutputFileWriter() throws IOException {
        if (this.writer != null) {
            try {
                this.writer.flush();
                throw new Exception();
            }
            catch (IOException iOException) {
            }
            catch (Exception e) {
                throw new IOException("JSON writer already has a file open.");
            }
        }
        if (this.file == null) {
            throw new IOException("No output file has been specified.");
        }
        FileWriter fw = new FileWriter(this.file);
        this.writer = new BufferedWriter(fw);
    }

    private void closeOutputFileWriter() throws IOException {
        if (this.writer == null) {
            return;
        }
        this.writer.close();
        this.writer = null;
        if (this.defaultFilenames) {
            this.file = null;
        }
    }

    private void startNextOutputFile(int current_time) throws IOException {
        if (this.file == null) {
            return;
        }
        String filename = this.file.getName();
        if (filename == null || filename.trim().length() < 1) {
            return;
        }
        String currentEnd = "." + this.previousFileName + ".json";
        String nextEnd = "." + (current_time / GlobalVariables.FREQ_RECORD_VEH_SNAPSHOT_FORVIZ / 2 + 1) + ".json";
        String newFilename = filename;
        newFilename = newFilename.replaceAll(String.valueOf(currentEnd) + "$", nextEnd);
        File nextFile = new File(this.file.getParent(), newFilename);
        this.closeOutputFileWriter();
        this.file = nextFile;
        FileWriter fw = new FileWriter(this.file);
        this.writer = new BufferedWriter(fw);
        ++this.fileSeriesNumber;
        this.previousFileName = current_time / GlobalVariables.FREQ_RECORD_VEH_SNAPSHOT_FORVIZ / 2 + 1;
    }

    private void writeTickSnapshot(TickSnapshot tick) throws IOException {
        if (tick == null) {
            return;
        }
        if (this.writer == null) {
            throw new IOException("The JSON file is not open for writing.");
        }
        if (this.ticksWritten >= GlobalVariables.JSON_TICK_LIMIT_PER_FILE) {
            this.startNextOutputFile(tick.getTickNumber());
            this.ticksWritten = 0;
            this.storeJsonObjects = new HashMap<String, Object>();
        }
        String tickString = String.valueOf(tick.getTickNumber());
        HashMap<String, ArrayList<String>> tickData = new HashMap<String, ArrayList<String>>();
        ArrayList<String> vehTickArray = tick.createJSONTickLines("vehicle");
        ArrayList<String> roadTickArray = tick.createJSONTickLines("road");
        ArrayList<String> sheltTickArray = tick.createJSONTickLines("shelter");
        ArrayList<String> newVehTickArray = tick.createJSONTickLines("newVeh");
        ArrayList<String> arrVehTickArray = tick.createJSONTickLines("arrVeh");
        tickData.put("vehicles", vehTickArray);
        tickData.put("shelters", sheltTickArray);
        tickData.put("roads", roadTickArray);
        tickData.put("newVehs", newVehTickArray);
        tickData.put("arrVehs", arrVehTickArray);
        this.storeJsonObjects.put(tickString, tickData);
        if (this.ticksWritten == GlobalVariables.JSON_TICK_LIMIT_PER_FILE - 1) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.putAll(this.storeJsonObjects);
            this.writer.write(JSONObject.toJSONString((Map)jsonObject));
        }
        ++this.ticksWritten;
        this.writer.flush();
    }

    public static String createDefaultFilePath() {
        String defaultFilename = GlobalVariables.DEFAULT_SNAPSHOT_FILENAME;
        SimpleDateFormat formatter = new SimpleDateFormat("YYYY-MM-dd-hh-mm-ss");
        String timestamp = formatter.format(new Date());
        String filename = String.valueOf(defaultFilename) + "-" + GlobalVariables.SCENARIO_NAME + "-" + timestamp + ".1.json";
        String outDir = GlobalVariables.OUTPUT_DIR;
        String outpath = String.valueOf(outDir) + File.separatorChar + filename;
        File outfile = new File(outpath);
        if (outfile.exists()) {
            int hashCode = System.identityHashCode(filename);
            filename = String.valueOf(defaultFilename) + "_" + timestamp + "_" + hashCode + ".1.json";
            outpath = String.valueOf(outDir) + File.pathSeparator + filename;
            outfile = new File(outpath);
        }
        try {
            outfile.createNewFile();
            if (!outfile.canWrite()) {
                throw new IOException("Can't write to file.");
            }
            outfile.delete();
        }
        catch (IOException ioe) {
            try {
                outfile = File.createTempFile(filename, "json");
            }
            catch (IOException ioe2) {
                return null;
            }
        }
        return outfile.getAbsolutePath();
    }
}

