/*
 * Decompiled with CFR 0.152.
 */
package evacSim.data;

import evacSim.ContextCreator;
import evacSim.GlobalVariables;
import evacSim.data.CsvOutputWriter;
import evacSim.data.DataCollector;
import evacSim.data.JsonOutputWriter;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import repast.simphony.context.DefaultContext;
import repast.simphony.engine.environment.RunEnvironment;

public class DataCollectionContext
extends DefaultContext<Object> {
    private Logger logger = ContextCreator.logger;
    private DataCollector collector = DataCollector.getInstance();
    private CsvOutputWriter csvOutputWriter;
    private JsonOutputWriter jsonOutputWriter;

    public DataCollectionContext() {
        super((Object)"DataCollectionContext");
        if (GlobalVariables.ENABLE_CSV_WRITE) {
            this.csvOutputWriter = new CsvOutputWriter();
            this.collector.registerDataConsumer(this.csvOutputWriter);
        }
        if (GlobalVariables.ENABLE_JSON_WRITE) {
            this.jsonOutputWriter = new JsonOutputWriter();
            this.collector.registerDataConsumer(this.jsonOutputWriter);
        }
        if (GlobalVariables.ENABLE_RUNTIME_RECORD) {
            GlobalVariables.RUNTIME_RECORD_LIST.add(Double.valueOf(System.currentTimeMillis()));
        }
    }

    public void startCollecting() {
        this.collector.startDataCollection();
    }

    public void stopCollecting() {
        this.collector.stopDataCollection();
    }

    public void startTick() {
        double tickNumber = RunEnvironment.getInstance().getCurrentSchedule().getTickCount();
        this.collector.startTickCollection(tickNumber);
    }

    public void stopTick() {
        this.collector.stopTickCollection();
    }

    public void recordRuntime() {
        if (GlobalVariables.ENABLE_RUNTIME_RECORD) {
            ArrayList<Double> runtimeRecorder = GlobalVariables.RUNTIME_RECORD_LIST;
            runtimeRecorder.add(((double)System.currentTimeMillis() - runtimeRecorder.get(0)) / 1000.0);
            this.logger.info((Object)("nVehGenerated=" + GlobalVariables.NUM_GENERATED_VEHICLES + ", nVehEnteredNetwork=" + GlobalVariables.NUM_VEHICLES_ENTERED_ROAD_NETWORK + ", nVehKilled=" + GlobalVariables.NUM_KILLED_VEHICLES + ", nVehFailed=" + GlobalVariables.NUM_FAILED_VEHICLES + ", tick=" + RunEnvironment.getInstance().getCurrentSchedule().getTickCount() + ", cumRuntime=" + runtimeRecorder.get(runtimeRecorder.size() - 1)));
        } else {
            this.logger.info((Object)("nVehGenerated=" + GlobalVariables.NUM_GENERATED_VEHICLES + ", nVehEnteredNetwork=" + GlobalVariables.NUM_VEHICLES_ENTERED_ROAD_NETWORK + ", nVehKilled=" + GlobalVariables.NUM_KILLED_VEHICLES + ", nVehFailed=" + GlobalVariables.NUM_FAILED_VEHICLES + ", tick=" + RunEnvironment.getInstance().getCurrentSchedule().getTickCount()));
        }
    }
}

