/*
 * Decompiled with CFR 0.152.
 */
package evacSim.citycontext;

import evacSim.ContextCreator;
import evacSim.GlobalVariables;
import evacSim.citycontext.House;
import evacSim.citycontext.Zone;
import evacSim.data.DataCollector;
import evacSim.demand.DatasetOfHouseholdsPerZones;
import evacSim.routing.SOShelterRouting;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import repast.simphony.context.Context;
import repast.simphony.context.DefaultContext;
import repast.simphony.context.space.gis.GeographyFactoryFinder;
import repast.simphony.engine.environment.RunEnvironment;
import repast.simphony.parameter.Parameters;
import repast.simphony.space.gis.Geography;
import repast.simphony.space.gis.GeographyParameters;
import repast.simphony.space.gis.ShapefileLoader;

public class ZoneContext
extends DefaultContext<Zone> {
    Logger logger = ContextCreator.logger;
    public DatasetOfHouseholdsPerZones dataset;
    public SOShelterRouting soShelterMatcher;
    public ArrayList<Zone> shelters;

    public ZoneContext() {
        super((Object)"ZoneContext");
        this.logger.info((Object)"ZoneContext creation");
        GeographyParameters geoParams = new GeographyParameters();
        Geography zoneGeography = GeographyFactoryFinder.createGeographyFactory(null).createGeography("ZoneGeography", (Context)this, geoParams);
        try {
            this.logger.info((Object)"Initializing demand zones only");
            File zoneFile = null;
            ShapefileLoader zoneLoader = null;
            zoneFile = new File(GlobalVariables.ZONES_SHAPEFILE);
            URI uri = zoneFile.toURI();
            zoneLoader = new ShapefileLoader(Zone.class, uri.toURL(), zoneGeography, (Context)this);
            int int_id = 1;
            while (zoneLoader.hasNext()) {
                Zone zone = (Zone)zoneLoader.nextWithArgs(new Object[]{int_id});
                zone.setGeometry((Geography<Zone>)zoneGeography);
                ++int_id;
            }
            File shelterFile = null;
            String shelterCsvName = null;
            ShapefileLoader shelterLoader = null;
            ArrayList<Zone> shelters = new ArrayList<Zone>();
            this.logger.info((Object)"Initializing shelters");
            shelterFile = new File(GlobalVariables.SHELTERS_SHAPEFILE);
            uri = shelterFile.toURI();
            shelterLoader = new ShapefileLoader(Zone.class, uri.toURL(), zoneGeography, (Context)this);
            shelterCsvName = GlobalVariables.SHELTERS_CSV;
            BufferedReader br = new BufferedReader(new FileReader(shelterCsvName));
            int lineNum = 0;
            while (shelterLoader.hasNext()) {
                String line = br.readLine();
                if (++lineNum == 1) continue;
                String[] result = line.split(",");
                Zone shelter = (Zone)shelterLoader.nextWithArgs(new Object[]{-Integer.parseInt(result[0])});
                shelter.setName(result[2]);
                shelter.setType(1);
                shelter.setCapacity(Integer.parseInt(result[7]));
                shelter.setOccupancy(0);
                shelter.setGeometry((Geography<Zone>)zoneGeography);
                shelters.add(shelter);
            }
            br.close();
            this.soShelterMatcher = new SOShelterRouting(shelters);
            this.logger.info((Object)("Created SO shelter matcher: " + this.soShelterMatcher.toString()));
            this.shelters = shelters;
        }
        catch (MalformedURLException e) {
            System.err.println("Malformed URL exception when reading housesshapefile.");
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            System.out.println("ContextCreator: No road csv file found");
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (GlobalVariables.DYNAMIC_DEST_STRATEGY == 3) {
            this.logger.info((Object)"Trying shelter matching!");
        }
        if (GlobalVariables.SET_DEMAND_FROM_ACTIVITY_MODELS) {
            if (GlobalVariables.SIMULATION_MULTIPLE_DEMAND_INPUTS) {
                Parameters params = RunEnvironment.getInstance().getParameters();
                int demandNumber = params.getInteger("demandFiles");
                String a_filepath = "data/multiple_instances_of_demand/" + demandNumber + ".csv";
                this.logger.info((Object)("data file: " + a_filepath));
                this.dataset = new DatasetOfHouseholdsPerZones(a_filepath);
            } else {
                String a_filepath = GlobalVariables.ACTIVITY_CSV;
                this.logger.info((Object)("data file: " + a_filepath));
                this.dataset = new DatasetOfHouseholdsPerZones(a_filepath);
            }
            HashMap<Integer, ArrayList<House>> housesbyzone = this.dataset.getHousesByHour().pollFirstEntry().getValue();
            for (Zone z : zoneGeography.getAllObjects()) {
                int keyzone = z.getIntegerId();
                if (!housesbyzone.containsKey(keyzone)) continue;
                ArrayList<House> temparraylist = housesbyzone.get(keyzone);
                z.setHouses(temparraylist);
                for (House hh : z.getHouses()) {
                    hh.setZone(z);
                }
            }
        }
    }

    public void loadDemandofNextHour() {
        HashMap<Integer, ArrayList<House>> housesbyzone = this.dataset.getHousesByHour().pollFirstEntry().getValue();
        for (Zone z : ContextCreator.getZoneGeography().getAllObjects()) {
            ArrayList<House> temparraylist;
            int keyzone = z.getIntegerId();
            if (housesbyzone.containsKey(keyzone)) {
                temparraylist = housesbyzone.get(keyzone);
                z.setHouses(temparraylist);
                for (House hh : z.getHouses()) {
                    hh.setZone(z);
                }
                continue;
            }
            temparraylist = new ArrayList();
            z.setHouses(temparraylist);
        }
    }

    public void recordShelterStatus() {
        for (Zone shelter : this.shelters) {
            if (shelter.getOccupancy() == shelter.getLastRecordedOccupancy()) continue;
            try {
                DataCollector.getInstance().recordShelterTickSnapshot(shelter);
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
        }
    }
}

