/*
 * Decompiled with CFR 0.152.
 */
package evacSim.citycontext;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import evacSim.BackgroundTraffic;
import evacSim.ContextCreator;
import evacSim.GlobalVariables;
import evacSim.citycontext.Junction;
import evacSim.citycontext.Lane;
import evacSim.citycontext.LaneComparator;
import evacSim.data.DataCollector;
import evacSim.vehiclecontext.Vehicle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import repast.simphony.engine.environment.RunEnvironment;
import repast.simphony.essentials.RepastEssentials;
import repast.simphony.space.gis.Geography;

public class Road {
    private Logger logger = ContextCreator.logger;
    private int id = ContextCreator.generateAgentID();
    private int linkid;
    private int left;
    private int right;
    private int through;
    private int tlinkid;
    private int nLanes;
    private int fromNode;
    private int toNode;
    private int curhour = -1;
    private String identifier = " ";
    private int nVehicles_ = 0;
    private double length;
    private float speed_;
    private double travelTime;
    private float freeSpeed_;
    private Road oppositeRoad = null;
    private ArrayList<Road> downStreamMovements;
    private ArrayList<Lane> lanes;
    private ArrayList<Junction> junctions = new ArrayList();
    private int nShadowVehicles = 0;
    private int nFutureRoutingVehicles = 0;
    private int lastRecordedNumVehicles = 0;
    private float lastRecordedSpeed = 0.0f;
    private ArrayList<Double> dynamicTravelTime;
    private TreeMap<Double, Queue<Vehicle>> newqueue;
    private Vehicle lastVehicle_ = null;
    private Vehicle firstVehicle_ = null;
    private boolean eventFlag = false;
    private double defaultFreeSpeed_;
    private ArrayList<Vehicle> newVehs;
    private ArrayList<Vehicle> arrVehs;

    public Road() {
        this.lanes = new ArrayList();
        this.defaultFreeSpeed_ = this.freeSpeed_;
        this.downStreamMovements = new ArrayList();
        this.newqueue = new TreeMap();
        this.travelTime = (float)this.length / this.freeSpeed_;
        this.newVehs = new ArrayList();
        this.arrVehs = new ArrayList();
    }

    public String toString() {
        return "<Road" + this.linkid + ">";
    }

    public void setDefaultFreeSpeed() {
        this.defaultFreeSpeed_ = this.freeSpeed_;
    }

    public double getDefaultFreeSpeed() {
        return this.defaultFreeSpeed_;
    }

    public boolean checkEventFlag() {
        return this.eventFlag;
    }

    public void setEventFlag() {
        this.eventFlag = true;
    }

    public void restoreEventFlag() {
        this.eventFlag = false;
    }

    public void step() {
        int tickcount = (int)RepastEssentials.GetTickCount();
        try {
            Vehicle pv;
            while (this.newqueue.size() > 0) {
                Vehicle v = this.newqueueHead();
                if (v.closeToRoad(this) == 1 && tickcount >= v.getDepTime()) {
                    if (v.enterNetwork(this) != 1) break;
                    this.newVehs.add(v);
                    v.advanceInMacroList();
                    continue;
                }
                Set<Double> keys = this.newqueue.keySet();
                block9: for (Double key : keys) {
                    Queue<Vehicle> temList = this.newqueue.get(key);
                    for (Vehicle pv2 : temList) {
                        if (tickcount < pv2.getDepTime()) continue block9;
                        pv2.primitiveMove();
                    }
                }
            }
            if ((pv = this.firstVehicle()) != null && pv.leading() != null) {
                pv.leading(null);
            }
            while (pv != null) {
                if (tickcount <= pv.getLastMoveTick()) {
                    pv = pv.macroTrailing();
                    break;
                }
                pv.updateLastMoveTick(tickcount);
                if (!pv.calcState()) {
                    this.logger.info((Object)("Link " + this.linkid + " vehicle list is corrupted"));
                    break;
                }
                if (tickcount % GlobalVariables.FREQ_RECORD_VEH_SNAPSHOT_FORVIZ == 0 && pv.getMovingFlag()) {
                    pv.recVehSnaphotForVisInterp();
                }
                pv.travel();
                if (pv.atDestination()) {
                    this.arrVehs.add(pv);
                }
                pv = pv.macroTrailing();
            }
            if (tickcount % GlobalVariables.FREQ_RECORD_VEH_SNAPSHOT_FORVIZ == 0) {
                for (Vehicle veh : this.newVehs) {
                    try {
                        DataCollector.getInstance().recordNewVehicleTickSnapshot(veh);
                    }
                    catch (Throwable t) {
                        this.logger.error((Object)("Cannot store the new vehicles " + veh.getVehicleID() + "," + veh.getOriginalCoord() + "," + veh.getDestCoord()));
                        DataCollector.printDebug("ERR" + t.getMessage());
                    }
                }
                for (Vehicle veh : this.arrVehs) {
                    try {
                        DataCollector.getInstance().recordArrVehicleTickSnapshot(veh);
                    }
                    catch (Throwable t) {
                        System.out.println("Cannot store the arrived vehicles" + t.getMessage());
                        DataCollector.printDebug("ERR" + t.getMessage());
                    }
                }
                this.newVehs = new ArrayList();
                this.arrVehs = new ArrayList();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Road " + this.linkid + " had an error while moving vehicles"));
            e.printStackTrace();
            RunEnvironment.getInstance().pauseRun();
        }
        if (tickcount % GlobalVariables.FREQ_RECORD_ROAD_SNAPSHOT_FORVIZ == 0 && (this.speed_ != this.lastRecordedSpeed || this.getVehicleNum() != this.lastRecordedNumVehicles)) {
            this.lastRecordedNumVehicles = this.getVehicleNum();
            this.lastRecordedSpeed = this.speed_;
            try {
                DataCollector.getInstance().recordRoadTickSnapshot(this);
            }
            catch (Throwable t) {
                DataCollector.printDebug("ERR" + t.getMessage());
            }
        }
    }

    public void setLinkid(int linkid) {
        this.linkid = linkid;
    }

    public int getLinkid() {
        return this.linkid;
    }

    public void setTlinkid(int tlinkid) {
        this.tlinkid = tlinkid;
    }

    public int getTlinkid() {
        return this.tlinkid;
    }

    public int getID() {
        return this.id;
    }

    public void setOppositeRoad(Road r) {
        this.oppositeRoad = r;
    }

    public Road getOppositeRoad() {
        return this.oppositeRoad;
    }

    public void sortLanes() {
        Collections.sort(this.lanes, new LaneComparator());
    }

    public String getIdentifier() {
        if (this.identifier == "" || this.identifier == null) {
            System.err.println("Road: error, the identifier field for this road has not been initialised.\n\tIf reading in a shapefile please make sure there is a string column called 'identifier' which is unique to each feature");
        }
        return this.identifier;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public int getLeft() {
        return this.left;
    }

    public void setThrough(int through) {
        this.through = through;
    }

    public int getThrough() {
        return this.through;
    }

    public void setRight(int right) {
        this.right = right;
    }

    public int getRight() {
        return this.right;
    }

    public void setFn(int node) {
        this.fromNode = node;
    }

    public int getFn() {
        return this.fromNode;
    }

    public void setTn(int node) {
        this.toNode = node;
    }

    public int getTn() {
        return this.toNode;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public double getLength() {
        return this.length;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void addJunction(Junction j) {
        if (this.junctions.size() == 2) {
            System.err.println("Road: Error: this Road object already has two Junctions.");
        }
        this.junctions.add(j);
    }

    public ArrayList<Junction> getJunctions() {
        if (this.junctions.size() != 2) {
            System.err.println("Road: Error: This Road does not have two Junctions");
        }
        return this.junctions;
    }

    public void roadMovement() {
        ArrayList<Road> allRoads_ = new ArrayList<Road>();
        ArrayList<Road> allMovements_ = new ArrayList<Road>();
        if (this.getJunctions() != null) {
            for (Road r : this.getJunctions().get(1).getRoads()) {
                if (r.getID() == this.getID() || r.getJunctions().get(1).getID() == this.getJunctions().get(0).getID()) continue;
                allRoads_.add(r);
            }
            if (allRoads_.size() != 0) {
                for (Road r : allRoads_) {
                    if (this.getJunctions().get(1).getID() != r.getJunctions().get(0).getID()) continue;
                    allMovements_.add(r);
                }
            }
            double[] angles_ = new double[allMovements_.size()];
            if (allMovements_.size() != 0) {
                double x1 = this.getJunctions().get((int)0).getCoordinate().x;
                double y1 = this.getJunctions().get((int)0).getCoordinate().y;
                double x0 = this.getJunctions().get((int)1).getCoordinate().x;
                double y0 = this.getJunctions().get((int)1).getCoordinate().y;
                double angle1 = this.atan3(x1, y1, x0, y0);
                int i = 0;
                for (Road r : allMovements_) {
                    double x2 = r.getJunctions().get((int)1).getCoordinate().x;
                    double y2 = r.getJunctions().get((int)1).getCoordinate().y;
                    double angle2 = this.atan3(x2, y2, x0, y0);
                    double angle = angle2 - angle1;
                    angles_[i] = angle > 0.0 ? angle : angle + Math.PI * 2;
                    ++i;
                }
            }
            if (angles_.length != 0) {
                double[] listAngles = new double[allMovements_.size()];
                double maxAngle = 0.0;
                double currentAngle = 0.0;
                int j = 0;
                while (j < angles_.length) {
                    int i;
                    maxAngle = 0.0;
                    if (j == 0) {
                        i = 0;
                        while (i < angles_.length) {
                            currentAngle = angles_[i];
                            if (maxAngle < currentAngle) {
                                maxAngle = currentAngle;
                            }
                            ++i;
                        }
                        listAngles[j] = maxAngle;
                    } else {
                        i = 0;
                        while (i < angles_.length) {
                            currentAngle = angles_[i];
                            double check = listAngles[j - 1];
                            if (maxAngle < currentAngle && currentAngle < check) {
                                maxAngle = currentAngle;
                            }
                            ++i;
                        }
                        listAngles[j] = maxAngle;
                    }
                    ++j;
                }
                j = 0;
                while (j < listAngles.length) {
                    int i = 0;
                    while (i < angles_.length) {
                        if (listAngles[j] == angles_[i]) {
                            Road pr = (Road)allMovements_.get(i);
                            this.downStreamMovements.add(pr);
                        }
                        ++i;
                    }
                    ++j;
                }
            }
        }
    }

    public void addDownStreamMovement(Road dsRoad) {
        this.downStreamMovements.add(dsRoad);
    }

    public ArrayList<Road> getConnectedRoads() {
        return this.downStreamMovements;
    }

    public void setNumberOfVehicles(int nVeh) {
        this.nVehicles_ = nVeh;
        if (this.nVehicles_ < 0) {
            this.nVehicles_ = 0;
        }
    }

    public void changeNumberOfVehicles(int nVeh) {
        this.nVehicles_ += nVeh;
        if (this.nVehicles_ < 0) {
            this.nVehicles_ = 0;
        }
    }

    public void firstVehicle(Vehicle v) {
        this.firstVehicle_ = v != null ? v : null;
    }

    public void lastVehicle(Vehicle v) {
        this.lastVehicle_ = v != null ? v : null;
    }

    public Vehicle firstVehicle() {
        return this.firstVehicle_;
    }

    public Vehicle lastVehicle() {
        return this.lastVehicle_;
    }

    public int getVehicleNum() {
        return this.nVehicles_;
    }

    public boolean hasUpdatableVehicle() {
        return this.nVehicles_ > 0 && this.newqueue.size() > 0;
    }

    public int getShadowVehicleNum() {
        return this.nShadowVehicles;
    }

    public void incrementShadowVehicleNum() {
        ++this.nShadowVehicles;
    }

    public void resetShadowVehicleNum() {
        this.nShadowVehicles = 0;
    }

    public void decreaseShadowVehicleNum() {
        --this.nShadowVehicles;
        if (this.nShadowVehicles < 0) {
            this.nShadowVehicles = 0;
        }
    }

    public int getFutureRoutingVehNum() {
        return this.nFutureRoutingVehicles;
    }

    public void incrementFutureRoutingVehNum() {
        ++this.nFutureRoutingVehicles;
    }

    public void resetFutureRountingVehNum() {
        this.nFutureRoutingVehicles = 0;
    }

    public void decreaseFutureRoutingVehNum() {
        --this.nFutureRoutingVehicles;
        if (this.nFutureRoutingVehicles < 0) {
            this.nFutureRoutingVehicles = 0;
        }
    }

    public void addVehicleToNewQueue(Vehicle v) {
        double departuretime_ = 0.0;
        departuretime_ = v.getDepTime();
        if (!this.newqueue.containsKey(departuretime_)) {
            LinkedList<Vehicle> temporalList = new LinkedList<Vehicle>();
            temporalList.add(v);
            this.newqueue.put(departuretime_, temporalList);
        } else {
            this.newqueue.get(departuretime_).add(v);
        }
        v.setRoad(this);
    }

    public void removeVehicleFromNewQueue(Vehicle v) {
        double departuretime_ = v.getDepTime();
        Queue<Vehicle> temporalList = this.newqueue.get(departuretime_);
        if (temporalList.size() > 1) {
            this.newqueue.get(departuretime_).poll();
        } else {
            this.newqueue.remove(departuretime_);
        }
    }

    public Vehicle newqueueHead() {
        if (this.newqueue.size() > 0) {
            double firstDeparture_ = this.newqueue.firstKey();
            return this.newqueue.get(firstDeparture_).peek();
        }
        return null;
    }

    public double length() {
        return this.length;
    }

    public float getFreeSpeed() {
        return this.freeSpeed_;
    }

    public float calcSpeed() {
        if (this.nVehicles_ < 1) {
            this.speed_ = this.freeSpeed_;
            return this.speed_;
        }
        int nVehicles = 0;
        float sum = 0.0f;
        Vehicle pv = this.firstVehicle();
        while (pv != null && pv.isOnLane()) {
            sum += pv.currentSpeed();
            ++nVehicles;
            pv = pv.macroTrailing();
        }
        if (nVehicles < 1) {
            this.speed_ = this.freeSpeed_;
            return this.speed_;
        }
        this.speed_ = sum / (float)nVehicles;
        return this.speed_;
    }

    public void calcLength() {
        Geography<Road> roadGeography = ContextCreator.getRoadGeography();
        Geometry roadGeom = roadGeography.getGeometry((Object)this);
        this.length = (float)ContextCreator.convertToMeters(roadGeom.getLength());
        this.initDynamicTravelTime();
    }

    public void setTravelTime() {
        float averageSpeed = 0.0f;
        if (this.nVehicles_ == 0) {
            averageSpeed = this.freeSpeed_;
        } else {
            Vehicle pv = this.firstVehicle();
            while (pv != null) {
                if (pv.currentSpeed() < 0.0f) {
                    this.logger.error((Object)("Vehicle " + pv.getId() + " has error speed of " + pv.currentSpeed()));
                } else {
                    averageSpeed = pv.currentSpeed();
                }
                pv = pv.macroTrailing();
            }
            if (averageSpeed < 0.001f) {
                averageSpeed = 0.001f;
            } else if (this.nVehicles_ < 0) {
                this.logger.error((Object)("Road " + this.getLinkid() + " has " + this.nVehicles_ + " vehicles"));
                averageSpeed = this.freeSpeed_;
            } else {
                averageSpeed /= (float)this.nVehicles_;
            }
        }
        this.travelTime = (float)this.length / averageSpeed;
    }

    public void initDynamicTravelTime() {
        int i = 1;
        int intervalLength = GlobalVariables.SIMULATION_INTERVAL_SIZE;
        int end = GlobalVariables.SIMULATION_STOP_TIME;
        while (i < end) {
            this.dynamicTravelTime.add(this.length / (double)this.freeSpeed_);
            i += intervalLength;
        }
    }

    public void setDynamicTravelTime(double tick, double time) {
        int intervalLength = GlobalVariables.SIMULATION_INTERVAL_SIZE;
        int interval = (int)tick / intervalLength;
        this.dynamicTravelTime.add(interval, time);
    }

    public double getDynamicTravelTime(double tick) {
        int intervalLength = GlobalVariables.SIMULATION_INTERVAL_SIZE;
        int interval = (int)tick / intervalLength;
        return this.dynamicTravelTime.get(interval);
    }

    public double getTravelTime() {
        return this.travelTime;
    }

    public Lane getLane(int i) {
        return this.lanes.get(i);
    }

    public int getLaneIndex(Lane l) {
        return this.lanes.indexOf(l);
    }

    public void addLane(Lane l) {
        this.lanes.add(l);
        ++this.nLanes;
    }

    public ArrayList<Lane> getLanes() {
        return this.lanes;
    }

    public Lane leftLane() {
        return this.lanes.get(0);
    }

    public Lane rightLane() {
        int size = this.lanes.size();
        return this.lanes.get(size - 1);
    }

    public double atan3(double x1, double y1, double x0, double y0) {
        double alpha = 0.0;
        alpha = Math.atan2(y1 - y0, x1 - x0);
        if (alpha < 0.0) {
            alpha += Math.PI * 2;
        }
        return alpha;
    }

    public int getnLanes() {
        return this.nLanes;
    }

    public Lane firstLane() {
        Lane firstLane = null;
        int rightmost = this.getLanes().size() - 1;
        firstLane = this.getLane(rightmost);
        return firstLane;
    }

    public void printRoadInfo() {
        this.logger.info((Object)("Road: " + this.getIdentifier() + " has lanes from left to right as follow: "));
        int i = 0;
        while (i < this.lanes.size()) {
            this.logger.info((Object)(String.valueOf(this.lanes.get(i).getLaneid()) + " with Repast ID: " + this.lanes.get(i).getID()));
            ++i;
        }
    }

    public void printRoadCoordinate() {
        Coordinate start = this.getJunctions().get(0).getCoordinate();
        Coordinate end = this.getJunctions().get(1).getCoordinate();
        this.logger.info((Object)("Coordinate of road: " + this.getLinkid()));
        this.logger.info((Object)("Starting point: " + start));
        this.logger.info((Object)("Ending point: " + end));
    }

    public void updateFreeFlowSpeed() {
        int tickcount = (int)RepastEssentials.GetTickCount();
        int hour = (int)Math.floor((float)tickcount * GlobalVariables.SIMULATION_STEP_SIZE / 3600.0f);
        if (this.curhour < (hour %= 24)) {
            float value = (float)((double)BackgroundTraffic.backgroundTraffic.get(this.linkid).get(hour).floatValue() * 0.44704);
            if (this.checkEventFlag()) {
                this.setDefaultFreeSpeed();
            } else {
                this.freeSpeed_ = value;
            }
        }
        this.curhour = hour;
    }

    public void updateFreeFlowSpeed_event(float newFFSpd) {
        this.freeSpeed_ = (float)((double)newFFSpd * 0.44704);
    }

    public void printTick() {
        int tickcount = (int)RepastEssentials.GetTickCount();
        this.logger.info((Object)("Tick: " + tickcount));
    }
}

