/*
 * Decompiled with CFR 0.152.
 */
package evacSim.citycontext;

import com.vividsolutions.jts.geom.Coordinate;
import evacSim.ContextCreator;
import evacSim.GlobalVariables;
import evacSim.citycontext.Lane;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Map;
import repast.simphony.context.Context;
import repast.simphony.context.DefaultContext;
import repast.simphony.context.space.gis.GeographyFactoryFinder;
import repast.simphony.space.gis.Geography;
import repast.simphony.space.gis.GeographyParameters;
import repast.simphony.space.gis.ShapefileLoader;

public class LaneContext
extends DefaultContext<Lane> {
    private static Map<Coordinate, ?> coordCache;

    public LaneContext() {
        super((Object)"LaneContext");
        ContextCreator.logger.info((Object)"LaneContext: building lane context and projections");
        GeographyParameters geoParams = new GeographyParameters();
        Geography laneGeography = GeographyFactoryFinder.createGeographyFactory(null).createGeography("LaneGeography", (Context)this, geoParams);
        File laneFile = null;
        ShapefileLoader laneLoader = null;
        String fileName = GlobalVariables.LANES_CSV;
        try {
            laneFile = new File(GlobalVariables.LANES_SHAPEFILE);
            URI uri = laneFile.toURI();
            laneLoader = new ShapefileLoader(Lane.class, uri.toURL(), laneGeography, (Context)this);
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            while (laneLoader.hasNext()) {
                Lane lane = (Lane)laneLoader.next();
                String line = br.readLine();
                String[] result = line.split(",");
                lane = this.setAttribute(lane, result);
            }
            br.close();
        }
        catch (MalformedURLException e) {
            System.out.println("ContextCreator: malformed URL exception when reading roadshapefile. Check the 'roadLoc' parameter is correct");
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            System.out.println("ContextCreator: No road csv file found");
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Lane setAttribute(Lane l, String[] att) {
        l.setLaneid(Integer.parseInt(att[5]));
        l.setLink(Integer.parseInt(att[1]));
        l.setLeft(Integer.parseInt(att[2]));
        l.setThrough(Integer.parseInt(att[3]));
        l.setRight(Integer.parseInt(att[4]));
        return l;
    }
}

