/*
 * Decompiled with CFR 0.152.
 */
package evacSim.citycontext;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.operation.distance.DistanceOp;
import evacSim.ContextCreator;
import evacSim.GlobalVariables;
import evacSim.citycontext.Junction;
import evacSim.citycontext.JunctionContext;
import evacSim.citycontext.Lane;
import evacSim.citycontext.LaneContext;
import evacSim.citycontext.Road;
import evacSim.citycontext.RoadContext;
import evacSim.citycontext.Zone;
import evacSim.citycontext.ZoneContext;
import evacSim.routing.RouteV;
import evacSim.vehiclecontext.Vehicle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import org.apache.log4j.Logger;
import repast.simphony.context.Context;
import repast.simphony.context.DefaultContext;
import repast.simphony.essentials.RepastEssentials;
import repast.simphony.space.gis.Geography;
import repast.simphony.space.graph.Network;
import repast.simphony.space.graph.RepastEdge;

public class CityContext
extends DefaultContext<Object> {
    Logger logger = ContextCreator.logger;
    private HashMap<RepastEdge<?>, Integer> edgeLinkID_KeyEdge = new HashMap();
    private HashMap<RepastEdge<?>, Integer> edgeIdNum_KeyEdge = new HashMap();
    private HashMap<Integer, RepastEdge<?>> edgeIDs_KeyIDNum = new HashMap();
    private HashMap<Integer, Lane> lane_KeyLaneID = new HashMap();
    private HashMap<Integer, Road> road_KeyLinkID;
    private HashMap<Integer, Junction> junction_KeyJunctionID = new HashMap();
    private Map<Coordinate, Coordinate> nearestRoadCoordCache;
    private Coordinate origin;

    public CityContext() {
        super((Object)"CityContext");
        this.road_KeyLinkID = new HashMap();
        this.origin = new Coordinate(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public void createSubContexts() {
        this.addSubContext((Context)new RoadContext());
        this.addSubContext((Context)new JunctionContext());
        this.addSubContext((Context)new LaneContext());
        this.addSubContext((Context)new ZoneContext());
    }

    public void buildRoadNetwork() {
        Geography<Lane> laneGeography = ContextCreator.getLaneGeography();
        Iterable laneIt = laneGeography.getAllObjects();
        Geography<Road> roadGeography = ContextCreator.getRoadGeography();
        Geography<Junction> junctionGeography = ContextCreator.getJunctionGeography();
        JunctionContext junctionContext = ContextCreator.getJunctionContext();
        Network<Junction> roadNetwork = ContextCreator.getRoadNetwork();
        GeometryFactory geomFac = new GeometryFactory();
        Iterable roadIt = roadGeography.getAllObjects();
        for (Road road : roadIt) {
            Junction junc2;
            Junction junc1;
            this.road_KeyLinkID.put(road.getLinkid(), road);
            Geometry roadGeom = roadGeography.getGeometry((Object)road);
            Coordinate c1 = roadGeom.getCoordinates()[0];
            Coordinate c2 = roadGeom.getCoordinates()[roadGeom.getNumPoints() - 1];
            if (c1.x < this.origin.x) {
                this.origin.x = c1.x;
            }
            if (c2.x < this.origin.x) {
                this.origin.x = c2.x;
            }
            if (c1.y < this.origin.y) {
                this.origin.y = c1.y;
            }
            if (c1.y < this.origin.y) {
                this.origin.y = c2.y;
            }
            if (!this.junction_KeyJunctionID.containsKey(road.getFn())) {
                junc1 = new Junction(c1, road.getFn());
                this.junction_KeyJunctionID.put(road.getFn(), junc1);
                junctionContext.add(junc1);
                Point p1 = geomFac.createPoint(c1);
                junctionGeography.move((Object)junc1, (Geometry)p1);
            } else {
                junc1 = this.junction_KeyJunctionID.get(road.getFn());
            }
            if (!this.junction_KeyJunctionID.containsKey(road.getTn())) {
                junc2 = new Junction(c2, road.getTn());
                this.junction_KeyJunctionID.put(road.getTn(), junc2);
                junctionContext.add(junc2);
                Point p2 = geomFac.createPoint(c2);
                junctionGeography.move((Object)junc2, (Geometry)p2);
            } else {
                junc2 = this.junction_KeyJunctionID.get(road.getTn());
            }
            road.addJunction(junc1);
            road.addJunction(junc2);
            junc1.addRoad(road);
            junc2.addRoad(road);
            RepastEdge edge = new RepastEdge((Object)junc1, (Object)junc2, true, road.getLength());
            try {
                this.edgeLinkID_KeyEdge.put(edge, road.getLinkid());
                this.edgeIdNum_KeyEdge.put(edge, road.getID());
                this.edgeIDs_KeyIDNum.put(road.getID(), edge);
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage());
            }
            if (!roadNetwork.containsEdge(edge)) {
                roadNetwork.addEdge(edge);
                continue;
            }
            System.err.println("CityContext: buildRoadNetwork: for some reason this edge that has just been created already exists in the RoadNetwork!");
        }
        roadIt = roadGeography.getAllObjects();
        for (Lane lane : laneIt) {
            this.lane_KeyLaneID.put(lane.getLaneid(), lane);
            for (Road road : roadIt) {
                if ((long)road.getLinkid() != (long)lane.getLink()) continue;
                lane.setRoad(road);
            }
        }
        for (Road r : roadIt) {
            this.roadMovementFromShapeFile(r);
            this.laneConnectionsFromShapeFile(r);
        }
        for (Zone z : ContextCreator.getZoneGeography().getAllObjects()) {
            z.setRoad();
        }
    }

    public void roadMovementFromShapeFile(Road road) {
        ArrayList<Integer> dsLinkIds = new ArrayList<Integer>();
        dsLinkIds.add(road.getLeft());
        dsLinkIds.add(road.getThrough());
        dsLinkIds.add(road.getRight());
        dsLinkIds.add(road.getTlinkid());
        Road opRoad = this.road_KeyLinkID.get(road.getTlinkid());
        road.setOppositeRoad(opRoad);
        Iterator iterator = dsLinkIds.iterator();
        while (iterator.hasNext()) {
            int dsRoadId = (Integer)iterator.next();
            if (dsRoadId == 0) continue;
            Road dsRoad = this.road_KeyLinkID.get(dsRoadId);
            road.addDownStreamMovement(dsRoad);
        }
    }

    public Road getRoadfromID(int roadId_) {
        Geography<Road> roadGeography = ContextCreator.getRoadGeography();
        Iterable roadIt = roadGeography.getAllObjects();
        for (Road road : roadIt) {
            if (road.getLinkid() != roadId_) continue;
            return road;
        }
        return null;
    }

    public Lane getLanefromID(int laneID) {
        Geography<Lane> laneGeography = ContextCreator.getLaneGeography();
        Iterable laneIt = laneGeography.getAllObjects();
        for (Lane lane : laneIt) {
            if (lane.getLaneid() != laneID) continue;
            return lane;
        }
        return null;
    }

    public void laneConnectionsFromShapeFile(Road road) {
        Lane dsLane;
        Lane curLane;
        ArrayList<Integer> dsLaneIds = new ArrayList<Integer>();
        int nLanes = road.getnLanes();
        int i = 0;
        while (i < nLanes) {
            curLane = road.getLanes().get(i);
            dsLaneIds.clear();
            dsLaneIds.add(curLane.getLeft());
            dsLaneIds.add(curLane.getThrough());
            dsLaneIds.add(curLane.getRight());
            Iterator iterator = dsLaneIds.iterator();
            while (iterator.hasNext()) {
                double dsLaneId = ((Integer)iterator.next()).intValue();
                if (dsLaneId == 0.0) continue;
                dsLane = this.lane_KeyLaneID.get((int)dsLaneId);
                curLane.addDnLane(dsLane);
                dsLane.addUpLane(curLane);
            }
            ++i;
        }
        if (road.getOppositeRoad() != null && (curLane = road.getLanes().get(0)).getLength() > GlobalVariables.MIN_UTURN_LENGTH) {
            dsLane = road.getOppositeRoad().getLanes().get(0);
            curLane.addDnLane(dsLane);
            dsLane.addUpLane(curLane);
        }
    }

    public void modifyRoadNetwork() {
        Geography<Road> roadGeography = ContextCreator.getRoadGeography();
        Iterable roadIt = roadGeography.getAllObjects();
        for (Road road : roadIt) {
            road.setTravelTime();
            Junction junc1 = road.getJunctions().get(0);
            Junction junc2 = road.getJunctions().get(1);
            ContextCreator.getRoadNetwork().getEdge((Object)junc1, (Object)junc2).setWeight(road.getTravelTime());
        }
        int tickcount = (int)RepastEssentials.GetTickCount();
        this.logger.info((Object)("Tick: " + tickcount));
        if (tickcount < 1) {
            try {
                RouteV.createRoute();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            RouteV.updateRoute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getLinkIDFromEdge(RepastEdge<Junction> edge) {
        int id = 0;
        try {
            id = this.edgeLinkID_KeyEdge.get(edge);
        }
        catch (Exception e) {
            System.err.println("CityContext: getIDDromEdge: Error, probably no id found for edge " + edge.toString());
            this.logger.error((Object)e.getStackTrace());
        }
        return id;
    }

    public int getIdNumFromEdge(RepastEdge<Junction> edge) {
        int id = 0;
        try {
            id = this.edgeIdNum_KeyEdge.get(edge);
        }
        catch (Exception e) {
            System.err.println("CityContext: getIdNumFromEdge: Error, probably no id found for edge " + edge.toString());
            this.logger.error((Object)e.getStackTrace());
        }
        return id;
    }

    public RepastEdge<?> getEdgeFromIDNum(int id) {
        RepastEdge<?> edge = null;
        try {
            edge = this.edgeIDs_KeyIDNum.get(id);
        }
        catch (Exception e) {
            System.err.println("CityContext: getEdgeDromID: Error, probably no edge found for id " + id);
            this.logger.error((Object)e.getStackTrace());
        }
        return edge;
    }

    public int findRoadIDAtCoordinates(Coordinate coord) throws NullPointerException {
        if (coord == null) {
            throw new NullPointerException("CityContext: findRoadAtCoordinates: ERROR: the input coordinate is null");
        }
        GeometryFactory geomFac = new GeometryFactory();
        Geography<Road> roadGeography = ContextCreator.getRoadGeography();
        Point point = geomFac.createPoint(coord);
        Geometry buffer = point.buffer(GlobalVariables.XXXX_BUFFER);
        double minDist = Double.MAX_VALUE;
        int nearestRoadID = 0;
        for (Road road : roadGeography.getObjectsWithin(buffer.getEnvelopeInternal(), Road.class)) {
            DistanceOp distOp = new DistanceOp((Geometry)point, roadGeography.getGeometry((Object)road));
            double thisDist = distOp.distance();
            if (!(thisDist < minDist)) continue;
            minDist = thisDist;
            nearestRoadID = road.getLinkid();
        }
        if (nearestRoadID == 0) {
            System.err.println("CityContext: findRoadAtCoordinates (Coordinate coord): ERROR: couldn't find a road at these coordinates:\n\t" + coord.toString());
        }
        return nearestRoadID;
    }

    public Road findRoadAtCoordinates(Coordinate coord) throws NullPointerException {
        if (coord == null) {
            throw new NullPointerException("CityContext: findRoadAtCoordinates: ERROR: the input coordinate is null");
        }
        GeometryFactory geomFac = new GeometryFactory();
        Geography<Road> roadGeography = ContextCreator.getRoadGeography();
        Point point = geomFac.createPoint(coord);
        Geometry buffer = point.buffer(GlobalVariables.XXXX_BUFFER);
        double minDist = Double.MAX_VALUE;
        Road nearestRoad = null;
        for (Road road : roadGeography.getObjectsWithin(buffer.getEnvelopeInternal(), Road.class)) {
            DistanceOp distOp = new DistanceOp((Geometry)point, roadGeography.getGeometry((Object)road));
            double thisDist = distOp.distance();
            if (!(thisDist < minDist)) continue;
            minDist = thisDist;
            nearestRoad = road;
        }
        if (nearestRoad == null) {
            System.err.println("CityContext: findRoadAtCoordinates (Coordinate coord): ERROR: couldn't find a road at these coordinates:\n\t" + coord.toString());
        }
        return nearestRoad;
    }

    public Road findRoadAtCoordinates(Coordinate coord, boolean toDest) throws NullPointerException {
        if (coord == null) {
            throw new NullPointerException("CityContext: findRoadAtCoordinates: ERROR: the input coordinate is null");
        }
        GeometryFactory geomFac = new GeometryFactory();
        Geography<Road> roadGeography = ContextCreator.getRoadGeography();
        Point point = geomFac.createPoint(coord);
        Geometry buffer = point.buffer(GlobalVariables.XXXX_BUFFER);
        double minDist = Double.MAX_VALUE;
        Road nearestRoad = null;
        for (Road road : roadGeography.getObjectsWithin(buffer.getEnvelopeInternal(), Road.class)) {
            double thisDist;
            DistanceOp distOp;
            if (toDest) {
                Coordinate roadToNode = road.getJunctions().get(1).getCoordinate();
                Point pointToNode = geomFac.createPoint(roadToNode);
                distOp = new DistanceOp((Geometry)point, (Geometry)pointToNode);
                thisDist = distOp.distance();
                if (!(thisDist < minDist)) continue;
                minDist = thisDist;
                nearestRoad = road;
                continue;
            }
            Coordinate roadFromNode = road.getJunctions().get(0).getCoordinate();
            Point pointFromNode = geomFac.createPoint(roadFromNode);
            distOp = new DistanceOp((Geometry)point, (Geometry)pointFromNode);
            thisDist = distOp.distance();
            if (!(thisDist < minDist)) continue;
            minDist = thisDist;
            nearestRoad = road;
        }
        if (nearestRoad == null) {
            System.err.println("CityContext: findRoadAtCoordinates (Coordinate coord, boolean toDest): ERROR: couldn't find a road at these coordinates:\n\t" + coord.toString());
        }
        return nearestRoad;
    }

    public Road findRoadWithID(int id) {
        Geography<Road> roadGeography = ContextCreator.getRoadGeography();
        for (Road road : roadGeography.getAllObjects()) {
            if (road.getLinkid() != id) continue;
            return road;
        }
        System.err.println("CityContext: findRoadWithID: Error, couldn't find a road woth id: " + id);
        return new Road();
    }

    public Road findRoadBetweenJunctionIDs(int junc1, int junc2) {
        Geography<Road> roadGeography = ContextCreator.getRoadGeography();
        for (Road road : roadGeography.getAllObjects()) {
            ArrayList<Junction> junctions = road.getJunctions();
            if (junctions.get(0).getJunctionID() != junc1 || junctions.get(1).getJunctionID() != junc2) continue;
            return road;
        }
        System.err.println("CityContext: findRoadBetweenJunctionIDs: Error, couldn't find a road with id: " + junc1 + " to id: " + junc2);
        return null;
    }

    public Road findRoadWithLinkID(int linkID) {
        return this.road_KeyLinkID.get(linkID);
    }

    public Zone findHouseWithID(int id) {
        Geography<Zone> zoneGeography = ContextCreator.getZoneGeography();
        for (Zone house : zoneGeography.getAllObjects()) {
            if (house.getId() != id) continue;
            return house;
        }
        System.err.println("CityContext: findHouseWithID: Error, couldn't find a house with id: " + id);
        return null;
    }

    public Zone findHouseWithDestID(int destid) {
        Geography<Zone> zoneGeography = ContextCreator.getZoneGeography();
        for (Zone house : zoneGeography.getAllObjects()) {
            if (house.getIntegerId() != destid) continue;
            return house;
        }
        System.err.println("CityContext: findHouseWithDestID: Error, couldn't find a house with id: " + destid);
        return null;
    }

    public Road findRoadWithHouseID(int id) {
        Geography<Zone> zoneGeography = ContextCreator.getZoneGeography();
        for (Zone house : zoneGeography.getAllObjects()) {
            if (house.getId() != id) continue;
            Coordinate coord = house.getCoord();
            Road road = this.findRoadWithID(this.findRoadIDAtCoordinates(coord));
            return road;
        }
        System.err.println("CityContext: findRoadWithHouseID: Error, couldn't find a house with id: " + id);
        return new Road();
    }

    public void createNearestRoadCoordCache() {
        this.nearestRoadCoordCache = new Hashtable<Coordinate, Coordinate>();
        HashMap<Road, Geometry> allRoads = new HashMap<Road, Geometry>();
        for (Road r : ContextCreator.getRoadGeography().getAllObjects()) {
            allRoads.put(r, ContextCreator.getRoadGeography().getGeometry((Object)r));
        }
        for (Zone h : ContextCreator.getZoneGeography().getAllObjects()) {
            double minDist = Double.MAX_VALUE;
            Coordinate houseCoord = ContextCreator.getZoneGeography().getGeometry((Object)h).getCentroid().getCoordinate();
            Coordinate nearestPoint = null;
            Point coordGeom = ContextCreator.getZoneGeography().getGeometry((Object)h).getCentroid();
            block2: for (Road r : allRoads.keySet()) {
                Geometry roadGeom = (Geometry)allRoads.get(r);
                DistanceOp distOp = new DistanceOp((Geometry)coordGeom, roadGeom);
                double thisDist = distOp.distance();
                if (!(thisDist < minDist)) continue;
                minDist = thisDist;
                Coordinate[] coordinateArray = distOp.nearestPoints();
                int n = coordinateArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Coordinate c = coordinateArray[n2];
                    if (!c.equals((Object)houseCoord)) {
                        nearestPoint = c;
                        continue block2;
                    }
                    ++n2;
                }
            }
            this.nearestRoadCoordCache.put(houseCoord, nearestPoint);
        }
    }

    public Coordinate getNearestRoadCoordFromCache(Coordinate c) {
        return this.nearestRoadCoordCache.get(c);
    }

    public boolean nearestRoadsCached() {
        return this.nearestRoadCoordCache != null;
    }

    public static double angle(Coordinate p0, Coordinate p1) {
        double dx = p1.x - p0.x;
        double dy = p1.y - p0.y;
        return Math.atan2(dy, dx);
    }

    public static double squaredEuclideanDistance(Coordinate p0, Coordinate p1) {
        return (p0.x - p1.x) * (p0.x - p1.x) + (p0.y - p1.y) * (p0.y - p1.y);
    }

    public Zone getClosestShelter(Vehicle vehicle) throws Exception {
        int strategy = GlobalVariables.DYNAMIC_DEST_STRATEGY;
        double minDist = Double.MAX_VALUE;
        Zone nearestShelter = null;
        Map<Float, Queue<Road>> currentPathPlusDist = null;
        ArrayList<Zone> eligibleShelters = new ArrayList<Zone>();
        GeometryFactory geomFac = new GeometryFactory();
        Geography<Zone> zoneGeography = ContextCreator.getZoneGeography();
        Point point = geomFac.createPoint(vehicle.getCurrentCoord());
        Geometry buffer = point.buffer(GlobalVariables.XXXX_BUFFER);
        Iterable zones = zoneGeography.getObjectsWithin(buffer.getEnvelopeInternal(), Zone.class);
        for (Zone zone : zones) {
            if (zone.getType() != 1 || vehicle.getVisitedShelters().containsKey(zone.getIntegerId())) continue;
            if (strategy == 1) {
                eligibleShelters.add(zone);
                continue;
            }
            if (zone.getOccupancy() >= zone.getCapacity()) continue;
            eligibleShelters.add(zone);
        }
        if (eligibleShelters.size() == 0) {
            return null;
        }
        for (Zone shelter : eligibleShelters) {
            currentPathPlusDist = RouteV.vehicleRoute(vehicle, shelter);
            try {
                Iterator<Float> iterator = currentPathPlusDist.keySet().iterator();
                while (iterator.hasNext()) {
                    double dist = iterator.next().floatValue();
                    if (!(dist < minDist)) continue;
                    nearestShelter = shelter;
                    minDist = dist;
                }
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
        return nearestShelter;
    }

    public void loadDemandOfNextHour() {
        if (ContextCreator.getZoneContext().dataset.getHousesByHour().size() > 0) {
            this.logger.info((Object)"Loading demand for the next hour...");
            ContextCreator.getZoneContext().loadDemandofNextHour();
            ContextCreator.getVehicleContext().createVehicleContextFromActivityModels();
        }
    }

    public void soShelterRoutingSchedule() {
        ContextCreator.getZoneContext().soShelterMatcher.assignMatching(GlobalVariables.SO_SHELTER_MATCHING_ALGO);
    }

    public Coordinate getOrigin() {
        return this.origin;
    }
}

