/*
 * Decompiled with CFR 0.152.
 */
package evacSim;

import evacSim.ContextCreator;
import evacSim.GlobalVariables;
import evacSim.PartitionThread;
import evacSim.citycontext.Road;
import evacSim.vehiclecontext.Vehicle;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.simple.JSONObject;
import repast.simphony.essentials.RepastEssentials;

public class ThreadedScheduler {
    private ExecutorService executor;
    private int N_Partition;
    private int N_threads;
    private int min_para_time;
    private int max_para_time;
    private int avg_para_time;
    private int seq_time;

    public ThreadedScheduler(int N_threads) {
        this.N_threads = N_threads;
        this.executor = Executors.newFixedThreadPool(this.N_threads);
        this.N_Partition = GlobalVariables.N_Partition;
        this.min_para_time = 0;
        this.max_para_time = 0;
        this.avg_para_time = 0;
        this.seq_time = 0;
    }

    public void step() {
        for (Road r : ContextCreator.getRoadGeography().getAllObjects()) {
            r.step();
        }
    }

    public void paraStep() {
        ArrayList<ArrayList<Road>> PartitionedInRoads = ContextCreator.partitioner.getPartitionedInRoads();
        ArrayList<PartitionThread> tasks = new ArrayList<PartitionThread>();
        int i = 0;
        while (i < this.N_Partition) {
            tasks.add(new PartitionThread(PartitionedInRoads.get(i), i));
            ++i;
        }
        try {
            List futures = this.executor.invokeAll(tasks);
            ArrayList<Integer> time_stat = new ArrayList<Integer>();
            int i2 = 0;
            while (i2 < this.N_Partition) {
                time_stat.add((Integer)futures.get(i2).get());
                ++i2;
            }
            ArrayList<Integer> time_result = this.minMaxAvg(time_stat);
            this.min_para_time += time_result.get(0).intValue();
            this.max_para_time += time_result.get(1).intValue();
            this.avg_para_time += time_result.get(2).intValue();
            int tickcount = (int)RepastEssentials.GetTickCount();
            if (tickcount % 6000 == 0) {
                this.createVehicleList();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void createVehicleList() {
        String outDir = GlobalVariables.OUTPUT_DIR;
        String basename = "";
        if (GlobalVariables.ORGANIZE_OUTPUT_BY_ACTIVITY_FNAME) {
            String[] temp = GlobalVariables.OUTPUT_DIR.split("/");
            basename = temp[temp.length - 1];
        }
        int tickcount = (int)RepastEssentials.GetTickCount();
        String outpath = String.valueOf(outDir) + File.separatorChar + "vehicle-list-" + basename + "-" + tickcount / 6000 + ".json";
        BufferedWriter bw = null;
        try {
            try {
                FileWriter fw = new FileWriter(outpath, false);
                bw = new BufferedWriter(fw);
                HashMap<Integer, String> storeJsonObjects = new HashMap<Integer, String>();
                for (Road r : ContextCreator.getRoadGeography().getAllObjects()) {
                    Vehicle pv = r.firstVehicle();
                    while (pv != null) {
                        String info = String.format("%d,%d,%.5f,%.5f", pv.getHouse().getZoneId(), pv.getDestinationID(), pv.getCurrentCoord().x, pv.getCurrentCoord().y);
                        storeJsonObjects.put(pv.getVehicleID(), info);
                        pv = pv.macroTrailing();
                    }
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.putAll(storeJsonObjects);
                bw.write(JSONObject.toJSONString((Map)jsonObject));
                bw.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    bw.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                bw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void stepBwRoads() {
        ArrayList<Road> PartitionedBwRoads = ContextCreator.partitioner.getPartitionedBwRoads();
        for (Road r : PartitionedBwRoads) {
            r.step();
        }
    }

    public void shutdownScheduler() {
        this.executor.shutdown();
    }

    public ArrayList<Integer> minMaxAvg(ArrayList<Integer> values) {
        int min = values.get(0);
        int max = values.get(0);
        int sum = 0;
        for (int value : values) {
            min = Math.min(value, min);
            max = Math.max(value, max);
            sum += value;
        }
        int avg = sum / values.size();
        ArrayList<Integer> results = new ArrayList<Integer>();
        results.add(min);
        results.add(max);
        results.add(avg);
        return results;
    }

    public void reportTime() {
        this.min_para_time = 0;
        this.max_para_time = 0;
        this.avg_para_time = 0;
        this.seq_time = 0;
    }
}

