/*
 * Decompiled with CFR 0.152.
 */
package evacSim;

import au.com.bytecode.opencsv.CSVReader;
import evacSim.ContextCreator;
import evacSim.GlobalVariables;
import evacSim.NetworkEventObject;
import evacSim.citycontext.Road;
import evacSim.data.DataCollector;
import evacSim.network.ConnectionManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import repast.simphony.essentials.RepastEssentials;
import repast.simphony.space.gis.Geography;

public class NetworkEventHandler {
    private TreeMap<Integer, ArrayList<NetworkEventObject>> runningQueue = new TreeMap();
    private static final ConnectionManager manager = ConnectionManager.getInstance();

    public NetworkEventHandler() {
        this.readEventFile();
    }

    public void readEventFile() {
        File eventFile = new File(GlobalVariables.EVENT_FILE);
        CSVReader csvreader = null;
        int startTime = 0;
        int endTime = 0;
        int eventID = 0;
        int roadID = 0;
        double value1 = 0.0;
        double value2 = 0.0;
        try {
            String[] nextLine;
            csvreader = new CSVReader((Reader)new FileReader(eventFile));
            boolean readingheader = true;
            while ((nextLine = csvreader.readNext()) != null) {
                if (readingheader) {
                    readingheader = false;
                    continue;
                }
                startTime = Math.round((float)Integer.parseInt(nextLine[0]) / GlobalVariables.SIMULATION_STEP_SIZE);
                endTime = Math.round((float)Integer.parseInt(nextLine[1]) / GlobalVariables.SIMULATION_STEP_SIZE);
                startTime -= startTime % GlobalVariables.EVENT_CHECK_FREQUENCY;
                endTime -= endTime % GlobalVariables.EVENT_CHECK_FREQUENCY;
                eventID = Integer.parseInt(nextLine[2]);
                roadID = Integer.parseInt(nextLine[3]);
                value1 = Double.parseDouble(nextLine[4]);
                value2 = Double.parseDouble(nextLine[5]);
                NetworkEventObject EventObject = new NetworkEventObject(startTime, endTime, eventID, roadID, value1, value2);
                GlobalVariables.newEventQueue.add(EventObject);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void checkEvents() {
        int tickcount = (int)RepastEssentials.GetTickCount();
        this.checkNewEvents(tickcount);
        this.terminateRunningEvents(tickcount);
    }

    public void checkNewEvents(int tickcount) {
        boolean flag = true;
        while (flag) {
            NetworkEventObject e = GlobalVariables.newEventQueue.peek();
            if (e != null) {
                if (e.startTime <= tickcount) {
                    NetworkEventObject event = this.setEvent(e, true);
                    try {
                        DataCollector.getInstance().recordEventSnapshot(e, 1);
                    }
                    catch (Throwable t) {
                        DataCollector.printDebug("ERR" + t.getMessage());
                    }
                    if (event != null) {
                        if (this.runningQueue.containsKey(e.endTime)) {
                            this.runningQueue.get(e.endTime).add(e);
                        } else {
                            ArrayList<NetworkEventObject> runningEvents = new ArrayList<NetworkEventObject>();
                            runningEvents.add(e);
                            this.runningQueue.put(e.endTime, runningEvents);
                        }
                    }
                    GlobalVariables.newEventQueue.remove();
                    continue;
                }
                flag = false;
                continue;
            }
            flag = false;
        }
    }

    public void terminateRunningEvents(int tickcount) {
        if (this.runningQueue.containsKey(tickcount)) {
            ArrayList<NetworkEventObject> terminateEvents = this.runningQueue.get(tickcount);
            for (NetworkEventObject e : terminateEvents) {
                this.setEvent(e, false);
                try {
                    DataCollector.getInstance().recordEventSnapshot(e, 2);
                }
                catch (Throwable t) {
                    DataCollector.printDebug("ERR" + t.getMessage());
                }
            }
            this.runningQueue.remove(tickcount);
            terminateEvents.clear();
        }
    }

    public NetworkEventObject setEvent(NetworkEventObject event, boolean mode) {
        if (event == null) {
            return null;
        }
        Geography<Road> roadGeography = ContextCreator.getRoadGeography();
        Iterable roadIt = roadGeography.getAllObjects();
        block6: for (Road road : roadIt) {
            if (road.getLinkid() != event.roadID) continue;
            if (mode) {
                switch (event.eventID) {
                    case 1: {
                        if (!road.checkEventFlag()) {
                            road.setDefaultFreeSpeed();
                            road.updateFreeFlowSpeed_event((float)event.value1);
                            road.setEventFlag();
                            return event;
                        }
                        NetworkEventObject conflictEvent = null;
                        block7: for (Map.Entry<Integer, ArrayList<NetworkEventObject>> entry : this.runningQueue.entrySet()) {
                            ArrayList<NetworkEventObject> tempEventList = entry.getValue();
                            for (NetworkEventObject e : tempEventList) {
                                if (e.roadID != event.roadID) continue;
                                conflictEvent = e;
                                continue block7;
                            }
                        }
                        if (conflictEvent == null) break block6;
                        NetworkEventObject tempEvent = this.setEvent(conflictEvent, false);
                        this.runningQueue.get(conflictEvent.endTime).remove(conflictEvent);
                        tempEvent = this.setEvent(event, true);
                        return tempEvent;
                    }
                }
                break;
            }
            switch (event.eventID) {
                case 1: {
                    road.updateFreeFlowSpeed_event((float)road.getDefaultFreeSpeed());
                    road.restoreEventFlag();
                    return event;
                }
            }
            break;
        }
        return null;
    }
}

