/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.metrics;

import edu.uci.ics.jung.graph.Graph;
import org.apache.commons.collections15.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructuralHoles<V, E> {
    protected Transformer<E, ? extends Number> edge_weight;
    protected Graph<V, E> g;

    public StructuralHoles(Graph<V, E> graph, Transformer<E, ? extends Number> nev) {
        this.g = graph;
        this.edge_weight = nev;
    }

    public double effectiveSize(V v) {
        double result = this.g.degree(v);
        for (Object u : this.g.getNeighbors(v)) {
            for (Object w : this.g.getNeighbors(u)) {
                if (w == v || w == u) continue;
                result -= this.normalizedMutualEdgeWeight(v, w) * this.maxScaledMutualEdgeWeight(u, w);
            }
        }
        return result;
    }

    public double efficiency(V v) {
        double degree = this.g.degree(v);
        if (degree == 0.0) {
            return 0.0;
        }
        return this.effectiveSize(v) / degree;
    }

    public double constraint(V v) {
        double result = 0.0;
        for (Object w : this.g.getSuccessors(v)) {
            if (v == w || !this.g.isPredecessor(v, w)) continue;
            result += this.localConstraint(v, w);
        }
        return result;
    }

    public double hierarchy(V v) {
        double v_degree = this.g.degree(v);
        if (v_degree == 0.0) {
            return Double.NaN;
        }
        if (v_degree == 1.0) {
            return 1.0;
        }
        double v_constraint = this.aggregateConstraint(v);
        double numerator = 0.0;
        for (Object w : this.g.getNeighbors(v)) {
            if (v == w) continue;
            double sl_constraint = this.localConstraint(v, w) / (v_constraint / v_degree);
            numerator += sl_constraint * Math.log(sl_constraint);
        }
        return numerator / (v_degree * Math.log(v_degree));
    }

    public double localConstraint(V v1, V v2) {
        double nmew_vw = this.normalizedMutualEdgeWeight(v1, v2);
        double inner_result = 0.0;
        for (Object w : this.g.getNeighbors(v1)) {
            inner_result += this.normalizedMutualEdgeWeight(v1, w) * this.normalizedMutualEdgeWeight(w, v2);
        }
        return (nmew_vw + inner_result) * (nmew_vw + inner_result);
    }

    public double aggregateConstraint(V v) {
        double result = 0.0;
        for (Object w : this.g.getNeighbors(v)) {
            result += this.localConstraint(v, w) * this.organizationalMeasure(this.g, w);
        }
        return result;
    }

    protected double organizationalMeasure(Graph<V, E> g, V v) {
        return 1.0;
    }

    protected double normalizedMutualEdgeWeight(V v1, V v2) {
        if (v1 == v2) {
            return 0.0;
        }
        double numerator = this.mutualWeight(v1, v2);
        if (numerator == 0.0) {
            return 0.0;
        }
        double denominator = 0.0;
        for (Object v : this.g.getNeighbors(v1)) {
            denominator += this.mutualWeight(v1, v);
        }
        if (denominator == 0.0) {
            return 0.0;
        }
        return numerator / denominator;
    }

    protected double mutualWeight(V v1, V v2) {
        Object e12 = this.g.findEdge(v1, v2);
        Object e21 = this.g.findEdge(v2, v1);
        double w12 = e12 != null ? ((Number)this.edge_weight.transform(e12)).doubleValue() : 0.0;
        double w21 = e21 != null ? ((Number)this.edge_weight.transform(e21)).doubleValue() : 0.0;
        return w12 + w21;
    }

    protected double maxScaledMutualEdgeWeight(V v1, V v2) {
        if (v1 == v2) {
            return 0.0;
        }
        double numerator = this.mutualWeight(v1, v2);
        if (numerator == 0.0) {
            return 0.0;
        }
        double denominator = 0.0;
        for (Object w : this.g.getNeighbors(v1)) {
            if (v2 == w) continue;
            denominator = Math.max(numerator, this.mutualWeight(v1, w));
        }
        if (denominator == 0.0) {
            return 0.0;
        }
        return numerator / denominator;
    }
}

