/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.standard;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.ObjectFactory;
import org.java.plugin.PathResolver;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.standard.PluginLifecycleHandler;
import org.java.plugin.standard.StandardPluginManager;
import org.java.plugin.util.ExtendedProperties;

public class StandardObjectFactory
extends ObjectFactory {
    static final String PACKAGE_NAME = "org.java.plugin.standard";
    protected Log log = LogFactory.getLog(this.getClass());
    protected ExtendedProperties config;

    protected void configure(ExtendedProperties extendedProperties) {
        this.config = extendedProperties != null ? extendedProperties : new ExtendedProperties();
    }

    protected String getImplClassName(Class clazz) {
        String string = this.config.getProperty(clazz.getName(), null);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("implementation class for " + clazz.getName() + " is " + string));
        }
        return string;
    }

    protected Object createClassInstance(String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            try {
                return classLoader.loadClass(string).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if ((classLoader = this.getClass().getClassLoader()) != null) {
            try {
                return classLoader.loadClass(string).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return ClassLoader.getSystemClassLoader().loadClass(string).newInstance();
    }

    public PluginRegistry createRegistry() {
        PluginRegistry pluginRegistry;
        String string = this.getImplClassName(PluginRegistry.class);
        if (string == null) {
            string = "org.java.plugin.registry.xml.PluginRegistryImpl";
        }
        try {
            pluginRegistry = (PluginRegistry)this.createClassInstance(string);
        }
        catch (Exception exception) {
            this.log.fatal((Object)("failed creating registry instance " + string), (Throwable)exception);
            throw new Error("failed creating registry instance " + string, exception);
        }
        pluginRegistry.configure(this.config.getSubset(string + "."));
        this.log.debug((Object)("registry instance created - " + pluginRegistry));
        return pluginRegistry;
    }

    public PathResolver createPathResolver() {
        PathResolver pathResolver;
        String string = this.getImplClassName(PathResolver.class);
        if (string == null) {
            string = "org.java.plugin.standard.StandardPathResolver";
        }
        try {
            pathResolver = (PathResolver)this.createClassInstance(string);
        }
        catch (Exception exception) {
            this.log.fatal((Object)("failed creating path resolver instance " + string), (Throwable)exception);
            throw new Error("failed creating path resolver instance " + string, exception);
        }
        try {
            pathResolver.configure(this.config.getSubset(string + "."));
        }
        catch (Exception exception) {
            this.log.fatal((Object)("failed configuring path resolver instance " + pathResolver), (Throwable)exception);
            throw new Error("failed configuring path resolver instance " + pathResolver, exception);
        }
        this.log.debug((Object)("path resolver instance created - " + pathResolver));
        return pathResolver;
    }

    protected PluginLifecycleHandler createLifecycleHandler() {
        PluginLifecycleHandler pluginLifecycleHandler;
        String string = this.getImplClassName(PluginLifecycleHandler.class);
        if (string == null) {
            string = "org.java.plugin.standard.StandardPluginLifecycleHandler";
        }
        try {
            pluginLifecycleHandler = (PluginLifecycleHandler)this.createClassInstance(string);
        }
        catch (Exception exception) {
            this.log.fatal((Object)("failed creating plug-in life cycle handler instance " + string), (Throwable)exception);
            throw new Error("failed creating plug-in life cycle handler instance " + string, exception);
        }
        pluginLifecycleHandler.configure(this.config.getSubset(string + "."));
        this.log.debug((Object)("life cycle handler instance created - " + pluginLifecycleHandler));
        return pluginLifecycleHandler;
    }

    public PluginManager createManager(PluginRegistry pluginRegistry, PathResolver pathResolver) {
        return new StandardPluginManager(pluginRegistry, pathResolver, this.createLifecycleHandler());
    }
}

