/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginRegistry;

class ParameterValueParser {
    private Object value;
    private final boolean isParsingSucceeds;
    private String parsingMessage;

    private static ExtensionPoint getExtensionPoint(PluginRegistry pluginRegistry, String string) {
        String string2 = pluginRegistry.extractPluginId(string);
        if (!pluginRegistry.isPluginDescriptorAvailable(string2)) {
            return null;
        }
        String string3 = pluginRegistry.extractId(string);
        for (ExtensionPoint extensionPoint : pluginRegistry.getPluginDescriptor(string2).getExtensionPoints()) {
            if (!extensionPoint.getId().equals(string3)) continue;
            return extensionPoint;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ParameterValueParser(PluginRegistry pluginRegistry, ExtensionPoint.ParameterDefinition parameterDefinition, String string) {
        if (parameterDefinition == null) {
            this.parsingMessage = "parameter definition is NULL";
            this.isParsingSucceeds = false;
            return;
        }
        if (string == null) {
            this.isParsingSucceeds = true;
            return;
        }
        if ("any".equals(parameterDefinition.getType()) || "null".equals(parameterDefinition.getType())) {
            this.isParsingSucceeds = true;
            return;
        }
        if ("string".equals(parameterDefinition.getType())) {
            this.value = string;
            this.isParsingSucceeds = true;
            return;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            this.isParsingSucceeds = true;
            return;
        }
        if ("boolean".equals(parameterDefinition.getType())) {
            if ("true".equals(string2)) {
                this.value = Boolean.TRUE;
            } else {
                if (!"false".equals(string2)) {
                    this.isParsingSucceeds = false;
                    return;
                }
                this.value = Boolean.FALSE;
            }
        } else {
            if ("number".equals(parameterDefinition.getType())) {
                try {
                    this.value = NumberFormat.getInstance(Locale.ENGLISH).parse(string2);
                }
                catch (ParseException parseException) {
                    this.isParsingSucceeds = false;
                    return;
                }
            }
            if ("date".equals(parameterDefinition.getType())) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
                try {
                    this.value = simpleDateFormat.parse(string2);
                }
                catch (ParseException parseException) {
                    this.isParsingSucceeds = false;
                    return;
                }
            }
            if ("time".equals(parameterDefinition.getType())) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss", Locale.ENGLISH);
                try {
                    this.value = simpleDateFormat.parse(string2);
                }
                catch (ParseException parseException) {
                    this.isParsingSucceeds = false;
                    return;
                }
            }
            if ("date-time".equals(parameterDefinition.getType())) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
                try {
                    this.value = simpleDateFormat.parse(string2);
                }
                catch (ParseException parseException) {
                    this.isParsingSucceeds = false;
                    return;
                }
            }
            if ("plugin-id".equals(parameterDefinition.getType())) {
                try {
                    this.value = pluginRegistry.getPluginDescriptor(string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.parsingMessage = "unknown plug-in ID " + string2;
                    this.isParsingSucceeds = false;
                    return;
                }
            }
            if ("extension-point-id".equals(parameterDefinition.getType())) {
                this.value = ParameterValueParser.getExtensionPoint(pluginRegistry, string2);
                if (this.value == null) {
                    this.parsingMessage = "unknown extension point UID " + string2;
                    this.isParsingSucceeds = false;
                    return;
                }
                if (parameterDefinition.getCustomData() != null) {
                    ExtensionPoint extensionPoint = ParameterValueParser.getExtensionPoint(pluginRegistry, parameterDefinition.getCustomData());
                    if (extensionPoint == null) {
                        this.parsingMessage = "unknown extension point UID " + parameterDefinition.getCustomData() + " provided as custom data";
                        this.isParsingSucceeds = false;
                        return;
                    }
                    if (!((ExtensionPoint)this.value).isSuccessorOf(extensionPoint)) {
                        this.parsingMessage = "extension point with UID " + string2 + " doesn't \"inherit\" point that is defined" + " according to custom data in parameter" + " definition - " + parameterDefinition.getCustomData();
                        this.isParsingSucceeds = false;
                        return;
                    }
                }
            } else if ("extension-id".equals(parameterDefinition.getType())) {
                String string3 = pluginRegistry.extractId(string2);
                for (Object object : pluginRegistry.getPluginDescriptor(pluginRegistry.extractPluginId(string2)).getExtensions()) {
                    if (!object.getId().equals(string3)) continue;
                    this.value = object;
                    break;
                }
                if (this.value == null) {
                    this.parsingMessage = "unknown extension UID " + string2;
                    this.isParsingSucceeds = false;
                    return;
                }
                if (parameterDefinition.getCustomData() != null) {
                    Object object;
                    ExtensionPoint extensionPoint = ParameterValueParser.getExtensionPoint(pluginRegistry, parameterDefinition.getCustomData());
                    if (extensionPoint == null) {
                        this.parsingMessage = "unknown extension point UID " + parameterDefinition.getCustomData() + " provided as custom data in parameter definition " + parameterDefinition;
                        this.isParsingSucceeds = false;
                        return;
                    }
                    object = pluginRegistry.makeUniqueId(((Extension)this.value).getExtendedPluginId(), ((Extension)this.value).getExtendedPointId());
                    ExtensionPoint extensionPoint2 = ParameterValueParser.getExtensionPoint(pluginRegistry, (String)object);
                    if (extensionPoint2 == null) {
                        this.parsingMessage = "extension point " + (String)object + " is unknown for extension " + ((Extension)this.value).getUniqueId();
                        this.isParsingSucceeds = false;
                        return;
                    }
                    if (!extensionPoint2.equals(extensionPoint) && !extensionPoint2.isSuccessorOf(extensionPoint)) {
                        this.parsingMessage = "extension with UID " + string2 + " extends point that not allowed according" + " to custom data defined in parameter" + " definition - " + parameterDefinition.getCustomData();
                        this.isParsingSucceeds = false;
                        return;
                    }
                }
            } else {
                if ("fixed".equals(parameterDefinition.getType())) {
                    StringTokenizer stringTokenizer = new StringTokenizer(parameterDefinition.getCustomData(), "|", false);
                    do {
                        if (stringTokenizer.hasMoreTokens()) continue;
                        this.parsingMessage = "not allowed value " + string2;
                        this.isParsingSucceeds = false;
                        return;
                    } while (!string2.equals(stringTokenizer.nextToken().trim()));
                    this.value = string2;
                    this.isParsingSucceeds = true;
                    return;
                }
                if ("resource".equals(parameterDefinition.getType())) {
                    try {
                        this.value = new URL(string2);
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.parsingMessage = "can't parse value " + string2 + " as an absolute URL, will treat it as relative URL";
                        this.value = null;
                    }
                    this.isParsingSucceeds = true;
                    return;
                }
            }
        }
        this.isParsingSucceeds = true;
    }

    Object getValue() {
        return this.value;
    }

    String getParsingMessage() {
        return this.parsingMessage;
    }

    boolean isParsingSucceeds() {
        return this.isParsingSucceeds;
    }
}

