/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.PathResolver;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.IntegrityCheckReport;
import org.java.plugin.registry.PluginElement;
import org.java.plugin.registry.xml.ExtensionImpl;
import org.java.plugin.registry.xml.ExtensionPointImpl;
import org.java.plugin.registry.xml.LibraryImpl;
import org.java.plugin.registry.xml.PluginDescriptorImpl;
import org.java.plugin.registry.xml.PluginPrerequisiteImpl;
import org.java.plugin.registry.xml.PluginRegistryImpl;
import org.java.plugin.util.IoUtil;
import org.java.plugin.util.ResourceManager;

class IntegrityChecker
implements IntegrityCheckReport {
    private static Log log = LogFactory.getLog(IntegrityChecker.class);
    private final PluginRegistryImpl registry;
    private List items = new LinkedList();
    private int errorsCount;
    private int warningsCount;

    IntegrityChecker(PluginRegistryImpl pluginRegistryImpl, Collection collection) {
        this.registry = pluginRegistryImpl;
        for (IntegrityCheckReport.ReportItem reportItem : collection) {
            if (reportItem.getSeverity() == 1) {
                ++this.errorsCount;
            } else if (reportItem.getSeverity() == 2) {
                ++this.warningsCount;
            }
            this.items.add(reportItem);
        }
    }

    void doCheck(PathResolver pathResolver) {
        int n = 0;
        this.items.add(new ReportItemImpl(3, null, 0, "pluginsCheckStart", null));
        try {
            for (PluginDescriptorImpl pluginDescriptorImpl : this.registry.getPluginDescriptors()) {
                ++n;
                this.items.add(new ReportItemImpl(3, pluginDescriptorImpl, 0, "pluginCheckStart", pluginDescriptorImpl.getUniqueId()));
                this.checkPlugin(pluginDescriptorImpl, pathResolver);
                this.items.add(new ReportItemImpl(3, pluginDescriptorImpl, 0, "pluginCheckFinish", pluginDescriptorImpl.getUniqueId()));
            }
        }
        catch (Exception exception) {
            log.error((Object)("integrity check failed for registry " + this.registry), (Throwable)exception);
            ++this.errorsCount;
            this.items.add(new ReportItemImpl(1, null, 1, "pluginsCheckError", exception));
        }
        this.items.add(new ReportItemImpl(3, null, 0, "pluginsCheckFinish", new Integer(n)));
    }

    private void checkPlugin(PluginDescriptorImpl pluginDescriptorImpl, PathResolver pathResolver) {
        IntegrityCheckReport.ReportItem reportItem;
        Iterator iterator;
        Object object;
        PluginElement pluginElement2;
        int n = 0;
        this.items.add(new ReportItemImpl(3, pluginDescriptorImpl, 0, "prerequisitesCheckStart", pluginDescriptorImpl.getUniqueId()));
        for (PluginElement pluginElement2 : pluginDescriptorImpl.getPrerequisites()) {
            ++n;
            if (((PluginPrerequisiteImpl)pluginElement2).isOptional() || ((PluginPrerequisiteImpl)pluginElement2).matches()) continue;
            ++this.errorsCount;
            this.items.add(new ReportItemImpl(1, pluginDescriptorImpl, 3, "unsatisfiedPrerequisite", new Object[]{((PluginPrerequisiteImpl)pluginElement2).getPluginId(), pluginDescriptorImpl.getUniqueId()}));
        }
        this.items.add(new ReportItemImpl(3, pluginDescriptorImpl, 0, "prerequisitesCheckFinish", new Object[]{new Integer(n), pluginDescriptorImpl.getUniqueId()}));
        if (pathResolver != null) {
            n = 0;
            this.items.add(new ReportItemImpl(3, pluginDescriptorImpl, 0, "librariesCheckStart", pluginDescriptorImpl.getUniqueId()));
            for (PluginElement pluginElement2 : pluginDescriptorImpl.getLibraries()) {
                ++n;
                object = pathResolver.resolvePath(pluginElement2, ((LibraryImpl)pluginElement2).getPath());
                if (IoUtil.isResourceExists((URL)object)) continue;
                ++this.errorsCount;
                this.items.add(new ReportItemImpl(1, pluginElement2, 4, "accesToResourceFailed", new Object[]{((LibraryImpl)pluginElement2).getUniqueId(), pluginDescriptorImpl.getUniqueId(), object}));
            }
            this.items.add(new ReportItemImpl(3, pluginDescriptorImpl, 0, "librariesCheckFinish", new Object[]{new Integer(n), pluginDescriptorImpl.getUniqueId()}));
        } else {
            this.items.add(new ReportItemImpl(3, pluginDescriptorImpl, 0, "librariesCheckSkip", pluginDescriptorImpl.getUniqueId()));
        }
        n = 0;
        this.items.add(new ReportItemImpl(3, pluginDescriptorImpl, 0, "extPointsCheckStart", null));
        Iterator iterator2 = pluginDescriptorImpl.getExtensionPoints().iterator();
        while (iterator2.hasNext()) {
            ++n;
            pluginElement2 = (ExtensionPointImpl)iterator2.next();
            this.items.add(new ReportItemImpl(3, pluginElement2, 0, "extPointCheckStart", ((ExtensionPointImpl)pluginElement2).getUniqueId()));
            object = ((ExtensionPointImpl)pluginElement2).validate();
            iterator = object.iterator();
            while (iterator.hasNext()) {
                reportItem = (IntegrityCheckReport.ReportItem)iterator.next();
                if (reportItem.getSeverity() == 1) {
                    ++this.errorsCount;
                } else if (reportItem.getSeverity() == 2) {
                    ++this.warningsCount;
                }
                this.items.add(reportItem);
            }
            this.items.add(new ReportItemImpl(3, pluginElement2, 0, "extPointCheckFinish", ((ExtensionPointImpl)pluginElement2).getUniqueId()));
        }
        this.items.add(new ReportItemImpl(3, pluginDescriptorImpl, 0, "extPointsCheckFinish", new Object[]{new Integer(n), pluginDescriptorImpl.getUniqueId()}));
        n = 0;
        this.items.add(new ReportItemImpl(3, pluginDescriptorImpl, 0, "extsCheckStart", null));
        iterator2 = pluginDescriptorImpl.getExtensions().iterator();
        while (iterator2.hasNext()) {
            ++n;
            pluginElement2 = (ExtensionImpl)iterator2.next();
            this.items.add(new ReportItemImpl(3, pluginElement2, 0, "extCheckStart", ((ExtensionImpl)pluginElement2).getUniqueId()));
            object = ((ExtensionImpl)pluginElement2).validate();
            iterator = object.iterator();
            while (iterator.hasNext()) {
                reportItem = (IntegrityCheckReport.ReportItem)iterator.next();
                if (reportItem.getSeverity() == 1) {
                    ++this.errorsCount;
                } else if (reportItem.getSeverity() == 2) {
                    ++this.warningsCount;
                }
                this.items.add(reportItem);
            }
            this.items.add(new ReportItemImpl(3, pluginElement2, 0, "extCheckFinish", ((ExtensionImpl)pluginElement2).getUniqueId()));
        }
        this.items.add(new ReportItemImpl(3, pluginDescriptorImpl, 0, "extsCheckFinish", new Object[]{new Integer(n), pluginDescriptorImpl.getUniqueId()}));
    }

    public int countErrors() {
        return this.errorsCount;
    }

    public int countWarnings() {
        return this.warningsCount;
    }

    public Collection getItems() {
        return this.items;
    }

    static class ReportItemImpl
    implements IntegrityCheckReport.ReportItem {
        private final byte severity;
        private final Identity source;
        private final int code;
        private final String msg;
        private final Object data;

        ReportItemImpl(byte by, Identity identity, int n, String string, Object object) {
            this.severity = by;
            this.source = identity;
            this.code = n;
            this.msg = string;
            this.data = object;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return ResourceManager.getMessage("org.java.plugin.registry.xml", this.msg, this.data);
        }

        public String getMessage(Locale locale) {
            return ResourceManager.getMessage("org.java.plugin.registry.xml", this.msg, locale, this.data);
        }

        public byte getSeverity() {
            return this.severity;
        }

        public Identity getSource() {
            return this.source;
        }
    }
}

