/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.boot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import org.java.plugin.util.ResourceManager;

public class ErrorDialog
extends JDialog {
    private static final long serialVersionUID = 7142861251076530780L;
    private JPanel jContentPane = null;
    private JPanel jPanel = null;
    private JLabel messageLabel = null;
    private JLabel errorLabel = null;
    private JPanel jPanel1 = null;
    private JButton closeButton = null;
    private JScrollPane jScrollPane = null;
    JTextArea jTextArea = null;
    private JTabbedPane jTabbedPane = null;
    private JPanel jPanelInfo = null;
    private JScrollPane jScrollPane2 = null;
    private JList jList = null;
    private JLabel dataLabel = null;
    boolean yesBtnPressed = false;
    private JButton yesButton = null;

    public static void showError(Component component, String string, String string2) {
        ErrorDialog.showError(component, string, string2, null, null);
    }

    public static void showError(Component component, String string, String string2, Object object) {
        ErrorDialog.showError(component, string, string2, object, null);
    }

    public static void showError(Component component, String string, Object object, Throwable throwable) {
        String string2 = throwable.getMessage();
        if (string2 == null || string2.trim().length() == 0) {
            string2 = throwable.toString();
        }
        ErrorDialog.showError(component, string, string2, object, throwable);
    }

    public static void showError(Component component, String string, Throwable throwable) {
        String string2 = throwable.getMessage();
        if (string2 == null || string2.trim().length() == 0) {
            string2 = throwable.toString();
        }
        ErrorDialog.showError(component, string, string2, throwable);
    }

    public static void showError(Component component, String string, String string2, Throwable throwable) {
        ErrorDialog.showError(component, string, string2, null, throwable);
    }

    public static void showError(Component component, String string, String string2, Object object, Throwable throwable) {
        Frame frame = component != null ? JOptionPane.getFrameForComponent(component) : JOptionPane.getRootFrame();
        new ErrorDialog(frame, string, string2, object, throwable, false).show();
    }

    public static boolean showWarning(Component component, String string, String string2) {
        return ErrorDialog.showWarning(component, string, string2, null, null);
    }

    public static boolean showWarning(Component component, String string, String string2, Object object) {
        return ErrorDialog.showWarning(component, string, string2, object, null);
    }

    public static boolean showWarning(Component component, String string, String string2, Throwable throwable) {
        return ErrorDialog.showWarning(component, string, string2, null, throwable);
    }

    public static boolean showWarning(Component component, String string, String string2, Object object, Throwable throwable) {
        Frame frame = component != null ? JOptionPane.getFrameForComponent(component) : JOptionPane.getRootFrame();
        ErrorDialog errorDialog = new ErrorDialog(frame, string, string2, object, throwable, true);
        errorDialog.show();
        return errorDialog.yesBtnPressed;
    }

    public static String getErrorDetails(Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append(new Date()).append(string);
        if (throwable != null) {
            stringBuffer.append(string).append("-----------------------------------------------").append(string);
            stringBuffer.append("Exception details.").append(string).append(string);
            stringBuffer.append("Class: ").append(throwable.getClass().getName()).append(string);
            stringBuffer.append("Message: ").append(throwable.getMessage()).append(string);
            ErrorDialog.printError(throwable, "Stack trace:", stringBuffer);
        }
        stringBuffer.append(string).append("-----------------------------------------------").append(string);
        stringBuffer.append("System properties:").append(string).append(string);
        for (Map.Entry<Object, Object> entry : new TreeMap<Object, Object>(System.getProperties()).entrySet()) {
            stringBuffer.append(entry.getKey()).append("=").append(entry.getValue()).append(string);
        }
        stringBuffer.append(string).append("-----------------------------------------------").append(string);
        stringBuffer.append("Runtime info:").append(string).append(string);
        Runtime runtime = Runtime.getRuntime();
        stringBuffer.append("Memory TOTAL / FREE / MAX: ").append(runtime.totalMemory()).append(" / ").append(runtime.freeMemory()).append(" / ").append(runtime.maxMemory()).append(string);
        stringBuffer.append("Available processors: ").append(runtime.availableProcessors()).append(string);
        stringBuffer.append("System class loader: ").append("" + ClassLoader.getSystemClassLoader()).append(string);
        stringBuffer.append("Thread context class loader: ").append("" + Thread.currentThread().getContextClassLoader()).append(string);
        stringBuffer.append("Security manager: ").append("" + System.getSecurityManager()).append(string);
        return stringBuffer.toString();
    }

    public static void printError(Throwable throwable, String string, StringBuffer stringBuffer) {
        if (throwable == null) {
            return;
        }
        String string2 = System.getProperty("line.separator");
        stringBuffer.append(string2).append(string).append(string2).append(string2);
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            stringBuffer.append(stackTraceElementArray[i].toString()).append(string2);
        }
        Throwable throwable2 = throwable.getCause();
        ErrorDialog.printError(throwable2, "Caused by " + throwable2, stringBuffer);
        if (throwable instanceof SQLException) {
            throwable2 = ((SQLException)throwable).getNextException();
            ErrorDialog.printError(throwable2, "Next exception: " + throwable2, stringBuffer);
        } else if (throwable instanceof InvocationTargetException) {
            throwable2 = ((InvocationTargetException)throwable).getTargetException();
            ErrorDialog.printError(throwable2, "Target exception: " + throwable2, stringBuffer);
        }
    }

    private ErrorDialog(Frame frame, String string, String string2, Object object, Throwable throwable, boolean bl) {
        super(frame != null ? frame : JOptionPane.getRootFrame());
        this.initialize();
        this.setLocationRelativeTo(this.getOwner());
        this.jTabbedPane.setTitleAt(0, ResourceManager.getMessage((String)"org.java.plugin.boot", (String)"infoTabLabel"));
        this.jTabbedPane.setTitleAt(1, ResourceManager.getMessage((String)"org.java.plugin.boot", (String)"detailsTabLabel"));
        this.setTitle(string);
        this.messageLabel.setText(string2);
        if (throwable != null) {
            this.errorLabel.setText(ResourceManager.getMessage((String)"org.java.plugin.boot", (String)"errorLabel", (Object)throwable));
        } else {
            this.getJPanel().remove(this.errorLabel);
        }
        if (object instanceof Collection) {
            DefaultListModel defaultListModel = new DefaultListModel();
            Iterator iterator = ((Collection)object).iterator();
            while (iterator.hasNext()) {
                defaultListModel.addElement(iterator.next());
            }
            this.jList.setModel(defaultListModel);
            this.getJPanel().remove(this.dataLabel);
        } else if (object instanceof Object[]) {
            DefaultListModel<Object> defaultListModel = new DefaultListModel<Object>();
            for (int i = 0; i < ((Object[])object).length; ++i) {
                defaultListModel.addElement(((Object[])object)[i]);
            }
            this.jList.setModel(defaultListModel);
            this.getJPanel().remove(this.dataLabel);
        } else if (object != null) {
            this.dataLabel.setText(object.toString());
            this.getJPanelInfo().remove(this.getJScrollPane());
        } else {
            this.getJPanel().remove(this.dataLabel);
            this.getJPanelInfo().remove(this.getJScrollPane());
        }
        this.jTextArea.setText(ErrorDialog.getErrorDetails(throwable));
        this.jTextArea.setCaretPosition(0);
        if (bl) {
            this.closeButton.setText(ResourceManager.getMessage((String)"org.java.plugin.boot", (String)"noLabel"));
            this.yesButton.setText(ResourceManager.getMessage((String)"org.java.plugin.boot", (String)"yesLabel"));
        } else {
            this.getJPanel1().remove(this.yesButton);
            this.closeButton.setText(ResourceManager.getMessage((String)"org.java.plugin.boot", (String)"closeLabel"));
        }
    }

    private void initialize() {
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setTitle("An error has occurred");
        this.setSize(460, 280);
        this.setContentPane(this.getJContentPane());
        this.getRootPane().setWindowDecorationStyle(4);
        this.getRootPane().setDefaultButton(this.closeButton);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "doCloseDefault");
        this.getRootPane().getActionMap().put("doCloseDefault", new AbstractAction(){
            private static final long serialVersionUID = -9167454634726502084L;

            public void actionPerformed(ActionEvent actionEvent) {
                ErrorDialog.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(this.getCloseButton());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            BorderLayout borderLayout = new BorderLayout();
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(borderLayout);
            borderLayout.setVgap(2);
            this.jContentPane.add((Component)this.getJPanel1(), "South");
            this.jContentPane.add((Component)this.getJTabbedPane(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.dataLabel = new JLabel();
            this.dataLabel.setText("JLabel");
            this.errorLabel = new JLabel();
            this.messageLabel = new JLabel();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BoxLayout(this.getJPanel(), 1));
            this.messageLabel.setText("JLabel");
            this.errorLabel.setText("JLabel");
            this.jPanel.add((Component)this.messageLabel, null);
            this.jPanel.add((Component)this.errorLabel, null);
            this.jPanel.add((Component)this.dataLabel, null);
        }
        return this.jPanel;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(flowLayout);
            this.jPanel1.add((Component)this.getYesButton(), null);
            this.jPanel1.add((Component)this.getCloseButton(), null);
        }
        return this.jPanel1;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.closeButton.setText("Close");
            this.closeButton.setSelected(true);
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ErrorDialog.this.dispose();
                }
            });
        }
        return this.closeButton;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJList());
        }
        return this.jScrollPane;
    }

    private JTextArea getJTextArea() {
        if (this.jTextArea == null) {
            this.jTextArea = new JTextArea();
            this.jTextArea.setBackground(SystemColor.control);
            this.jTextArea.setEditable(false);
            this.jTextArea.setOpaque(false);
            this.jTextArea.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (!mouseEvent.isPopupTrigger()) {
                        return;
                    }
                    this.copyText();
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    if (!mouseEvent.isPopupTrigger()) {
                        return;
                    }
                    this.copyText();
                }

                private void copyText() {
                    if (ErrorDialog.this.jTextArea.getSelectedText() != null) {
                        ErrorDialog.this.jTextArea.copy();
                        return;
                    }
                    ErrorDialog.this.jTextArea.setSelectionStart(0);
                    ErrorDialog.this.jTextArea.setSelectionEnd(ErrorDialog.this.jTextArea.getText().length());
                    ErrorDialog.this.jTextArea.copy();
                    ErrorDialog.this.jTextArea.setSelectionEnd(0);
                }
            });
        }
        return this.jTextArea;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.addTab("Info", null, this.getJPanelInfo(), null);
            this.jTabbedPane.addTab("Details", null, this.getJScrollPane2(), null);
        }
        return this.jTabbedPane;
    }

    private JPanel getJPanelInfo() {
        if (this.jPanelInfo == null) {
            this.jPanelInfo = new JPanel();
            this.jPanelInfo.setLayout(new BorderLayout());
            this.jPanelInfo.add((Component)this.getJPanel(), "North");
            this.jPanelInfo.add((Component)this.getJScrollPane(), "Center");
        }
        return this.jPanelInfo;
    }

    private JScrollPane getJScrollPane2() {
        if (this.jScrollPane2 == null) {
            this.jScrollPane2 = new JScrollPane();
            this.jScrollPane2.setViewportView(this.getJTextArea());
        }
        return this.jScrollPane2;
    }

    private JList getJList() {
        if (this.jList == null) {
            this.jList = new JList();
        }
        return this.jList;
    }

    private JButton getYesButton() {
        if (this.yesButton == null) {
            this.yesButton = new JButton();
            this.yesButton.setText("Yes");
            this.yesButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ErrorDialog.this.yesBtnPressed = true;
                    ErrorDialog.this.dispose();
                }
            });
        }
        return this.yesButton;
    }
}

