/*
 * Decompiled with CFR 0.152.
 */
package org.joone.util;

import java.util.Vector;
import org.joone.engine.Pattern;
import org.joone.util.OutputConverterPlugIn;

public class UnNormalizerOutputPlugIn
extends OutputConverterPlugIn {
    private double min = 0.0;
    private double max = 1.0;
    private double datamax = 0.0;
    private double datamin = 0.0;
    private transient double datadiff = 0.0;
    private transient double tmpmin = 0.0;
    private transient double tmpmax = 0.0;
    static final long serialVersionUID = 5322361123972428588L;

    public UnNormalizerOutputPlugIn() {
    }

    public UnNormalizerOutputPlugIn(String newAdvSerieSel, double newInDataMin, double newInDataMax, double newOutDataMin, double newOutDataMax) {
        this.setAdvancedSerieSelector(newAdvSerieSel);
        this.setInDataMin(newInDataMin);
        this.setInDataMax(newInDataMax);
        this.setOutDataMin(newOutDataMin);
        this.setOutDataMax(newOutDataMax);
    }

    public double getOutDataMax() {
        return this.max;
    }

    public double getOutDataMin() {
        return this.min;
    }

    public void setOutDataMax(double newMax) {
        if (this.max != newMax) {
            this.max = newMax;
            super.fireDataChanged();
        }
    }

    public void setOutDataMin(double newMin) {
        if (this.min != newMin) {
            this.min = newMin;
            super.fireDataChanged();
        }
    }

    public double getInDataMax() {
        return this.datamax;
    }

    public double getInDataMin() {
        return this.datamin;
    }

    public void setInDataMax(double newMax) {
        if (this.datamax != newMax) {
            this.datamax = newMax;
            super.fireDataChanged();
        }
    }

    public void setInDataMin(double newMin) {
        if (this.datamin != newMin) {
            this.datamin = newMin;
            super.fireDataChanged();
        }
    }

    protected boolean convert(int serie) {
        boolean retValue = false;
        Vector con_pats = this.getInputVector();
        double v = 0.0;
        int i = 0;
        int datasize = 0;
        datasize = con_pats.size();
        if (con_pats != null && serie >= 0) {
            if (this.datamax == 0.0 && this.datamin == 0.0) {
                this.setupMinMax(serie, con_pats);
            } else {
                this.tmpmin = this.datamin;
                this.tmpmax = this.datamax;
            }
            this.datadiff = this.tmpmax - this.tmpmin;
            for (i = 0; i < datasize; ++i) {
                if (this.datadiff != 0.0) {
                    v = this.getValuePoint(i, serie);
                    v = (v - this.tmpmin) / this.datadiff;
                    v = v * (this.getOutDataMax() - this.getOutDataMin()) + this.getOutDataMin();
                } else {
                    v = this.getOutDataMin();
                }
                ((Pattern)con_pats.elementAt(i)).setValue(serie, v);
                retValue = true;
            }
        }
        return retValue;
    }

    protected void convert_pattern(int serie) {
        Pattern con_pat = this.getPattern();
        double v = 0.0;
        if (con_pat != null && serie >= 0) {
            if (this.datamax != 0.0 || this.datamin != 0.0) {
                this.datadiff = this.datamax - this.datamin;
                if (this.datadiff != 0.0) {
                    v = con_pat.getArray()[serie];
                    v = (v - this.datamin) / this.datadiff;
                    v = v * (this.getOutDataMax() - this.getOutDataMin()) + this.getOutDataMin();
                } else {
                    v = this.getOutDataMin();
                }
                con_pat.setValue(serie, v);
            }
            return;
        }
    }

    private void setupMinMax(int serie, Vector pats_to_convert) {
        int datasize = pats_to_convert.size();
        this.tmpmin = this.tmpmax = this.getValuePoint(0, serie);
        for (int i = 0; i < datasize; ++i) {
            double v = this.getValuePoint(i, serie);
            if (v > this.tmpmax) {
                this.tmpmax = v;
                continue;
            }
            if (!(v < this.tmpmin)) continue;
            this.tmpmin = v;
        }
    }
}

