/*
 * Decompiled with CFR 0.152.
 */
package org.joone.util;

import org.joone.engine.Pattern;
import org.joone.util.ConverterPlugIn;

public class DeltaNormPlugIn
extends ConverterPlugIn {
    private static final long serialVersionUID = 1698511686417955514L;
    private transient double[] probVolWin;

    protected boolean convert(int serie) {
        boolean retValue = false;
        int currInput = this.getSerieIndexNumber(serie);
        if (this.getProbVolWin()[currInput] == 0.0) {
            this.getProbVolWin()[currInput] = this.calculatePVW(currInput + 1, serie);
        }
        int init = this.getSerieSelected().length;
        for (int i = this.getInputVector().size() - 1; i >= init; --i) {
            double vi = this.getDelta(i, currInput + 1, serie, false);
            Pattern currPE = (Pattern)this.getInputVector().elementAt(i);
            currPE.setValue(serie, vi /= this.getProbVolWin()[currInput]);
            retValue = true;
        }
        return retValue;
    }

    protected double calculatePVW(int delay, int serie) {
        int init = this.getSerieSelected().length;
        double sum = 0.0;
        for (int i = init; i < this.getInputVector().size(); ++i) {
            sum += this.getDelta(i, delay, serie, true);
        }
        int numPoints = this.getInputVector().size() - init;
        return (sum /= (double)numPoints) * 2.0;
    }

    protected double getDelta(int index, int delay, int serie, boolean abs) {
        double Ci = this.getValuePoint(index, serie);
        double fd = this.funcDelta(index, delay, serie);
        if (Ci == 0.0) {
            if (!abs) {
                return -fd / Math.abs(fd);
            }
            return fd / fd;
        }
        if (!abs) {
            return (Ci - fd) / Ci;
        }
        return Math.abs(Ci - fd) / Ci;
    }

    protected double funcDelta(int index, int delay, int serie) {
        return this.getValuePoint(index - delay, serie);
    }

    private double[] getProbVolWin() {
        if (this.probVolWin == null || this.probVolWin.length != this.getSerieSelected().length) {
            this.probVolWin = new double[this.getSerieSelected().length];
        }
        return this.probVolWin;
    }
}

