/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.xor;

import org.joone.engine.FullSynapse;
import org.joone.engine.LinearLayer;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.SigmoidLayer;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.io.MemoryInputSynapse;
import org.joone.net.NeuralNet;

public class XORMemory
implements NeuralNetListener {
    private double[][] inputArray = new double[][]{{0.0, 0.0, 0.0}, {0.0, 1.0, 1.0}, {1.0, 0.0, 1.0}, {1.0, 1.0, 0.0}};
    private long mills;

    public static void main(String[] args) {
        XORMemory xor = new XORMemory();
        if (args.length == 0) {
            xor.Go(10000);
        } else {
            xor.Go(new Integer(args[0]));
        }
    }

    public void Go(int epochs) {
        LinearLayer input = new LinearLayer();
        SigmoidLayer hidden = new SigmoidLayer();
        SigmoidLayer output = new SigmoidLayer();
        input.setLayerName("input");
        hidden.setLayerName("hidden");
        output.setLayerName("output");
        input.setRows(2);
        hidden.setRows(3);
        output.setRows(1);
        FullSynapse synapse_IH = new FullSynapse();
        FullSynapse synapse_HO = new FullSynapse();
        synapse_IH.setName("IH");
        synapse_HO.setName("HO");
        input.addOutputSynapse(synapse_IH);
        hidden.addInputSynapse(synapse_IH);
        hidden.addOutputSynapse(synapse_HO);
        output.addInputSynapse(synapse_HO);
        MemoryInputSynapse inputStream = new MemoryInputSynapse();
        inputStream.setInputArray(this.inputArray);
        inputStream.setAdvancedColumnSelector("1,2");
        input.addInputSynapse(inputStream);
        TeachingSynapse trainer = new TeachingSynapse();
        MemoryInputSynapse samples = new MemoryInputSynapse();
        samples.setInputArray(this.inputArray);
        samples.setAdvancedColumnSelector("3");
        trainer.setDesired(samples);
        output.addOutputSynapse(trainer);
        NeuralNet nnet = new NeuralNet();
        nnet.addLayer(input, 0);
        nnet.addLayer(hidden, 1);
        nnet.addLayer(output, 2);
        Monitor monitor = nnet.getMonitor();
        monitor.setTrainingPatterns(4);
        monitor.setTotCicles(epochs);
        monitor.setLearningRate(0.8);
        monitor.setMomentum(0.5);
        monitor.setLearning(true);
        monitor.setSingleThreadMode(true);
        monitor.addNeuralNetListener(this);
        this.mills = System.currentTimeMillis();
        nnet.go();
    }

    public void netStopped(NeuralNetEvent e) {
        long delay = System.currentTimeMillis() - this.mills;
        System.out.println("Training finished after " + delay + " ms");
        System.exit(0);
    }

    public void cicleTerminated(NeuralNetEvent e) {
    }

    public void netStarted(NeuralNetEvent e) {
        System.out.println("Training...");
    }

    public void errorChanged(NeuralNetEvent e) {
        Monitor mon = (Monitor)e.getSource();
        long c = mon.getCurrentCicle();
        long cl = c / 1000L;
        if (cl * 1000L == c) {
            System.out.println(c + " cycles remaining - Error = " + mon.getGlobalError());
        }
    }

    public void netStoppedError(NeuralNetEvent e, String error) {
    }
}

