/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.xor;

import java.io.FileInputStream;
import java.io.ObjectInputStream;
import org.joone.engine.Layer;
import org.joone.io.MemoryInputSynapse;
import org.joone.io.MemoryOutputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NeuralNet;
import org.joone.util.UnNormalizerOutputPlugIn;

public class EmbeddedXOR {
    private static final ILogger log = LoggerFactory.getLogger(EmbeddedXOR.class);
    private double[][] inputArray = new double[][]{{0.0, 0.0}, {0.0, 1.0}, {1.0, 0.0}, {1.0, 1.0}};
    private MemoryOutputSynapse memOut;
    private static String xorNet = "org/joone/samples/engine/xor/xor.snet";

    public static void main(String[] args) {
        EmbeddedXOR xor = new EmbeddedXOR();
        xor.Go(xorNet);
    }

    private void Go(String fileName) {
        NeuralNet xor = this.restoreNeuralNet(fileName);
        if (xor != null) {
            Layer input = xor.getInputLayer();
            input.removeAllInputs();
            MemoryInputSynapse memInp = new MemoryInputSynapse();
            memInp.setFirstRow(1);
            memInp.setAdvancedColumnSelector("1,2");
            input.addInputSynapse(memInp);
            memInp.setInputArray(this.inputArray);
            Layer output = xor.getOutputLayer();
            output.removeAllOutputs();
            this.memOut = new MemoryOutputSynapse();
            UnNormalizerOutputPlugIn outPlugin = new UnNormalizerOutputPlugIn();
            outPlugin.setAdvancedSerieSelector("1");
            outPlugin.setOutDataMin(1.0);
            outPlugin.setOutDataMax(2.0);
            this.memOut.addPlugIn(outPlugin);
            output.addOutputSynapse(this.memOut);
            xor.getMonitor().setTotCicles(1);
            xor.getMonitor().setTrainingPatterns(4);
            xor.getMonitor().setLearning(false);
            this.interrogate(xor, 10);
            log.info("Finished");
        }
    }

    private void interrogate(NeuralNet net, int times) {
        int cc = net.getMonitor().getTrainingPatterns();
        for (int t = 0; t < times; ++t) {
            log.info("Launch #" + (t + 1));
            net.go();
            for (int i = 0; i < cc; ++i) {
                double[] pattern = this.memOut.getNextPattern();
                log.info("    Output Pattern #" + (i + 1) + " = " + pattern[0]);
            }
            net.stop();
        }
    }

    private NeuralNet restoreNeuralNet(String fileName) {
        NeuralNet nnet = null;
        try {
            FileInputStream stream = new FileInputStream(fileName);
            ObjectInputStream input = new ObjectInputStream(stream);
            nnet = (NeuralNet)input.readObject();
        }
        catch (Exception e) {
            log.warn("Exception was thrown. Message is : " + e.getMessage(), e);
        }
        return nnet;
    }
}

