/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.net.NeuralNet;
import org.joone.net.NeuralNetValidator;
import org.joone.net.NeuralValidationEvent;
import org.joone.net.NeuralValidationListener;

public class TestXML
implements NeuralNetListener,
NeuralValidationListener {
    NeuralNet result;

    public static void main(String[] args) {
        new TestXML().elaborate();
    }

    private void elaborate() {
        try {
            XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
            this.result = (NeuralNet)xstream.fromXML((Reader)new FileReader("/home/paolo/SourceForge/xor.xml"));
            System.out.println("Unmarshaling Done");
            this.result.getMonitor().addNeuralNetListener(this);
            this.result.getMonitor().setTotCicles(3000);
            this.result.randomize(0.2);
            this.result.start();
            this.result.getMonitor().Go();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
    }

    public void cicleTerminated(NeuralNetEvent e) {
    }

    public void errorChanged(NeuralNetEvent e) {
        Monitor mon = (Monitor)e.getSource();
        if (mon.getCurrentCicle() % 200 == 0) {
            System.out.println("RMSE at epoch " + (mon.getTotCicles() - mon.getCurrentCicle()) + ": " + mon.getGlobalError());
            if (mon.getValidationPatterns() > 0) {
                NeuralNet newNet = this.result.cloneNet();
                newNet.removeAllListeners();
                NeuralNetValidator val = new NeuralNetValidator(newNet);
                val.addValidationListener(this);
                val.start();
            }
        }
    }

    public void netStarted(NeuralNetEvent e) {
        System.out.println("Running...");
    }

    public void netStopped(NeuralNetEvent e) {
        System.out.println("Finished");
    }

    public void netStoppedError(NeuralNetEvent e, String error) {
    }

    public void netValidated(NeuralValidationEvent e) {
        NeuralNet NN = (NeuralNet)e.getSource();
        System.out.println("\tValidation error=" + NN.getMonitor().getGlobalError());
    }
}

