/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.timeseries;

import java.io.File;
import org.joone.engine.DelayLayer;
import org.joone.engine.FullSynapse;
import org.joone.engine.Layer;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.SigmoidLayer;
import org.joone.engine.Synapse;
import org.joone.engine.TanhLayer;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.io.FileInputSynapse;
import org.joone.io.FileOutputSynapse;
import org.joone.net.NeuralNet;

public class TimeSeriesForecasting
implements NeuralNetListener {
    static String path = "org/joone/samples/engine/timeseries/";
    static String fileName = path + "timeseries.txt";
    int trainingPatterns = 300;
    int epochs = 1000;
    int temporalWindow = 10;
    DelayLayer input;
    SigmoidLayer hidden;
    TanhLayer output;
    TeachingSynapse trainer;
    NeuralNet nnet;

    public static void main(String[] args) {
        TimeSeriesForecasting me = new TimeSeriesForecasting();
        me.createNet();
        System.out.println("Training...");
        me.train();
        me.interrogate(path + "results1.txt");
        me.interrogate(path + "results2.txt");
        System.out.println("Done.");
    }

    private void createNet() {
        this.input = new DelayLayer();
        this.hidden = new SigmoidLayer();
        this.output = new TanhLayer();
        this.input.setTaps(this.temporalWindow - 1);
        this.input.setRows(1);
        this.hidden.setRows(15);
        this.output.setRows(1);
        this.connect(this.input, new FullSynapse(), this.hidden);
        this.connect(this.hidden, new FullSynapse(), this.output);
        this.input.addInputSynapse(this.createDataSet(fileName, 1, this.trainingPatterns, "1"));
        this.trainer = new TeachingSynapse();
        this.trainer.setDesired(this.createDataSet(fileName, 2, this.trainingPatterns + 1, "1"));
        this.output.addOutputSynapse(this.trainer);
        this.nnet = new NeuralNet();
        this.nnet.addLayer(this.input, 0);
        this.nnet.addLayer(this.hidden, 1);
        this.nnet.addLayer(this.output, 2);
    }

    private void train() {
        Monitor mon = this.nnet.getMonitor();
        mon.setLearningRate(0.2);
        mon.setMomentum(0.7);
        mon.setTrainingPatterns(this.trainingPatterns);
        mon.setTotCicles(this.epochs);
        mon.setPreLearning(this.temporalWindow);
        mon.setLearning(true);
        mon.addNeuralNetListener(this);
        this.nnet.start();
        mon.Go();
        this.nnet.join();
    }

    private void interrogate(String outputFile) {
        Monitor mon = this.nnet.getMonitor();
        this.input.removeAllInputs();
        int startRow = this.trainingPatterns - this.temporalWindow;
        this.input.addInputSynapse(this.createDataSet(fileName, startRow + 1, startRow + 20, "1"));
        this.output.removeAllOutputs();
        FileOutputSynapse fOutput = new FileOutputSynapse();
        fOutput.setFileName(outputFile);
        this.output.addOutputSynapse(fOutput);
        mon.setTrainingPatterns(20);
        mon.setTotCicles(1);
        mon.setLearning(false);
        this.nnet.start();
        mon.Go();
        this.nnet.join();
    }

    private void connect(Layer layer1, Synapse syn, Layer layer2) {
        layer1.addOutputSynapse(syn);
        layer2.addInputSynapse(syn);
    }

    private FileInputSynapse createDataSet(String fileName, int firstRow, int lastRow, String advColSel) {
        FileInputSynapse fInput = new FileInputSynapse();
        fInput.setInputFile(new File(fileName));
        fInput.setFirstRow(firstRow);
        fInput.setLastRow(lastRow);
        fInput.setAdvancedColumnSelector(advColSel);
        return fInput;
    }

    public void cicleTerminated(NeuralNetEvent e) {
        Monitor mon = (Monitor)e.getSource();
        int epoch = mon.getTotCicles() - mon.getCurrentCicle();
        if (epoch > 0 && epoch % 100 == 0) {
            System.out.println("Epoch:" + epoch + " RMSE=" + mon.getGlobalError());
        }
    }

    public void errorChanged(NeuralNetEvent e) {
    }

    public void netStarted(NeuralNetEvent e) {
    }

    public void netStopped(NeuralNetEvent e) {
        Monitor mon = (Monitor)e.getSource();
        if (mon.isLearning()) {
            int epoch = mon.getTotCicles() - mon.getCurrentCicle();
            System.out.println("Epoch:" + epoch + " last RMSE=" + mon.getGlobalError());
        }
    }

    public void netStoppedError(NeuralNetEvent e, String error) {
    }
}

