/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.multipleInputs;

import java.io.File;
import org.joone.engine.FullSynapse;
import org.joone.engine.LinearLayer;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.SigmoidLayer;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.io.FileInputSynapse;
import org.joone.io.FileOutputSynapse;
import org.joone.io.InputSwitchSynapse;
import org.joone.io.MultipleInputSynapse;
import org.joone.net.NeuralNet;

public class XOR_multipleInputs
implements NeuralNetListener {
    private NeuralNet nnet = null;
    private FileInputSynapse inputSynapse1;
    private FileInputSynapse inputSynapse2;
    private FileInputSynapse inputSynapse3;
    private FileInputSynapse desiredSynapse1;
    private FileInputSynapse desiredSynapse2;
    private FileInputSynapse desiredSynapse3;
    private InputSwitchSynapse inputSw;
    private InputSwitchSynapse desiredSw;
    private static String inputFileName = "org/joone/samples/engine/multipleInputs/xor.txt";

    public static void main(String[] args) {
        XOR_multipleInputs xor = new XOR_multipleInputs();
        xor.initNeuralNet();
        xor.train();
        xor.interrogate();
    }

    public void train() {
        Monitor monitor = this.nnet.getMonitor();
        monitor.setLearningRate(0.8);
        monitor.setMomentum(0.3);
        monitor.setTrainingPatterns(9);
        monitor.setTotCicles(2000);
        monitor.setLearning(true);
        this.nnet.addNeuralNetListener(this);
        this.nnet.go(true);
        System.out.println("Network stopped. Last RMSE=" + this.nnet.getMonitor().getGlobalError());
    }

    private void interrogate() {
        Monitor monitor = this.nnet.getMonitor();
        monitor.setTotCicles(1);
        monitor.setLearning(false);
        FileOutputSynapse output = new FileOutputSynapse();
        output.setFileName("/tmp/xorOut.txt");
        if (this.nnet != null) {
            this.nnet.addOutputSynapse(output);
            System.out.println(this.nnet.check());
            this.nnet.go(true);
        }
    }

    protected void initNeuralNet() {
        LinearLayer input = new LinearLayer();
        SigmoidLayer hidden = new SigmoidLayer();
        SigmoidLayer output = new SigmoidLayer();
        input.setRows(2);
        hidden.setRows(3);
        output.setRows(1);
        input.setLayerName("inputLayer");
        hidden.setLayerName("hiddenLayer");
        output.setLayerName("outputLayer");
        FullSynapse synapse_IH = new FullSynapse();
        FullSynapse synapse_HO = new FullSynapse();
        input.addOutputSynapse(synapse_IH);
        hidden.addInputSynapse(synapse_IH);
        hidden.addOutputSynapse(synapse_HO);
        output.addInputSynapse(synapse_HO);
        this.inputSynapse1 = new FileInputSynapse();
        this.inputSynapse2 = new FileInputSynapse();
        this.inputSynapse3 = new FileInputSynapse();
        this.inputSynapse1.setInputFile(new File(inputFileName));
        this.inputSynapse1.setName("input1");
        this.inputSynapse1.setAdvancedColumnSelector("1-2");
        this.inputSynapse1.setFirstRow(1);
        this.inputSynapse1.setLastRow(4);
        this.inputSynapse2.setInputFile(new File(inputFileName));
        this.inputSynapse2.setName("input2");
        this.inputSynapse2.setAdvancedColumnSelector("1-2");
        this.inputSynapse2.setFirstRow(2);
        this.inputSynapse2.setLastRow(4);
        this.inputSynapse3.setInputFile(new File(inputFileName));
        this.inputSynapse3.setName("input3");
        this.inputSynapse3.setAdvancedColumnSelector("1-2");
        this.inputSynapse3.setFirstRow(3);
        this.inputSynapse3.setLastRow(4);
        this.inputSw = new MultipleInputSynapse();
        this.inputSw.addInputSynapse(this.inputSynapse1);
        this.inputSw.addInputSynapse(this.inputSynapse2);
        this.inputSw.addInputSynapse(this.inputSynapse3);
        input.addInputSynapse(this.inputSw);
        this.desiredSynapse1 = new FileInputSynapse();
        this.desiredSynapse2 = new FileInputSynapse();
        this.desiredSynapse3 = new FileInputSynapse();
        this.desiredSynapse1.setInputFile(new File(inputFileName));
        this.desiredSynapse1.setName("desired1");
        this.desiredSynapse1.setAdvancedColumnSelector("3");
        this.desiredSynapse1.setFirstRow(1);
        this.desiredSynapse1.setLastRow(4);
        this.desiredSynapse2.setInputFile(new File(inputFileName));
        this.desiredSynapse2.setName("desired2");
        this.desiredSynapse2.setAdvancedColumnSelector("3");
        this.desiredSynapse2.setFirstRow(2);
        this.desiredSynapse2.setLastRow(4);
        this.desiredSynapse3.setInputFile(new File(inputFileName));
        this.desiredSynapse3.setName("desired3");
        this.desiredSynapse3.setAdvancedColumnSelector("3");
        this.desiredSynapse3.setFirstRow(3);
        this.desiredSynapse3.setLastRow(4);
        this.desiredSw = new MultipleInputSynapse();
        this.desiredSw.addInputSynapse(this.desiredSynapse1);
        this.desiredSw.addInputSynapse(this.desiredSynapse2);
        this.desiredSw.addInputSynapse(this.desiredSynapse3);
        TeachingSynapse trainer = new TeachingSynapse();
        trainer.setDesired(this.desiredSw);
        this.nnet = new NeuralNet();
        this.nnet.addLayer(input, 0);
        this.nnet.addLayer(hidden, 1);
        this.nnet.addLayer(output, 2);
        this.nnet.setTeacher(trainer);
        output.addOutputSynapse(trainer);
    }

    public void cicleTerminated(NeuralNetEvent e) {
    }

    public void errorChanged(NeuralNetEvent e) {
        Monitor mon = (Monitor)e.getSource();
        if (mon.getCurrentCicle() % 100 == 0) {
            System.out.println("Epoch: " + (mon.getTotCicles() - mon.getCurrentCicle()) + " RMSE:" + mon.getGlobalError());
        }
    }

    public void netStarted(NeuralNetEvent e) {
        Monitor mon = (Monitor)e.getSource();
        if (mon.isLearning()) {
            System.out.println("Training...");
        }
    }

    public void netStopped(NeuralNetEvent e) {
        System.out.println("Stopped");
    }

    public void netStoppedError(NeuralNetEvent e, String error) {
    }
}

