/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.helpers;

import java.io.File;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.helpers.factory.JooneTools;
import org.joone.io.FileInputSynapse;
import org.joone.net.NeuralNet;
import org.joone.net.NeuralNetAttributes;
import org.joone.util.NormalizerPlugIn;

public class Validation_using_stream
implements NeuralNetListener {
    private static final String fileName = "org/joone/samples/engine/helpers/wine.txt";
    private static final int trainingRows = 150;
    private double[][] inputTrain;
    private double[][] desiredTrain;
    private double[][] inputTest;
    private double[][] desiredTest;

    public static void main(String[] args) {
        Validation_using_stream me = new Validation_using_stream();
        me.go();
    }

    private void go() {
        FileInputSynapse fileIn = new FileInputSynapse();
        fileIn.setInputFile(new File(fileName));
        fileIn.setAdvancedColumnSelector("1-14");
        NormalizerPlugIn normIn = new NormalizerPlugIn();
        normIn.setAdvancedSerieSelector("2-14");
        normIn.setMin(-1.0);
        normIn.setMax(1.0);
        fileIn.addPlugIn(normIn);
        NormalizerPlugIn normOut = new NormalizerPlugIn();
        normOut.setAdvancedSerieSelector("1");
        fileIn.addPlugIn(normOut);
        this.inputTrain = JooneTools.getDataFromStream(fileIn, 1, 150, 2, 14);
        this.desiredTrain = JooneTools.getDataFromStream(fileIn, 1, 150, 1, 1);
        this.inputTest = JooneTools.getDataFromStream(fileIn, 151, 178, 2, 14);
        this.desiredTest = JooneTools.getDataFromStream(fileIn, 151, 178, 1, 1);
        int[] nodes = new int[]{13, 4, 1};
        NeuralNet nnet = JooneTools.create_standard(nodes, 2);
        nnet.getMonitor().setLearningRate(0.3);
        nnet.getMonitor().setMomentum(0.5);
        JooneTools.train(nnet, this.inputTrain, this.desiredTrain, 5000, 0.01, 100, this, false);
        NeuralNetAttributes attrib = nnet.getDescriptor();
        System.out.println("Last training rmse=" + attrib.getTrainingError() + " at epoch " + attrib.getLastEpoch());
        double[][] out = JooneTools.compare(nnet, this.inputTest, this.desiredTest);
        System.out.println("Comparion of the last " + out.length + " rows:");
        int cols = out[0].length / 2;
        for (int i = 0; i < out.length; ++i) {
            int x;
            System.out.print("\nOutput: ");
            for (x = 0; x < cols; ++x) {
                System.out.print(out[i][x] + " ");
            }
            System.out.print("\tTarget: ");
            for (x = cols; x < cols * 2; ++x) {
                System.out.print(out[i][x] + " ");
            }
        }
    }

    public void cicleTerminated(NeuralNetEvent e) {
        Monitor mon = (Monitor)e.getSource();
        int epoch = mon.getTotCicles() - mon.getCurrentCicle() + 1;
        double trainErr = mon.getGlobalError();
        NeuralNet n = e.getNeuralNet().cloneNet();
        double testErr = JooneTools.test(n, this.inputTest, this.desiredTest);
        System.out.println("Epoch " + epoch + ":\n\tTraining error=" + trainErr + "\n\tValidation error=" + testErr);
    }

    public void errorChanged(NeuralNetEvent e) {
    }

    public void netStarted(NeuralNetEvent e) {
        System.out.println("Training...");
    }

    public void netStopped(NeuralNetEvent e) {
        System.out.println("Training stopped.");
    }

    public void netStoppedError(NeuralNetEvent e, String error) {
        System.out.println("Training stopped with error " + error);
    }
}

