/*
 * Decompiled with CFR 0.152.
 */
package org.joone.net;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.Vector;
import org.joone.engine.InputPatternListener;
import org.joone.engine.Layer;
import org.joone.engine.Matrix;
import org.joone.engine.Monitor;
import org.joone.engine.NetStoppedEventNotifier;
import org.joone.engine.NeuralLayer;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.OutputPatternListener;
import org.joone.engine.Pattern;
import org.joone.engine.Synapse;
import org.joone.engine.learning.AbstractTeacherSynapse;
import org.joone.engine.learning.ComparingElement;
import org.joone.exception.JooneRuntimeException;
import org.joone.helpers.structure.ConnectionHelper;
import org.joone.helpers.structure.NeuralNetMatrix;
import org.joone.io.StreamInputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;
import org.joone.net.NeuralNetAttributes;
import org.joone.script.MacroInterface;

public class NeuralNet
implements NeuralLayer,
NeuralNetListener,
Serializable {
    private static final int MAJOR_RELEASE = 2;
    private static final int MINOR_RELEASE = 0;
    private static final int BUILD = 0;
    private static final String SUFFIX = "RC1";
    private static final ILogger log = LoggerFactory.getLogger(NeuralNet.class);
    private Vector layers = new Vector();
    private String NetName;
    private Monitor mon = new Monitor();
    private Layer inputLayer;
    private Layer outputLayer;
    private ComparingElement teacher;
    private static final long serialVersionUID = 8351124226081783962L;
    public static final int INPUT_LAYER = 0;
    public static final int HIDDEN_LAYER = 1;
    public static final int OUTPUT_LAYER = 2;
    protected Vector listeners;
    private MacroInterface macroPlugin;
    private boolean scriptingEnabled = false;
    private NeuralNetAttributes descriptor = null;
    private Hashtable params;
    private Layer[] orderedLayers = null;
    private transient Layer[] intOrderedLayers = null;
    private transient Thread singleThread = null;
    private boolean stopFastRun;

    public void start() {
        this.terminate(false);
        if (this.readyToStart()) {
            this.getMonitor().addNeuralNetListener(this, false);
            Layer ly = null;
            try {
                for (int i = 0; i < this.layers.size(); ++i) {
                    ly = (Layer)this.layers.elementAt(i);
                    ly.start();
                }
            }
            catch (RuntimeException rte) {
                this.stop();
                String msg = "RuntimeException was thrown while starting the neural network. Message is:" + rte.getMessage();
                log.error(msg, rte);
                throw new JooneRuntimeException(msg, rte);
            }
        } else {
            String msg = "NeuralNet: The neural net is already running";
            log.warn("NeuralNet: The neural net is already running");
            throw new JooneRuntimeException(msg);
        }
    }

    private boolean readyToStart() {
        for (int i = 0; i < 100; ++i) {
            if (!this.isRunning()) {
                return true;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        return false;
    }

    public void join() {
        if (this.getMonitor().isSingleThreadMode()) {
            if (this.getSingleThread() != null) {
                try {
                    this.getSingleThread().join();
                }
                catch (InterruptedException doNothing) {}
            }
        } else {
            for (int i = 0; i < this.layers.size(); ++i) {
                Layer ly = (Layer)this.layers.elementAt(i);
                ly.join();
            }
            if (this.teacher != null) {
                this.teacher.getTheLinearLayer().join();
            }
        }
    }

    public void stop() {
        if (this.getMonitor().isSingleThreadMode()) {
            this.stopFastRun();
        } else {
            this.getMonitor().Stop();
        }
    }

    public void terminate(boolean notify) {
        if (this.isRunning()) {
            Layer ly = null;
            for (int i = 0; i < this.layers.size(); ++i) {
                ly = (Layer)this.layers.elementAt(i);
                ly.stop();
            }
            if (this.teacher != null) {
                this.teacher.getTheLinearLayer().stop();
                if (this.teacher instanceof AbstractTeacherSynapse) {
                    ((AbstractTeacherSynapse)((Object)this.teacher)).netStoppedError();
                }
            }
            if (this.getMonitor() != null && notify) {
                new NetStoppedEventNotifier(this.getMonitor()).start();
            }
        }
    }

    public void terminate() {
        this.terminate(true);
    }

    protected int getNumOfstepCounters() {
        int count = 0;
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer ly = (Layer)this.layers.elementAt(i);
            if (!ly.hasStepCounter()) continue;
            ++count;
        }
        if (this.teacher != null && this.teacher.getDesired() != null && this.teacher.getDesired().isStepCounter()) {
            ++count;
        }
        return count;
    }

    public Layer getInputLayer() {
        if (this.inputLayer != null) {
            return this.inputLayer;
        }
        this.setInputLayer(this.findInputLayer());
        return this.inputLayer;
    }

    public Layer findInputLayer() {
        Layer input = null;
        if (this.layers == null) {
            return null;
        }
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer ly = (Layer)this.layers.elementAt(i);
            if (!ly.isInputLayer()) continue;
            input = ly;
            break;
        }
        return input;
    }

    public Layer getOutputLayer() {
        if (this.outputLayer != null) {
            return this.outputLayer;
        }
        this.setOutputLayer(this.findOutputLayer());
        return this.outputLayer;
    }

    public Layer findOutputLayer() {
        Layer output = null;
        if (this.layers == null) {
            return null;
        }
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer ly = (Layer)this.layers.elementAt(i);
            if (!ly.isOutputLayer()) continue;
            output = ly;
            break;
        }
        return output;
    }

    public int getRows() {
        Layer ly = this.getInputLayer();
        if (ly != null) {
            return ly.getRows();
        }
        return 0;
    }

    public void setRows(int p1) {
        Layer ly = this.getInputLayer();
        if (ly != null) {
            ly.setRows(p1);
        }
    }

    public void addNoise(double p1) {
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer ly = (Layer)this.layers.elementAt(i);
            ly.addNoise(p1);
        }
    }

    public void randomize(double amplitude) {
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer ly = (Layer)this.layers.elementAt(i);
            ly.randomize(amplitude);
        }
    }

    public Matrix getBias() {
        Layer ly = this.getInputLayer();
        if (ly != null) {
            return ly.getBias();
        }
        return null;
    }

    public Vector getAllOutputs() {
        Layer ly = this.getOutputLayer();
        if (ly != null) {
            return ly.getAllOutputs();
        }
        return null;
    }

    public String getLayerName() {
        return this.NetName;
    }

    public void removeOutputSynapse(OutputPatternListener p1) {
        Layer ly = this.getOutputLayer();
        if (ly != null) {
            ly.removeOutputSynapse(p1);
        }
    }

    public void setAllInputs(Vector p1) {
        Layer ly = this.getInputLayer();
        if (ly != null) {
            ly.setAllInputs(p1);
        }
    }

    public void removeAllOutputs() {
        Layer ly = this.getOutputLayer();
        if (ly != null) {
            ly.removeAllOutputs();
        }
        this.setTeacher(null);
    }

    public Vector getAllInputs() {
        Layer ly = this.getInputLayer();
        if (ly != null) {
            return ly.getAllInputs();
        }
        return null;
    }

    public boolean addOutputSynapse(OutputPatternListener p1) {
        Layer ly = this.getOutputLayer();
        if (ly != null) {
            return ly.addOutputSynapse(p1);
        }
        return false;
    }

    public void setBias(Matrix p1) {
        Layer ly = this.getInputLayer();
        if (ly != null) {
            ly.setBias(p1);
        }
    }

    public void removeInputSynapse(InputPatternListener p1) {
        Layer ly = this.getInputLayer();
        if (ly != null) {
            ly.removeInputSynapse(p1);
        }
    }

    public void setLayerName(String p1) {
        this.NetName = p1;
    }

    public boolean addInputSynapse(InputPatternListener p1) {
        Layer ly = this.getInputLayer();
        if (ly != null) {
            return ly.addInputSynapse(p1);
        }
        return false;
    }

    public void setAllOutputs(Vector p1) {
        Layer ly = this.getOutputLayer();
        if (ly != null) {
            ly.setAllOutputs(p1);
        }
    }

    public void setMonitor(Monitor p1) {
        this.mon = p1;
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer ly = (Layer)this.layers.elementAt(i);
            ly.setMonitor(this.mon);
        }
        this.setScriptingEnabled(this.isScriptingEnabled());
        if (this.getTeacher() != null) {
            this.getTeacher().setMonitor(p1);
        }
    }

    public Monitor getMonitor() {
        return this.mon;
    }

    public void removeAllInputs() {
        Layer ly = this.getInputLayer();
        if (ly != null) {
            ly.removeAllInputs();
        }
    }

    public NeuralLayer copyInto(NeuralLayer p1) {
        return null;
    }

    public void addLayer(Layer layer) {
        this.addLayer(layer, 1);
    }

    public void addLayer(Layer layer, int tier) {
        if (!this.layers.contains(layer)) {
            layer.setMonitor(this.mon);
            this.layers.addElement(layer);
        }
        if (tier == 0) {
            this.setInputLayer(layer);
        }
        if (tier == 2) {
            this.setOutputLayer(layer);
        }
    }

    public void removeLayer(Layer layer) {
        if (this.layers.contains(layer)) {
            this.layers.removeElement(layer);
            NeuralNetMatrix matrix = new NeuralNetMatrix(this);
            Synapse[][] conn = matrix.getConnectionMatrix();
            this.removeSynapses(matrix.getLayerInd(layer), conn);
            if (layer == this.inputLayer) {
                this.setInputLayer(null);
            } else if (layer == this.outputLayer) {
                this.setOutputLayer(null);
            }
        }
    }

    private void removeSynapses(int ind, Synapse[][] conn) {
        if (ind >= 0) {
            int i;
            for (i = 0; i < conn.length; ++i) {
                if (conn[i][ind] == null) continue;
                ConnectionHelper.disconnect(this.layers.get(i), this.layers.get(ind));
            }
            for (i = 0; i < conn[0].length; ++i) {
                if (conn[ind][i] == null) continue;
                ConnectionHelper.disconnect(this.layers.get(ind), this.layers.get(i));
            }
        }
    }

    public void resetInput() {
        Layer ly = null;
        for (int i = 0; i < this.layers.size(); ++i) {
            ly = (Layer)this.layers.elementAt(i);
            Vector inputs = ly.getAllInputs();
            if (inputs == null) continue;
            for (int x = 0; x < inputs.size(); ++x) {
                InputPatternListener syn = (InputPatternListener)inputs.elementAt(x);
                if (!(syn instanceof StreamInputSynapse)) continue;
                ((StreamInputSynapse)syn).resetInput();
            }
        }
        if (this.getTeacher() != null) {
            this.getTeacher().resetInput();
        }
    }

    public void addNeuralNetListener(NeuralNetListener listener) {
        if (this.getListeners().contains(listener)) {
            return;
        }
        this.listeners.addElement(listener);
        if (this.getMonitor() != null) {
            this.getMonitor().addNeuralNetListener(listener);
        }
    }

    public Vector getListeners() {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        return this.listeners;
    }

    public void removeNeuralNetListener(NeuralNetListener listener) {
        this.getListeners().removeElement(listener);
        if (this.getMonitor() != null) {
            this.getMonitor().removeNeuralNetListener(listener);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Vector lst = this.getListeners();
        if (this.getMonitor() != null) {
            for (int i = 0; i < lst.size(); ++i) {
                this.getMonitor().addNeuralNetListener((NeuralNetListener)lst.elementAt(i));
            }
        }
        this.setMacroPlugin(this.macroPlugin);
    }

    public static String getVersion() {
        return "2.0.0RC1";
    }

    public static Integer getNumericVersion() {
        return new Integer(2000000);
    }

    public Layer getLayer(String layerName) {
        Layer ly = null;
        for (int i = 0; i < this.layers.size(); ++i) {
            ly = (Layer)this.layers.elementAt(i);
            if (ly.getLayerName().compareToIgnoreCase(layerName) != 0) continue;
            return ly;
        }
        return null;
    }

    public Vector getLayers() {
        return this.layers;
    }

    public void setLayers(Vector newlayers) {
        this.layers = newlayers;
    }

    public void setLayersList(ArrayList list) {
        this.setLayers(new Vector(list));
    }

    public void setTeacher(ComparingElement ts) {
        if (this.getMonitor() != null) {
            if (ts != null) {
                this.getMonitor().setSupervised(true);
            } else {
                this.getMonitor().setSupervised(false);
            }
        }
        this.teacher = ts;
    }

    public ComparingElement getTeacher() {
        return this.teacher;
    }

    public void setListeners(Vector listeners) {
    }

    public void setInputLayer(Layer newLayer) {
        this.inputLayer = newLayer;
    }

    public void setOutputLayer(Layer newLayer) {
        this.outputLayer = newLayer;
    }

    public NeuralNetAttributes getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new NeuralNetAttributes();
            this.descriptor.setNeuralNetName(this.getLayerName());
        }
        return this.descriptor;
    }

    public void setDescriptor(NeuralNetAttributes newdescriptor) {
        this.descriptor = newdescriptor;
    }

    public boolean isRunning() {
        if (this.getMonitor().isSingleThreadMode()) {
            if (this.getSingleThread() != null && this.getSingleThread().isAlive()) {
                return true;
            }
        } else {
            Layer ly = null;
            for (int i = 0; i < this.layers.size(); ++i) {
                ly = (Layer)this.layers.elementAt(i);
                if (!ly.isRunning()) continue;
                return true;
            }
            if (this.teacher != null && this.teacher.getTheLinearLayer().isRunning()) {
                return true;
            }
        }
        return false;
    }

    public NeuralNet cloneNet() {
        NeuralNet newnet = null;
        try {
            ByteArrayOutputStream f = new ByteArrayOutputStream();
            ObjectOutputStream s = new ObjectOutputStream(f);
            s.writeObject(this);
            s.flush();
            ByteArrayInputStream fi = new ByteArrayInputStream(f.toByteArray());
            ObjectInputStream oi = new ObjectInputStream(fi);
            newnet = (NeuralNet)oi.readObject();
        }
        catch (Exception ioe) {
            log.warn("IOException while cloning the Net. Message is : " + ioe.getMessage(), ioe);
        }
        return newnet;
    }

    public void removeAllListeners() {
        this.listeners = null;
        if (this.getMonitor() != null) {
            this.getMonitor().removeAllListeners();
        }
    }

    public void setScriptingEnabled(boolean enabled) {
        this.scriptingEnabled = enabled;
        if (enabled) {
            MacroInterface listener = this.getMacroPlugin();
            if (listener == null) {
                log.info("MacroPlugin not set: Impossible to enable the scripting");
            } else {
                this.addNeuralNetListener(this.getMacroPlugin());
            }
        } else if (this.macroPlugin != null) {
            this.removeNeuralNetListener(this.macroPlugin);
        }
    }

    public boolean isScriptingEnabled() {
        return this.scriptingEnabled;
    }

    public MacroInterface getMacroPlugin() {
        return this.macroPlugin;
    }

    public void setMacroPlugin(MacroInterface macroPlugin) {
        if (macroPlugin != null) {
            this.removeNeuralNetListener(this.macroPlugin);
            if (this.scriptingEnabled) {
                this.addNeuralNetListener(macroPlugin);
            }
        }
        this.macroPlugin = macroPlugin;
        if (macroPlugin != null) {
            macroPlugin.set("jNet", this);
            macroPlugin.set("jMon", this.getMonitor());
        }
    }

    public Object getParam(String key) {
        if (this.params == null) {
            return null;
        }
        return this.params.get(key);
    }

    public void setParam(String key, Object obj) {
        if (this.params == null) {
            this.params = new Hashtable();
        }
        if (this.params.containsKey(key)) {
            this.params.remove(key);
        }
        this.params.put(key, obj);
    }

    public String[] getKeys() {
        if (this.params == null) {
            return null;
        }
        String[] keys = new String[this.params.keySet().size()];
        Enumeration myEnum = this.params.keys();
        int i = 0;
        while (myEnum.hasMoreElements()) {
            keys[i] = (String)myEnum.nextElement();
            ++i;
        }
        return keys;
    }

    public TreeSet check() {
        TreeSet<NetCheck> checks = new TreeSet<NetCheck>();
        if (this.layers == null || this.layers.isEmpty()) {
            checks.add(new NetCheck(0, "The Neural Network doesn't contain any layer", this.mon));
            return checks;
        }
        if (this.getNumOfstepCounters() > 1) {
            checks.add(new NetCheck(0, "More than one InputSynapse having stepCounter set to true is present", this.mon));
        }
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer layer = (Layer)this.layers.elementAt(i);
            checks.addAll(layer.check());
        }
        if (this.mon.getParent() == null) {
            if (this.teacher != null) {
                checks.addAll(this.teacher.check());
                if (this.mon != null && this.mon.isLearning() && !this.mon.isSupervised()) {
                    checks.add(new NetCheck(1, "Teacher is present: the supervised property should be set to true", this.mon));
                }
            } else if (this.mon != null && this.mon.isLearning() && this.mon.isSupervised()) {
                checks.add(new NetCheck(0, "Teacher not present: set to false the supervised property", this.mon));
            }
        }
        if (this.mon != null) {
            checks.addAll(this.mon.check());
        }
        return checks;
    }

    public void netStarted(NeuralNetEvent e) {
    }

    public void cicleTerminated(NeuralNetEvent e) {
    }

    public void netStopped(NeuralNetEvent e) {
    }

    public void errorChanged(NeuralNetEvent e) {
    }

    public void netStoppedError(NeuralNetEvent e, String error) {
        this.terminate(false);
    }

    public void setOrderedLayers(Layer[] orderedLayers) {
        this.orderedLayers = orderedLayers;
    }

    public Layer[] getOrderedLayers() {
        return this.orderedLayers;
    }

    public Layer[] calculateOrderedLayers() {
        if (this.getOrderedLayers() == null) {
            if (this.intOrderedLayers == null) {
                NeuralNetMatrix matrix = new NeuralNetMatrix(this);
                this.intOrderedLayers = matrix.getOrderedLayers();
            }
        } else {
            this.intOrderedLayers = this.getOrderedLayers();
        }
        return this.intOrderedLayers;
    }

    public void go(boolean singleThreadMode, boolean sync) {
        this.getMonitor().setSingleThreadMode(singleThreadMode);
        this.go(sync);
    }

    public void go(boolean sync) {
        if (this.getMonitor().isSingleThreadMode()) {
            Runnable runner = new Runnable(){

                public void run() {
                    NeuralNet.this.fastRun();
                }
            };
            this.setSingleThread(new Thread(runner));
            this.getSingleThread().start();
        } else {
            this.start();
            this.getMonitor().Go();
        }
        if (sync) {
            this.join();
        }
    }

    public void go() {
        this.go(false);
    }

    public void restore() {
        if (this.getMonitor().isSingleThreadMode()) {
            Runnable runner = new Runnable(){

                public void run() {
                    NeuralNet.this.fastContinue();
                }
            };
            this.setSingleThread(new Thread(runner));
            this.getSingleThread().start();
        } else {
            this.start();
            this.getMonitor().runAgain();
        }
    }

    protected void fastRun() {
        this.fastRun(this.getMonitor().getTotCicles());
    }

    protected void fastContinue() {
        this.fastRun(this.getMonitor().getCurrentCicle());
    }

    protected void fastRun(int firstEpoch) {
        Monitor mon = this.getMonitor();
        mon.setSingleThreadMode(true);
        int epochs = firstEpoch;
        int patterns = mon.getNumOfPatterns();
        Layer[] ordLayers = this.calculateOrderedLayers();
        int layers = ordLayers.length;
        for (int ly = 0; ly < layers; ++ly) {
            ordLayers[ly].init();
        }
        this.stopFastRun = false;
        mon.fireNetStarted();
        for (int epoch = epochs; epoch > 0; --epoch) {
            mon.setCurrentCicle(epoch);
            for (int p = 0; p < patterns; ++p) {
                this.stepForward(null);
                if (!this.getMonitor().isLearningCicle(p + 1)) continue;
                this.stepBackward(null);
            }
            mon.fireCicleTerminated();
            if (this.stopFastRun) break;
        }
        Pattern stop = new Pattern(new double[ordLayers[0].getRows()]);
        stop.setCount(-1);
        this.stepForward(stop);
        mon.fireNetStopped();
    }

    protected void singleStepForward(Pattern pattern) {
        this.getMonitor().setSingleThreadMode(true);
        Layer[] ordLayers = this.calculateOrderedLayers();
        int layers = ordLayers.length;
        for (int ly = 0; ly < layers; ++ly) {
            ordLayers[ly].init();
        }
        this.stepForward(pattern);
    }

    protected void singleStepBackward(Pattern error) {
        this.getMonitor().setSingleThreadMode(true);
        this.stepBackward(error);
    }

    protected void stepForward(Pattern pattern) {
        Layer[] ordLayers = this.calculateOrderedLayers();
        int layers = ordLayers.length;
        ordLayers[0].fwdRun(pattern);
        for (int ly = 1; ly < layers; ++ly) {
            ordLayers[ly].fwdRun(null);
        }
    }

    protected void stepBackward(Pattern error) {
        int layers;
        Layer[] ordLayers = this.calculateOrderedLayers();
        for (int ly = layers = ordLayers.length; ly > 0; --ly) {
            ordLayers[ly - 1].revRun(error);
        }
    }

    protected void stopFastRun() {
        this.stopFastRun = true;
    }

    protected Thread getSingleThread() {
        return this.singleThread;
    }

    protected void setSingleThread(Thread singleThread) {
        this.singleThread = singleThread;
    }
}

