/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.joone.io.PatternTokenizer;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class XLSInputTokenizer
implements PatternTokenizer {
    private static final ILogger log = LoggerFactory.getLogger(XLSInputTokenizer.class);
    private int numTokens = 0;
    private char m_decimalPoint = (char)46;
    private double[] tokensArray;
    private int row_no = 0;
    private int mark_row = 0;
    private final HSSFSheet sheet;

    public XLSInputTokenizer(HSSFSheet i_sheet) throws IOException {
        this.sheet = i_sheet;
    }

    public int getLineno() {
        return this.row_no;
    }

    public int getNumTokens() throws IOException {
        return this.numTokens;
    }

    public double getTokenAt(int p0) throws IOException {
        if (this.tokensArray == null && !this.nextLine()) {
            return 0.0;
        }
        if (this.tokensArray.length <= p0) {
            return 0.0;
        }
        return this.tokensArray[p0];
    }

    public double[] getTokensArray() {
        return this.tokensArray;
    }

    public void mark() throws IOException {
        this.mark_row = this.row_no;
    }

    public boolean nextLine() throws IOException {
        int lastRowNum = this.sheet.getLastRowNum();
        if (this.row_no <= lastRowNum) {
            HSSFRow row = this.sheet.getRow(this.row_no);
            if (row == null) {
                this.numTokens = 0;
                this.tokensArray = new double[this.numTokens];
            } else {
                short maxCol = 0;
                Hashtable<Integer, Double> cellist = new Hashtable<Integer, Double>();
                Iterator iter = row.cellIterator();
                while (iter.hasNext()) {
                    double v = 0.0;
                    HSSFCell cell = (HSSFCell)iter.next();
                    short i = cell.getCellNum();
                    if (i > maxCol) {
                        maxCol = i;
                    }
                    switch (cell.getCellType()) {
                        case 1: {
                            String cellValue = cell.getStringCellValue();
                            try {
                                v = Double.valueOf(cellValue);
                            }
                            catch (NumberFormatException nfe) {
                                log.warn("Warning: Not numeric cell at (" + this.row_no + "," + i + "): <" + cellValue + "> - Skipping");
                                v = 0.0;
                            }
                            break;
                        }
                        case 0: {
                            v = cell.getNumericCellValue();
                        }
                    }
                    cellist.put(new Integer(i), new Double(v));
                }
                this.tokensArray = new double[maxCol + 1];
                Enumeration keys = cellist.keys();
                while (keys.hasMoreElements()) {
                    Integer Icol = (Integer)keys.nextElement();
                    Double Dval = (Double)cellist.get(Icol);
                    this.tokensArray[Icol.intValue()] = Dval;
                }
            }
            ++this.row_no;
            return true;
        }
        return false;
    }

    public void resetInput() throws IOException {
        this.row_no = this.mark_row;
    }

    public void setDecimalPoint(char dp) {
        this.m_decimalPoint = dp;
    }

    public char getDecimalPoint() {
        return this.m_decimalPoint;
    }
}

