/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.TreeSet;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.joone.engine.NetErrorManager;
import org.joone.exception.JooneRuntimeException;
import org.joone.io.StreamInputSynapse;
import org.joone.io.XLSInputTokenizer;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;

public class XLSInputSynapse
extends StreamInputSynapse {
    private static final ILogger log = LoggerFactory.getLogger(XLSInputSynapse.class);
    private String i_sheet_name = "";
    private transient HSSFSheet i_sheet;
    private int i_sheet_index = 0;
    private transient FileInputStream i_stream;
    private transient POIFSFileSystem i_fs;
    private transient HSSFWorkbook i_workbook;
    private boolean file_chk = false;
    private String fileName = "";
    private transient File inputFile;
    private static final long serialVersionUID = 8625369117101456178L;

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String newFileName) {
        if (!this.fileName.equals(newFileName)) {
            this.fileName = newFileName;
            this.file_chk = true;
            this.resetInput();
            this.setTokens(null);
        }
    }

    protected void initInputStream() throws JooneRuntimeException {
        if (new File(this.fileName).exists()) {
            this.i_sheet = this.getSheet(this.i_sheet_name);
            if (this.i_sheet != null) {
                try {
                    super.setTokens(new XLSInputTokenizer(this.i_sheet));
                }
                catch (IOException ioe) {
                    log.error("Error creating XLSInputTokenizer. Message is : " + ioe.getMessage());
                    if (this.getMonitor() != null) {
                        new NetErrorManager(this.getMonitor(), "Error creating XLSInputTokenizer. Message is : " + ioe.getMessage());
                    }
                }
            }
        } else {
            String err = "Excel XLS File '" + this.fileName + "' does not exist.";
            log.error(err);
            if (this.getMonitor() != null) {
                new NetErrorManager(this.getMonitor(), "Excel XLS File '" + this.fileName + "' does not exist.");
            }
        }
    }

    protected HSSFSheet getSheet(String sheetName) {
        HSSFSheet r_sheet = null;
        try {
            this.i_stream = new FileInputStream(this.fileName);
            this.i_fs = new POIFSFileSystem((InputStream)this.i_stream);
            this.i_workbook = new HSSFWorkbook(this.i_fs);
            this.i_stream.close();
            this.i_sheet_index = this.i_workbook.getSheetIndex(sheetName);
            r_sheet = this.i_sheet_index > -1 ? this.i_workbook.getSheetAt(this.i_sheet_index) : this.i_workbook.getSheetAt(0);
            return r_sheet;
        }
        catch (IOException io_err) {
            log.error("Could not open worksheet '" + sheetName + "' from XLS file. Message is : " + io_err.getMessage());
            if (this.getMonitor() != null) {
                new NetErrorManager(this.getMonitor(), "Could not open worksheet '" + sheetName + "' from XLS file. Message is : " + io_err.getMessage());
            }
            return null;
        }
    }

    public void setSheetName(String sheetName) {
        if (!this.i_sheet_name.equals(sheetName)) {
            this.i_sheet_name = sheetName;
            this.resetInput();
            this.setTokens(null);
        }
    }

    public String[] getAvailableSheetList() {
        int sheetCount = this.i_workbook.getNumberOfSheets();
        String[] availableSheetList = null;
        for (int i = 0; i > sheetCount; ++i) {
            availableSheetList[i] = this.i_workbook.getSheetName(i);
        }
        return availableSheetList;
    }

    public String getSheetName() {
        return this.i_sheet_name;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readObjectBase(in);
        if (in.getClass().getName().indexOf("xstream") == -1) {
            this.fileName = (String)in.readObject();
        }
        if (!this.isBuffered() || this.getInputVector().size() == 0) {
            this.setFileName(this.fileName);
        }
        if (this.fileName != null && this.fileName.length() > 0) {
            this.inputFile = new File(this.fileName);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        super.writeObjectBase(out);
        if (out.getClass().getName().indexOf("xstream") == -1) {
            out.writeObject(this.fileName);
        }
    }

    public TreeSet check() {
        TreeSet checks = super.check();
        if (this.fileName == null || this.fileName.trim().equals("")) {
            checks.add(new NetCheck(0, "File Name not set.", this));
        } else if (!this.getInputFile().exists()) {
            NetCheck error = new NetCheck(1, "Input File doesn't exist.", this);
            if (this.getInputPatterns().isEmpty()) {
                error.setSeverity(0);
            }
            checks.add(error);
        }
        return checks;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(File inputFile) {
        if (inputFile != null) {
            if (!this.fileName.equals(inputFile.getAbsolutePath())) {
                this.inputFile = inputFile;
                this.fileName = inputFile.getAbsolutePath();
                this.file_chk = true;
                this.resetInput();
                super.setTokens(null);
            }
        } else {
            this.inputFile = inputFile;
            this.fileName = "";
            this.file_chk = true;
            this.resetInput();
            super.setTokens(null);
        }
    }
}

