/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.imageio.ImageIO;
import org.joone.io.PatternTokenizer;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class ImageInputTokenizer
implements PatternTokenizer {
    private int RequiredWidth = 0;
    private int RequiredHeight = 0;
    private int TotalTokens = 0;
    private double[] ImageTokens = null;
    private Vector ImageFileList = new Vector();
    private Image[] ArrayOfInputImages = null;
    private int TotalInputImages = 0;
    private boolean FileMode = true;
    private boolean ColourMode = true;
    private int CurrentImageNo = 0;
    private int CurrentToken = 0;
    private int MarkedImage = 0;
    private int MarkedToken = 0;
    private static final ILogger log = LoggerFactory.getLogger(ImageInputTokenizer.class);

    public ImageInputTokenizer(int req_width, int req_height, Vector file_list, boolean colour) throws IOException {
        this.FileMode = true;
        this.RequiredWidth = req_width;
        this.RequiredHeight = req_height;
        this.ColourMode = colour;
        this.TotalTokens = this.ColourMode ? this.RequiredWidth * this.RequiredHeight * 3 : this.RequiredWidth * this.RequiredHeight;
        this.ImageFileList = file_list;
        this.TotalInputImages = this.ImageFileList != null ? this.ImageFileList.size() : -1;
        this.ImageTokens = new double[this.TotalTokens];
    }

    public ImageInputTokenizer(int req_width, int req_height, Image[] the_images, boolean colour) throws IOException {
        this.FileMode = false;
        this.RequiredWidth = req_width;
        this.RequiredHeight = req_height;
        this.ColourMode = colour;
        this.TotalTokens = this.ColourMode ? this.RequiredWidth * this.RequiredHeight * 3 : this.RequiredWidth * this.RequiredHeight;
        this.ArrayOfInputImages = the_images;
        this.TotalInputImages = the_images != null ? the_images.length : -1;
        this.ImageTokens = new double[this.TotalTokens];
    }

    public int getLineno() {
        return this.CurrentImageNo;
    }

    public int getNumTokens() throws IOException {
        return this.TotalTokens;
    }

    public double getTokenAt(int posiz) throws IOException {
        if (posiz < this.TotalTokens) {
            if (this.ImageTokens != null) {
                return this.ImageTokens[posiz];
            }
            return 0.0;
        }
        return 0.0;
    }

    public double[] getTokensArray() {
        return this.ImageTokens;
    }

    public void mark() throws IOException {
        this.MarkedImage = this.CurrentImageNo;
        this.MarkedToken = this.CurrentToken;
    }

    public boolean nextLine() throws IOException {
        boolean result = false;
        if (this.CurrentImageNo >= this.TotalInputImages || this.TotalInputImages <= 0) {
            return false;
        }
        if (this.FileMode) {
            try {
                URL theFile = (URL)this.ImageFileList.get(this.CurrentImageNo);
                BufferedImage tImg = ImageIO.read(theFile);
                result = this.processImage(tImg);
            }
            catch (Exception ex) {
                log.error("Caught Error processing Image : " + ex.toString());
            }
        } else if (this.ArrayOfInputImages != null && this.ArrayOfInputImages.length >= 1) {
            result = this.processImage(this.ArrayOfInputImages[this.CurrentImageNo]);
        }
        ++this.CurrentImageNo;
        return result;
    }

    private double nextToken() throws IOException {
        return this.nextToken(null);
    }

    private double nextToken(String delim) throws IOException {
        if (this.CurrentToken < this.TotalTokens) {
            double value = this.ImageTokens[this.CurrentToken];
            ++this.CurrentToken;
            return value;
        }
        return 0.0;
    }

    public void resetInput() throws IOException {
        if (this.MarkedImage > 0 || this.MarkedToken > 0) {
            this.CurrentImageNo = this.MarkedImage;
            this.CurrentToken = this.MarkedToken;
        } else {
            this.CurrentImageNo = 0;
        }
        if (this.FileMode) {
            try {
                URL theFile = (URL)this.ImageFileList.get(this.CurrentImageNo);
                BufferedImage tImg = ImageIO.read(theFile.openStream());
                this.processImage(tImg);
            }
            catch (Exception ex) {
                log.error("Error processing/loading image : " + ex.toString());
            }
        } else if (this.ArrayOfInputImages != null && this.ArrayOfInputImages.length >= 1) {
            this.processImage(this.ArrayOfInputImages[this.CurrentImageNo]);
        }
    }

    public void setDecimalPoint(char dp) {
    }

    public char getDecimalPoint() {
        return '.';
    }

    private boolean processImage(Image theImage) {
        block7: {
            double Red = 0.0;
            double Green = 0.0;
            double Blue = 0.0;
            double Grey = 0.0;
            int[] TempTokens = null;
            try {
                TempTokens = this.ColourMode ? new int[this.TotalTokens / 3] : new int[this.TotalTokens];
                Image TempImage = theImage.getScaledInstance(this.RequiredWidth, this.RequiredHeight, 16);
                PixelGrabber pixgrab = new PixelGrabber(TempImage, 0, 0, TempImage.getWidth(null), TempImage.getHeight(null), TempTokens, 0, TempImage.getWidth(null));
                if (pixgrab.grabPixels()) {
                    if (this.ColourMode) {
                        for (int i = 0; i < TempTokens.length; ++i) {
                            Red = (double)((TempTokens[i] & 0xFF0000) >> 16) / 255.0;
                            Green = (double)((TempTokens[i] & 0xFF00) >> 8) / 255.0;
                            Blue = (double)(TempTokens[i] & 0xFF) / 255.0;
                            this.ImageTokens[i * 3] = Red;
                            this.ImageTokens[i * 3 + 1] = Green;
                            this.ImageTokens[i * 3 + 2] = Blue;
                        }
                    } else {
                        for (int i = 0; i < TempTokens.length; ++i) {
                            Red = (double)((TempTokens[i] & 0xFF0000) >> 16) / 255.0;
                            Green = (double)((TempTokens[i] & 0xFF00) >> 8) / 255.0;
                            Blue = (double)(TempTokens[i] & 0xFF) / 255.0;
                            this.ImageTokens[i] = Grey = (Red + Blue + Green) / 3.0;
                        }
                    }
                    break block7;
                }
                log.error("Failed to grab image pixels due to error.");
                return false;
            }
            catch (Exception ex) {
                log.error("Error processing image : " + ex.toString());
                return false;
            }
        }
        return true;
    }
}

