/*
 * Decompiled with CFR 0.152.
 */
package org.joone.inspection.implementations;

import java.util.Vector;
import org.joone.engine.Pattern;
import org.joone.inspection.Inspection;

public class InputsInspection
implements Inspection {
    private Vector inputs = null;

    public InputsInspection(Vector inputsArg) {
        this.inputs = inputsArg;
    }

    public Object[][] getComponent() {
        if (this.inputs != null && this.inputs.size() > 0) {
            int i;
            Object[][] bigValues = null;
            for (i = 0; i < this.inputs.size(); ++i) {
                Pattern pattern = (Pattern)this.inputs.elementAt(i);
                double[] array = pattern.getArray();
                if (bigValues == null) {
                    bigValues = new Object[this.inputs.size()][array.length + 1];
                }
                for (int j = 1; j < array.length + 1; ++j) {
                    Double d = new Double(array[j - 1]);
                    bigValues[i][j] = d;
                }
            }
            for (i = 0; i < this.inputs.size(); ++i) {
                bigValues[i][0] = new Integer(i + 1);
            }
            return bigValues;
        }
        return null;
    }

    public String getTitle() {
        return "Inputs";
    }

    public Object[] getNames() {
        if (this.inputs != null && this.inputs.size() > 0) {
            String[] names = null;
            for (int i = 0; i < this.inputs.size(); ++i) {
                Pattern pattern = (Pattern)this.inputs.elementAt(i);
                double[] array = pattern.getArray();
                if (names == null) {
                    names = new String[array.length + 1];
                }
                names[0] = "Row Number";
                for (int j = 1; j < array.length + 1; ++j) {
                    names[j] = "Column " + j;
                }
            }
            return names;
        }
        return null;
    }

    public boolean rowNumbers() {
        return true;
    }

    public void setComponent(Object[][] newValues) {
        for (int x = 0; x < this.inputs.size() && x < newValues.length; ++x) {
            double[] values = ((Pattern)this.inputs.elementAt(x)).getArray();
            int n = ((Pattern)this.inputs.elementAt(x)).getCount();
            for (int y = 0; y < values.length && y < newValues[0].length - 1; ++y) {
                values[y] = (Double)newValues[x][y + 1];
            }
            Pattern patt = new Pattern(values);
            patt.setCount(n);
            this.inputs.setElementAt(patt, x);
        }
    }
}

