/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine.weights;

import org.joone.engine.Matrix;
import org.joone.engine.weights.WeightInitializer;

public class FanInBasedWeightInitializer
implements WeightInitializer {
    private double lowerBound = -2.4;
    private double upperBound = 2.4;
    private boolean sqrtFanIn = false;

    public FanInBasedWeightInitializer() {
    }

    public FanInBasedWeightInitializer(double aBoundary) {
        this.lowerBound = -aBoundary;
        this.upperBound = aBoundary;
    }

    public FanInBasedWeightInitializer(double aLowerBound, double anUpperBound) {
        this.lowerBound = aLowerBound;
        this.upperBound = anUpperBound;
    }

    public void initialize(Matrix aMatrix) {
        for (int x = 0; x < aMatrix.getM_rows(); ++x) {
            for (int y = 0; y < aMatrix.getM_cols(); ++y) {
                if (!aMatrix.enabled[x][y] || aMatrix.fixed[x][y]) continue;
                aMatrix.value[x][y] = this.lowerBound / (this.isSqrtFanIn() ? Math.sqrt(aMatrix.getM_rows()) : (double)aMatrix.getM_rows()) + Math.random() * ((this.upperBound - this.lowerBound) / (this.isSqrtFanIn() ? Math.sqrt(aMatrix.getM_rows()) : (double)aMatrix.getM_rows()));
            }
        }
    }

    public void setSqrtFanIn(boolean aMode) {
        this.sqrtFanIn = aMode;
    }

    public boolean isSqrtFanIn() {
        return this.sqrtFanIn;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(double aLowerBound) {
        this.lowerBound = aLowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(double anUpperBound) {
        this.upperBound = anUpperBound;
    }
}

