/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.io.Serializable;
import java.util.TreeSet;
import java.util.Vector;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralElement;
import org.joone.engine.OutputPatternListener;
import org.joone.engine.Pattern;

public class OutputSwitchSynapse
implements OutputPatternListener,
Serializable {
    protected Vector outputs = new Vector();
    private String name;
    private Monitor mon = null;
    private int inputDimension = 0;
    private boolean outputFull;
    private boolean enabled = true;
    private static final long serialVersionUID = 2906294213180089226L;
    private OutputPatternListener activeSynapse = null;
    private OutputPatternListener defaultSynapse = null;

    public void reset() {
        this.setActiveSynapse(this.getDefaultSynapse());
    }

    public boolean removeOutputSynapse(String outputName) {
        boolean retValue = false;
        OutputPatternListener opl = this.getOutputSynapse(outputName);
        if (opl != null) {
            this.outputs.removeElement(opl);
            opl.setOutputFull(false);
            if (this.outputs.size() > 0) {
                if (this.getActiveOutput().equalsIgnoreCase(outputName)) {
                    this.setActiveSynapse((OutputPatternListener)this.outputs.elementAt(0));
                }
                if (this.getDefaultOutput().equalsIgnoreCase(outputName)) {
                    this.setDefaultSynapse((OutputPatternListener)this.outputs.elementAt(0));
                }
            } else {
                this.setActiveOutput("");
                this.setDefaultOutput("");
            }
            retValue = true;
        }
        return retValue;
    }

    protected OutputPatternListener getOutputSynapse(String outputName) {
        int i;
        OutputPatternListener out = null;
        for (i = 0; i < this.outputs.size() && !(out = (OutputPatternListener)this.outputs.elementAt(i)).getName().equalsIgnoreCase(outputName); ++i) {
        }
        if (i < this.outputs.size()) {
            return out;
        }
        return null;
    }

    public boolean addOutputSynapse(OutputPatternListener newOutput) {
        boolean retValue = false;
        if (!this.outputs.contains(newOutput) && !newOutput.isOutputFull()) {
            this.outputs.addElement(newOutput);
            newOutput.setInputDimension(this.inputDimension);
            newOutput.setMonitor(this.mon);
            newOutput.setOutputFull(true);
            if (this.outputs.size() == 1) {
                this.setDefaultOutput(newOutput.getName());
                this.setActiveOutput(newOutput.getName());
            }
            retValue = true;
        }
        return retValue;
    }

    public String getActiveOutput() {
        if (this.activeSynapse != null) {
            return this.activeSynapse.getName();
        }
        return "";
    }

    public void setActiveOutput(String newActiveOutput) {
        OutputPatternListener out;
        this.activeSynapse = out = this.getOutputSynapse(newActiveOutput);
    }

    public String getDefaultOutput() {
        if (this.defaultSynapse != null) {
            return this.defaultSynapse.getName();
        }
        return "";
    }

    public void setDefaultOutput(String newDefaultOutput) {
        OutputPatternListener out;
        this.defaultSynapse = out = this.getOutputSynapse(newDefaultOutput);
    }

    protected OutputPatternListener getActiveSynapse() {
        return this.activeSynapse;
    }

    protected void setActiveSynapse(OutputPatternListener activeSynapse) {
        this.activeSynapse = activeSynapse;
    }

    protected OutputPatternListener getDefaultSynapse() {
        return this.defaultSynapse;
    }

    protected void setDefaultSynapse(OutputPatternListener defaultSynapse) {
        this.defaultSynapse = defaultSynapse;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setInputDimension(int newInputDimension) {
        this.inputDimension = newInputDimension;
        for (int i = 0; i < this.outputs.size(); ++i) {
            OutputPatternListener out = (OutputPatternListener)this.outputs.elementAt(i);
            out.setInputDimension(newInputDimension);
        }
    }

    public int getInputDimension() {
        return this.inputDimension;
    }

    public Monitor getMonitor() {
        return this.mon;
    }

    public void setMonitor(Monitor newMonitor) {
        this.mon = newMonitor;
        for (int i = 0; i < this.outputs.size(); ++i) {
            OutputPatternListener out = (OutputPatternListener)this.outputs.elementAt(i);
            out.setMonitor(newMonitor);
        }
    }

    protected void backward(double[] pattern) {
    }

    protected void forward(double[] pattern) {
    }

    public Vector getAllOutputs() {
        return this.outputs;
    }

    public void resetOutput() {
        this.reset();
    }

    public void fwdPut(Pattern pattern) {
        if (this.isEnabled() && this.activeSynapse != null) {
            this.activeSynapse.fwdPut(pattern);
        }
    }

    public Pattern revGet() {
        if (this.isEnabled() && this.activeSynapse != null) {
            return this.activeSynapse.revGet();
        }
        return null;
    }

    public TreeSet check() {
        TreeSet checks = new TreeSet();
        return checks;
    }

    public boolean isOutputFull() {
        return this.outputFull;
    }

    public void setOutputFull(boolean outputFull) {
        this.outputFull = outputFull;
        for (int i = 0; i < this.outputs.size(); ++i) {
            OutputPatternListener out = (OutputPatternListener)this.outputs.elementAt(i);
            out.setOutputFull(outputFull);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void init() {
        for (int i = 0; i < this.outputs.size(); ++i) {
            if (!(this.outputs.elementAt(i) instanceof NeuralElement)) continue;
            ((NeuralElement)this.outputs.elementAt(i)).init();
        }
    }
}

