/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import org.joone.edit.JoonEdit;
import org.joone.edit.NeuralNetDrawing;
import org.joone.net.NetCheck;
import org.joone.net.NetChecker;
import org.joone.net.NeuralNet;

public class TodoFrame
extends JFrame {
    private JoonEdit owner = null;
    private JPanel centerPanel = new JPanel();

    public TodoFrame(Frame ownerArg) {
        this.owner = (JoonEdit)((Object)ownerArg);
        this.setTitle("To Do List");
        this.setResizable(false);
        JRootPane rp = this.getRootPane();
        rp.setLayout(new BorderLayout());
        this.centerPanel.setLayout(new GridLayout(0, 1));
        rp.add((Component)this.centerPanel, "Center");
        Button b = new Button("Revalidate");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TodoFrame.this.check();
                TodoFrame.this.pack();
                TodoFrame.this.repaint();
            }
        });
        JPanel jp2 = new JPanel();
        jp2.add(b);
        rp.add((Component)jp2, "South");
    }

    public void show() {
        this.check();
        this.pack();
        this.setIconImage(this.owner.getIconImage());
        this.setLocation((this.owner.getWidth() - this.owner.getX() - this.getWidth()) / 2, (this.owner.getHeight() - this.owner.getY() - this.getHeight()) / 2);
        super.show();
    }

    private void check() {
        NeuralNetDrawing nnd = (NeuralNetDrawing)this.owner.drawing();
        NeuralNet nn = nnd.getNeuralNet();
        NetChecker nc = new NetChecker(nn);
        TreeSet checks = nc.check();
        this.centerPanel.removeAll();
        if (checks.isEmpty()) {
            this.centerPanel.add(new JLabel("Network checks out okay."));
        } else {
            Iterator iter = checks.iterator();
            while (iter.hasNext()) {
                NetCheck netCheck = (NetCheck)iter.next();
                this.centerPanel.add(new JLabel(netCheck.toString()));
            }
        }
    }
}

