/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.filechooser.FileFilter;
import org.joone.edit.NetStorageFormat;
import org.joone.net.NeuralNet;

public class StandardNetStorageFormat
implements NetStorageFormat {
    private FileFilter myFileFilter;
    private String myFileExtension;
    private String myFileDescription;

    public StandardNetStorageFormat() {
        this.setFileExtension(this.createFileExtension());
        this.setFileDescription(this.createFileDescription());
        this.setFileFilter(this.createFileFilter());
    }

    protected String createFileExtension() {
        this.myFileExtension = "snet";
        return "snet";
    }

    public void setFileExtension(String newFileExtension) {
        this.myFileExtension = newFileExtension;
    }

    public String getFileExtension() {
        return this.myFileExtension;
    }

    public String createFileDescription() {
        return "Serialized NeuralNet (" + this.getFileExtension() + ")";
    }

    public void setFileDescription(String newFileDescription) {
        this.myFileDescription = newFileDescription;
    }

    public String getFileDescription() {
        return this.myFileDescription;
    }

    protected FileFilter createFileFilter() {
        return new FileFilter(){

            public boolean accept(File checkFile) {
                if (checkFile.isDirectory()) {
                    return true;
                }
                return checkFile.getName().endsWith("." + StandardNetStorageFormat.this.myFileExtension);
            }

            public String getDescription() {
                return StandardNetStorageFormat.this.getFileDescription();
            }
        };
    }

    public void setFileFilter(FileFilter newFileFilter) {
        this.myFileFilter = newFileFilter;
    }

    public FileFilter getFileFilter() {
        return this.myFileFilter;
    }

    public String store(String fileName, NeuralNet saveNeuralNet) throws IOException {
        FileOutputStream stream = new FileOutputStream(this.adjustFileName(fileName));
        ObjectOutputStream output = new ObjectOutputStream(stream);
        output.writeObject(saveNeuralNet);
        output.close();
        return this.adjustFileName(fileName);
    }

    public NeuralNet restore(String fileName) throws IOException {
        try {
            FileInputStream stream = new FileInputStream(fileName);
            ObjectInputStream input = new ObjectInputStream(stream);
            return (NeuralNet)input.readObject();
        }
        catch (ClassNotFoundException exception) {
            throw new IOException("Could not restore NeuralNet '" + fileName + "': class not found!");
        }
    }

    public boolean equals(Object compareObject) {
        if (compareObject instanceof StandardNetStorageFormat) {
            return this.getFileExtension().equals(((StandardNetStorageFormat)compareObject).getFileExtension());
        }
        return false;
    }

    protected String adjustFileName(String testFileName) {
        if (!this.hasCorrectFileExtension(testFileName)) {
            return testFileName + "." + this.getFileExtension();
        }
        return testFileName;
    }

    protected boolean hasCorrectFileExtension(String testFileName) {
        return testFileName.endsWith("." + this.getFileExtension());
    }
}

