/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import org.joone.edit.ChartingHandle;
import org.joone.engine.Fifo;
import org.joone.engine.Pattern;

public class SharedBuffer {
    private final int ERROR = 0;
    private final int CYCLE = 1;
    private double[][] buffer;
    private Fifo fifoBuffer = new Fifo();
    private ChartingHandle handle;

    public synchronized double[][] get() {
        while (this.fifoBuffer.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.buffer = this.extractBuffer(this.fifoBuffer);
        this.notifyAll();
        return this.buffer;
    }

    public synchronized double[][] getNoWait() {
        if (this.fifoBuffer.isEmpty()) {
            return null;
        }
        this.buffer = this.extractBuffer(this.fifoBuffer);
        return this.buffer;
    }

    private double[][] extractBuffer(Fifo fifo) {
        int size = fifo.size();
        double[][] buff = new double[size + 1][2];
        for (int i = 0; i < size; ++i) {
            Pattern patt = (Pattern)fifo.pop();
            buff[i][1] = patt.getCount();
            buff[i][0] = patt.getArray()[0];
        }
        buff[size][0] = 0.0;
        buff[size][1] = -1.0;
        return buff;
    }

    public synchronized void put(double value, double cycle) {
        Pattern patt = new Pattern(new double[]{value});
        patt.setCount(new Double(cycle).intValue());
        this.fifoBuffer.push((Object)patt);
        this.notifyAll();
    }

    public ChartingHandle getHandle() {
        return this.handle;
    }

    public void setHandle(ChartingHandle handle) {
        this.handle = handle;
    }
}

