/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.CreationTool;
import java.util.Hashtable;
import org.joone.edit.ConcreteGenericFigure;
import org.joone.edit.NeuralNetDrawing;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class LayerFigureCreationTool
extends CreationTool {
    private static final ILogger log = LoggerFactory.getLogger((Class)LayerFigureCreationTool.class);
    protected Hashtable params = new Hashtable();
    String objType;
    DrawingView view;

    public LayerFigureCreationTool(DrawingView view, String type) {
        super(view);
        this.objType = type;
        this.view = view;
    }

    protected Figure createFigure() {
        try {
            Class<?> cLayer = Class.forName(this.objType);
            ConcreteGenericFigure lf = (ConcreteGenericFigure)cLayer.newInstance();
            lf.setParams(this.params);
            NeuralNetDrawing nnd = (NeuralNetDrawing)this.view.drawing();
            lf.setParam("NeuralNet", nnd.getNeuralNet());
            lf.initialize();
            return lf;
        }
        catch (ClassNotFoundException cnfe) {
            log.warn((Object)("ClassNotFoundException thrown. Message is : " + cnfe.getMessage()), (Throwable)cnfe);
        }
        catch (InstantiationException ie) {
            log.warn((Object)("InstantiationException thrown. Message is : " + ie.getMessage()), (Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            log.warn((Object)("IllegalAccessException thrown. Message is : " + iae.getMessage()), (Throwable)iae);
        }
        return null;
    }

    public Object getParam(Object key) {
        return this.params.get(key);
    }

    public void setParam(Object key, Object newParam) {
        this.params.put(key, newParam);
    }

    public void setParams(Hashtable newParams) {
        this.params = newParams;
    }
}

