/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import CH.ifa.draw.figures.ArrowTip;
import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.figures.LineDecoration;
import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.DeleteCommand;
import CH.ifa.draw.standard.NullHandle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.joone.edit.ConcreteGenericFigure;
import org.joone.edit.GenericFigure;
import org.joone.edit.LayerFigure;
import org.joone.edit.OutputLayerFigure;
import org.joone.edit.PropertySheet;
import org.joone.edit.UpdatableFigure;
import org.joone.edit.Wrapper;
import org.joone.edit.inspection.InspectionFrame;
import org.joone.engine.InputPatternListener;
import org.joone.engine.OutputPatternListener;
import org.joone.engine.Synapse;
import org.joone.inspection.Inspectable;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class LayerConnection
extends LineConnection
implements GenericFigure,
UpdatableFigure {
    private static final ILogger log = LoggerFactory.getLogger((Class)LayerConnection.class);
    private static final long serialVersionUID = -1564509302372952850L;
    private Hashtable params;
    protected Synapse mySynapse;

    public LayerConnection() {
        this.setEndDecoration((LineDecoration)new ArrowTip());
        this.setStartDecoration(null);
        this.params = new Hashtable();
    }

    public void handleConnect(Figure start, Figure end2) {
        LayerFigure source = (LayerFigure)start;
        LayerFigure target = (LayerFigure)end2;
        if (end2 instanceof OutputLayerFigure) {
            OutputLayerFigure olf = (OutputLayerFigure)target;
            OutputPatternListener myListener = olf.getOutputLayer();
            olf.addPreConn(source);
            source.addPostConn(target, myListener);
            source.notifyPostConn();
        } else {
            this.mySynapse = (Synapse)this.createSynapse();
            boolean newConn = target.addPreConn(source, (InputPatternListener)this.mySynapse);
            source.addPostConn(target, (OutputPatternListener)this.mySynapse);
            source.notifyPostConn();
            if (newConn && source.hasCycle((Figure)target)) {
                this.setAttribute("FrameColor", Color.red);
                this.mySynapse.setLoopBack(true);
            }
        }
    }

    public void handleDisconnect(Figure start, Figure end2) {
        LayerFigure source = (LayerFigure)start;
        LayerFigure target = (LayerFigure)end2;
        if (target != null) {
            target.removePreConn(source, (InputPatternListener)this.getSynapse());
        }
        if (source != null) {
            if (target instanceof OutputLayerFigure) {
                source.removePostConn(target, ((OutputLayerFigure)target).getOutputLayer());
            } else {
                source.removePostConn(target, (OutputPatternListener)this.getSynapse());
            }
        }
    }

    public boolean canConnect(Figure start, Figure end2) {
        boolean retVal;
        boolean bl = retVal = start instanceof ConcreteGenericFigure && end2 instanceof ConcreteGenericFigure;
        if (retVal) {
            ConcreteGenericFigure fEnd = (ConcreteGenericFigure)end2;
            ConcreteGenericFigure fStart = (ConcreteGenericFigure)start;
            retVal = retVal && fEnd.canConnect(fStart, (ConnectionFigure)this);
        }
        return retVal;
    }

    public Vector handles() {
        Vector handles = super.handles();
        handles.setElementAt(new NullHandle((Figure)this, PolyLineFigure.locator((int)0)), 0);
        return handles;
    }

    protected Object createSynapse() {
        try {
            String cl = (String)this.getParam("class");
            if (cl == null) {
                cl = new String("org.joone.engine.FullSynapse");
            }
            Class<?> cLayer = Class.forName(cl);
            Object ly = cLayer.newInstance();
            return ly;
        }
        catch (ClassNotFoundException cnfe) {
            log.warn((Object)("ClassNotFoundException thrown. Message is : " + cnfe.getMessage()), (Throwable)cnfe);
        }
        catch (InstantiationException ie) {
            log.warn((Object)("InstantiationException thrown. Message is : " + ie.getMessage()), (Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            log.warn((Object)("IllegalAccessException thrown. Message is : " + iae.getMessage()), (Throwable)iae);
        }
        return null;
    }

    public Synapse getSynapse() {
        return this.mySynapse;
    }

    public void setSynapse(Synapse newMySynapse) {
        this.mySynapse = newMySynapse;
    }

    public Object getParam(Object key) {
        if (this.params == null) {
            return null;
        }
        return this.params.get(key);
    }

    public void setParam(Object key, Object newParam) {
        this.params.put(key, newParam);
    }

    public void setParams(Hashtable newParams) {
        this.params = newParams;
    }

    public Wrapper getWrapper() {
        Synapse syn = this.getSynapse();
        if (syn != null) {
            return new Wrapper(this, this.getSynapse(), this.getSynapse().getName());
        }
        return null;
    }

    public void update() {
    }

    public boolean canConnect(GenericFigure start, ConnectionFigure conn) {
        return true;
    }

    public void draw(Graphics g) {
        Object oldColor = this.getAttribute("FrameColor");
        if (this.mySynapse != null && this.mySynapse.isLoopBack()) {
            this.setAttribute("FrameColor", Color.red);
        } else {
            this.setAttribute("FrameColor", oldColor);
        }
        super.draw(g);
        String lbl = (String)this.getParam("label");
        Synapse syn = this.getSynapse();
        if (lbl != null && syn != null) {
            int i = this.fPoints.size();
            Point p1 = (Point)this.fPoints.elementAt(0);
            Point p2 = (Point)this.fPoints.elementAt(i - 1);
            int xMin = p1.x;
            int xMax = p2.x;
            if (xMin < p2.x) {
                xMin = p2.x;
                xMax = p1.x;
            }
            int yMin = p1.y;
            int yMax = p2.y;
            if (yMin < p2.y) {
                yMin = p2.y;
                yMax = p1.y;
            }
            Point p = new Point();
            p.x = xMin + (xMax - xMin) / 2;
            p.y = yMin + (yMax - yMin) / 2;
            if (syn.isEnabled()) {
                g.setColor(new Color(255, 255, 255));
            } else {
                g.setColor(new Color(170, 170, 170));
            }
            g.fillRect(p.x - 6, p.y - 7, 12, 14);
            g.setColor(new Color(0, 0, 200));
            g.drawRect(p.x - 6, p.y - 7, 12, 14);
            g.drawString(lbl, p.x - 4, p.y + 5);
            g.setColor(this.getFrameColor());
        }
    }

    public JPopupMenu getPopupMenu(final PropertySheet ps, final DrawingView view) {
        JMenuItem jmi;
        JPopupMenu jpm = new JPopupMenu();
        final Wrapper wrap = this.getWrapper();
        if (wrap != null) {
            jmi = new JMenuItem("Properties");
            jmi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (ps != null) {
                        ps.setTarget(wrap);
                        ps.pack();
                        if (ps.getSize().width < 250) {
                            ps.setSize(new Dimension(250, ps.getSize().height));
                        }
                        ps.show();
                    }
                }
            });
            jpm.add(jmi);
        }
        jmi = new JMenuItem("Delete");
        jmi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new DeleteCommand("Delete", view).execute();
            }
        });
        jpm.add(jmi);
        if (wrap != null && this.getWrapper().getBean() instanceof Inspectable) {
            jmi = new JMenuItem("Inspect");
            jmi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Inspectable inspectable = (Inspectable)LayerConnection.this.getWrapper().getBean();
                    InspectionFrame iFrame = new InspectionFrame(inspectable);
                    iFrame.show();
                }
            });
            jpm.add(jmi);
        }
        return jpm;
    }
}

