/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import CH.ifa.draw.framework.HJDError;
import CH.ifa.draw.util.Iconkit;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.joone.edit.JooneFileChooser;
import org.joone.edit.jedit.JEditTextArea;
import org.joone.edit.jedit.tokenmarker.JavaTokenMarker;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NeuralNet;
import org.joone.script.MacroInterface;
import org.joone.util.GroovyMacroPlugin;
import org.joone.util.MacroPlugin;
import org.joone.util.MonitorPlugin;

public class JMacroEditor
extends JFrame {
    private static final ILogger log = LoggerFactory.getLogger((Class)JMacroEditor.class);
    private JEditTextArea ta;
    private NeuralNet neuralNet;
    private char[] m_buf;
    private String m_dir;
    private String[] FileExtension = new String[]{"bsh", "groovy"};
    private String FileDescription = "BeanShell scripts (.bsh) | Groovy scripts (.groovy)";
    private String fileName = null;
    private String actualMacro = null;
    private DefaultListModel list;
    private JMenuItem addMenuItem;
    private JRadioButtonMenuItem beanShellMenuItem;
    private ButtonGroup buttonGroup1;
    private JMenuItem copyMenuItem;
    private JMenuItem cutMenuItem;
    private JMenu editMenu;
    private JCheckBoxMenuItem enableMacroMenuItem;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JRadioButtonMenuItem groovyMenuItem;
    private JMenuItem importMenuItem;
    private JList jList1;
    private JMenu jMenuLanguage;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSplitPane jSplitPane1;
    private JMenu macroMenu;
    private JMenuBar menuBar;
    private JMenuItem pasteMenuItem;
    private JMenuItem removeMenuItem;
    private JMenuItem renameMenuItem;
    private JMenuItem runMenuItem;
    private JMenuItem saveAsMenuItem;
    private JMenuItem selectAllMenuItem;
    private JMenuItem setRateMenuItem;

    public JMacroEditor(NeuralNet nnet) {
        this.initComponents();
        this.setNeuralNet(nnet);
        this.ta = new JEditTextArea();
        this.ta.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                JMacroEditor.this.taFocusLost(evt);
            }
        });
        this.ta.setTokenMarker(new JavaTokenMarker());
        this.jSplitPane1.setRightComponent(this.ta);
        Iconkit kit = Iconkit.instance();
        if (kit == null) {
            throw new HJDError("Iconkit instance isn't set");
        }
        Image img = kit.loadImageResource("/org/joone/images/JooneIcon.gif");
        this.setIconImage(img);
        this.fillList();
        this.enableMacroMenuItem.setSelected(this.getNeuralNet().isScriptingEnabled());
        if (this.getNeuralNet().getMacroPlugin() instanceof MacroPlugin) {
            this.beanShellMenuItem.setSelected(true);
        } else {
            this.groovyMenuItem.setSelected(true);
        }
        this.pack();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jSplitPane1 = new JSplitPane();
        this.jList1 = new JList();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.importMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.cutMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.selectAllMenuItem = new JMenuItem();
        this.macroMenu = new JMenu();
        this.enableMacroMenuItem = new JCheckBoxMenuItem();
        this.jSeparator3 = new JSeparator();
        this.addMenuItem = new JMenuItem();
        this.removeMenuItem = new JMenuItem();
        this.renameMenuItem = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.runMenuItem = new JMenuItem();
        this.setRateMenuItem = new JMenuItem();
        this.jSeparator5 = new JSeparator();
        this.jMenuLanguage = new JMenu();
        this.beanShellMenuItem = new JRadioButtonMenuItem();
        this.groovyMenuItem = new JRadioButtonMenuItem();
        this.setTitle("JavaScript Macro Editor");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JMacroEditor.this.exitForm(evt);
            }
        });
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                JMacroEditor.this.jList1ValueChanged(evt);
            }
        });
        this.jSplitPane1.setLeftComponent(this.jList1);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.fileMenu.setText("File");
        this.importMenuItem.setText("Import Macro...");
        this.importMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JMacroEditor.this.importMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.importMenuItem);
        this.saveAsMenuItem.setText("Save Macro As ...");
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JMacroEditor.this.saveAsMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveAsMenuItem);
        this.fileMenu.add(this.jSeparator1);
        this.exitMenuItem.setMnemonic('x');
        this.exitMenuItem.setText("Close");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JMacroEditor.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.cutMenuItem.setText("Cut");
        this.cutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JMacroEditor.this.cutMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.cutMenuItem);
        this.copyMenuItem.setText("Copy");
        this.copyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JMacroEditor.this.copyMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.copyMenuItem);
        this.pasteMenuItem.setText("Paste");
        this.pasteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JMacroEditor.this.pasteMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.pasteMenuItem);
        this.editMenu.add(this.jSeparator4);
        this.selectAllMenuItem.setText("Select All");
        this.selectAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JMacroEditor.this.selectAllMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.selectAllMenuItem);
        this.menuBar.add(this.editMenu);
        this.macroMenu.setText("Macro");
        this.macroMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JMacroEditor.this.macroMenuActionPerformed(evt);
            }
        });
        this.enableMacroMenuItem.setText("Enable Scripting");
        this.enableMacroMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JMacroEditor.this.enableMacroMenuItemActionPerformed(evt);
            }
        });
        this.macroMenu.add(this.enableMacroMenuItem);
        this.macroMenu.add(this.jSeparator3);
        this.addMenuItem.setText("Add...");
        this.addMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JMacroEditor.this.addMenuItemActionPerformed(evt);
            }
        });
        this.macroMenu.add(this.addMenuItem);
        this.removeMenuItem.setText("Remove");
        this.removeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JMacroEditor.this.removeMenuItemActionPerformed(evt);
            }
        });
        this.macroMenu.add(this.removeMenuItem);
        this.renameMenuItem.setText("Rename");
        this.renameMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JMacroEditor.this.renameMenuItemActionPerformed(evt);
            }
        });
        this.macroMenu.add(this.renameMenuItem);
        this.macroMenu.add(this.jSeparator2);
        this.runMenuItem.setText("Run");
        this.runMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JMacroEditor.this.runMenuItemActionPerformed(evt);
            }
        });
        this.macroMenu.add(this.runMenuItem);
        this.setRateMenuItem.setText("set Rate...");
        this.setRateMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JMacroEditor.this.setRateMenuItemActionPerformed(evt);
            }
        });
        this.macroMenu.add(this.setRateMenuItem);
        this.macroMenu.add(this.jSeparator5);
        this.jMenuLanguage.setText("Language");
        this.buttonGroup1.add(this.beanShellMenuItem);
        this.beanShellMenuItem.setSelected(true);
        this.beanShellMenuItem.setText("BeanShell");
        this.beanShellMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JMacroEditor.this.beanShellMenuItemActionPerformed(evt);
            }
        });
        this.jMenuLanguage.add(this.beanShellMenuItem);
        this.buttonGroup1.add(this.groovyMenuItem);
        this.groovyMenuItem.setText("Groovy");
        this.groovyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JMacroEditor.this.groovyMenuItemActionPerformed(evt);
            }
        });
        this.jMenuLanguage.add(this.groovyMenuItem);
        this.macroMenu.add(this.jMenuLanguage);
        this.menuBar.add(this.macroMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void groovyMenuItemActionPerformed(ActionEvent evt) {
        GroovyMacroPlugin newMacroPlugin = new GroovyMacroPlugin();
        this.setNewMacroPlugin((MacroInterface)newMacroPlugin);
    }

    private void beanShellMenuItemActionPerformed(ActionEvent evt) {
        MacroPlugin newMacroPlugin = new MacroPlugin();
        this.setNewMacroPlugin((MacroInterface)newMacroPlugin);
    }

    private void setNewMacroPlugin(MacroInterface newMacroPlugin) {
        MacroInterface oldMacroPlugin = this.getNeuralNet().getMacroPlugin();
        newMacroPlugin.setMacroManager(oldMacroPlugin.getMacroManager());
        this.getNeuralNet().setMacroPlugin(newMacroPlugin);
    }

    private void taFocusLost(FocusEvent evt) {
        this.saveMacro();
    }

    private void setRateMenuItemActionPerformed(ActionEvent evt) {
        int oldRate = ((MonitorPlugin)this.getNeuralNet().getMacroPlugin()).getRate();
        String s_newRate = this.showInputDialog("Set Rate", "Insert the new rate's value:", Integer.toString(oldRate));
        if (s_newRate != null) {
            int newRate;
            try {
                newRate = Integer.parseInt(s_newRate);
            }
            catch (NumberFormatException nfe) {
                newRate = oldRate;
            }
            if (newRate < 0) {
                newRate *= -1;
            }
            ((MonitorPlugin)this.getNeuralNet().getMacroPlugin()).setRate(newRate);
        }
    }

    private void renameMenuItemActionPerformed(ActionEvent evt) {
        String newName = this.getNewName("Rename a macro", "Insert the new name of the Macro:", this.actualMacro);
        if (newName != null) {
            this.getNeuralNet().getMacroPlugin().getMacroManager().renameMacro(this.actualMacro, newName);
            this.actualMacro = newName;
            this.list.setElementAt(newName, this.jList1.getSelectedIndex());
        }
    }

    private void beanShellRadioButtonMenuItemActionPerformed(ActionEvent evt) {
    }

    private void groovyRadioButtonMenuItemActionPerformed(ActionEvent evt) {
    }

    private void removeMenuItemActionPerformed(ActionEvent evt) {
        int n = JOptionPane.showConfirmDialog(this, "OK to remove '" + this.actualMacro + "' ?", "Macro Editor", 0);
        if (n == 0) {
            this.getNeuralNet().getMacroPlugin().getMacroManager().removeMacro(this.actualMacro);
            String removed = this.actualMacro;
            this.actualMacro = null;
            this.list.removeElement(removed);
        }
    }

    private void addMenuItemActionPerformed(ActionEvent evt) {
        String newName = this.getNewName("Add a macro", "Insert the name of the new Macro:", "newMacro");
        if (newName != null) {
            this.getNeuralNet().getMacroPlugin().getMacroManager().addMacro(newName, "");
            this.list.addElement(newName);
            this.jList1.setSelectedIndex(this.list.size() - 1);
        }
    }

    private String getNewName(String title, String message, String initialValue) {
        boolean ok = false;
        String errorMsg = "ERROR: The name already exists.\n";
        String newName = this.showInputDialog(title, message, initialValue);
        if (newName != null) {
            while (!ok) {
                if (this.getNeuralNet().getMacroPlugin().getMacroManager().getMacro(newName) != null) {
                    newName = this.showInputDialog(title, errorMsg + message, newName);
                    if (newName != null) continue;
                    ok = true;
                    continue;
                }
                ok = true;
            }
        }
        return newName;
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        this.saveMacro();
        int index = this.jList1.getSelectedIndex();
        if (index > -1) {
            String name = (String)this.jList1.getModel().getElementAt(index);
            String macroText = this.getNeuralNet().getMacroPlugin().getMacroManager().getMacro(name);
            if (macroText.trim().equals(new String(""))) {
                macroText = "/* " + name + " */\n";
            }
            this.ta.setText(macroText);
            this.actualMacro = name;
            this.enableMenuItems(this.actualMacro);
        } else {
            this.jList1.setSelectedIndex(0);
        }
    }

    private void enableMenuItems(String name) {
        boolean system = this.getNeuralNet().getMacroPlugin().getMacroManager().isEventMacro(name);
        if (system) {
            this.removeMenuItem.setEnabled(false);
            this.renameMenuItem.setEnabled(false);
        } else {
            this.removeMenuItem.setEnabled(true);
            this.renameMenuItem.setEnabled(true);
        }
    }

    private void enableMacroMenuItemActionPerformed(ActionEvent evt) {
        this.neuralNet.setScriptingEnabled(this.enableMacroMenuItem.isSelected());
    }

    private void selectAllMenuItemActionPerformed(ActionEvent evt) {
        this.ta.selectAll();
    }

    private void saveAsMenuItemActionPerformed(ActionEvent evt) {
        this.saveAs();
    }

    private void importMenuItemActionPerformed(ActionEvent evt) {
        JooneFileChooser jfc = new JooneFileChooser();
        jfc.setDialogTitle("Macro Editor - Import File...");
        FileFilter bsh = new FileFilter(){

            public boolean accept(File checkFile) {
                if (checkFile.isDirectory()) {
                    return true;
                }
                boolean isFileExtensionMatch = false;
                String[] extension = JMacroEditor.this.getFileExtension();
                for (int i = 0; i < extension.length; ++i) {
                    if (!checkFile.getName().endsWith("." + extension[i])) continue;
                    isFileExtensionMatch = true;
                    break;
                }
                return isFileExtensionMatch;
            }

            public String getDescription() {
                return JMacroEditor.this.getFileDescription();
            }
        };
        jfc.addChoosableFileFilter(bsh);
        if (jfc.showOpenDialog(this) == 0) {
            this.setFileName(jfc.getSelectedFile().getAbsolutePath());
            File ff = new File(this.fileName);
            String txt = this.readFile(ff);
            if (txt != null) {
                this.ta.setText(txt);
            }
        }
    }

    private void pasteMenuItemActionPerformed(ActionEvent evt) {
        this.ta.paste();
    }

    private void copyMenuItemActionPerformed(ActionEvent evt) {
        this.ta.copy();
    }

    private void cutMenuItemActionPerformed(ActionEvent evt) {
        this.ta.cut();
    }

    private void runMenuItemActionPerformed(ActionEvent evt) {
        this.getNeuralNet().getMacroPlugin().runMacro(this.ta.getText());
    }

    private void macroMenuActionPerformed(ActionEvent evt) {
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.saveMacro();
        this.setVisible(false);
    }

    private void exitForm(WindowEvent evt) {
        this.saveMacro();
    }

    public static void main(String[] args) {
        NeuralNet nn = new NeuralNet();
        nn.setMacroPlugin((MacroInterface)new MacroPlugin());
        JMacroEditor jte = new JMacroEditor(nn);
        jte.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        jte.show();
    }

    public void setText(String newText) {
        this.ta.setText(newText);
    }

    public String getText() {
        return this.ta.getText();
    }

    public NeuralNet getNeuralNet() {
        return this.neuralNet;
    }

    public void setNeuralNet(NeuralNet neuralNet) {
        this.neuralNet = neuralNet;
    }

    private String readFile(File p_file) {
        String str = null;
        FileReader reader = null;
        try {
            reader = new FileReader(p_file);
            int tch = new Long(p_file.length()).intValue();
            this.m_buf = new char[tch];
            int nch = reader.read(this.m_buf);
            if (nch != -1) {
                str = new String(this.m_buf, 0, nch);
            }
            reader.close();
        }
        catch (FileNotFoundException fnfe) {
            log.warn((Object)("File '" + p_file + "' not found. MEssage is : " + fnfe.getMessage()), (Throwable)fnfe);
            return str;
        }
        catch (IOException ioe) {
            log.error((Object)("File '" + this.m_dir + "' input/output error. Message is : " + ioe.getMessage()), (Throwable)ioe);
        }
        return str;
    }

    public String getFileDescription() {
        return this.FileDescription;
    }

    public void setFileDescription(String FileDescription) {
        this.FileDescription = FileDescription;
    }

    public String[] getFileExtension() {
        return (String[])this.FileExtension.clone();
    }

    public void setFileExtension(String[] FileExtension) {
        this.FileExtension = (String[])FileExtension.clone();
    }

    private void saveAs() {
        JFileChooser jfc = this.fileName == null ? new JFileChooser() : new JFileChooser(new File(this.fileName));
        jfc.setDialogTitle("Macro Editor - Save as...");
        if (jfc.showSaveDialog(this) == 0) {
            this.setFileName(jfc.getSelectedFile().getAbsolutePath());
            this.save();
        }
    }

    private void save() {
        try {
            FileWriter fw = new FileWriter(new File(this.fileName));
            fw.write(this.ta.getText());
            fw.flush();
            fw.close();
        }
        catch (IOException ioe) {
            log.warn((Object)("IOException thrown. Message is +" + ioe.getMessage()), (Throwable)ioe);
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        if (fileName != null) {
            this.setTitle(fileName);
        } else {
            this.setTitle("New File");
        }
    }

    private void fillList() {
        Hashtable macros = this.getNeuralNet().getMacroPlugin().getMacroManager().getMacros();
        this.list = new DefaultListModel();
        Enumeration keys = macros.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.list.addElement(key);
        }
        this.jList1.setModel(this.list);
        this.jList1.setSelectedIndex(0);
    }

    private String showInputDialog(String title, String message, String initialValue) {
        Object selectedValue;
        JOptionPane pane = new JOptionPane(message, 3);
        pane.setWantsInput(true);
        pane.setInitialSelectionValue(initialValue);
        pane.setOptionType(2);
        JDialog dialog = pane.createDialog(this, title);
        dialog.show();
        int selectedButton = (Integer)pane.getValue();
        if (selectedButton == 0 && (selectedValue = pane.getInputValue()) != null && selectedValue instanceof String) {
            return (String)selectedValue;
        }
        return null;
    }

    private void saveMacro() {
        String oldText;
        if (this.actualMacro != null && !(oldText = this.getNeuralNet().getMacroPlugin().getMacroManager().getMacro(this.actualMacro)).equals(this.ta.getText())) {
            this.getNeuralNet().getMacroPlugin().getMacroManager().addMacro(this.actualMacro, this.ta.getText());
        }
    }
}

