/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.Hashtable;
import org.joone.edit.ChartingHandle;
import org.joone.edit.SharedBuffer;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class DrawingRegion
extends Canvas
implements Runnable {
    private static final ILogger log = LoggerFactory.getLogger((Class)DrawingRegion.class);
    private static final int ERROR = 0;
    private static final int CYCLE = 1;
    private int X_ENHETER = 0;
    private double X_INTERVALL = 0.0;
    private int Y_ENHETER = 10;
    private int MAX_X;
    private int MAX_Y;
    private double[] grafData;
    private Hashtable grafDataMul;
    private SharedBuffer grafBuffer;
    private Hashtable buffers;
    private Thread myThread;
    private Dimension myDim;
    private int currentCycle = 0;
    private boolean keepPlotting = true;
    private Color original;
    private Color background;
    private Color gray;
    private int max_x_value;
    private double max_y_value;
    private double stepY;
    private double stepX;
    private int X = 45;
    private int Y = 25;
    private BufferedImage bi;
    private Graphics big;
    private static final long serialVersionUID = -1681735154132358889L;

    public DrawingRegion(Dimension dimension, double ySpredning, int xSpredning) {
        if (dimension.width < this.X && dimension.height < this.Y) {
            log.warn((Object)("Drawing area too small, use min " + this.X + " * " + this.Y + " pixels."));
        } else if (xSpredning < 2) {
            log.warn((Object)"X Spredning must be > 1");
        } else if (ySpredning <= 0.0) {
            log.warn((Object)"Y Spredning must be > 0.0");
        } else {
            this.myDim = dimension;
            this.max_x_value = xSpredning;
            this.max_y_value = ySpredning;
            this.setSize(this.myDim);
            this.getXEnhet(xSpredning);
            this.constructorInit();
        }
    }

    public DrawingRegion(Dimension dimension, int xSpredning) {
        this(dimension, 1.0, xSpredning);
    }

    public DrawingRegion(int xSpredning) {
        this(new Dimension(550, 350), xSpredning);
    }

    private void constructorInit() {
        this.buffers = new Hashtable();
        this.grafData = new double[this.max_x_value + 1];
        this.grafDataMul = new Hashtable();
        this.original = new Color(0, 0, 0);
        this.background = new Color(200, 200, 200);
        this.gray = new Color(160, 160, 160);
        this.setBackground(this.background);
        this.setDimensions(this.myDim);
        this.start();
    }

    private void setDimensions(Dimension dimension) {
        this.myDim = dimension;
        double tempX = this.myDim.width - 2 * this.X;
        double tempY = this.myDim.height - 2 * this.Y;
        this.MAX_X = new Double(tempX).intValue();
        this.MAX_Y = new Double(tempY).intValue();
        this.stepX = (double)this.MAX_X / (double)this.max_x_value;
        this.stepY = (double)this.MAX_Y / this.max_y_value;
    }

    private void getXEnhet(int xSpredning) {
        this.X_INTERVALL = xSpredning / 5;
        this.X_ENHETER = new Double((double)xSpredning / this.X_INTERVALL).intValue();
    }

    public void stopPloting() {
        this.keepPlotting = false;
    }

    public SharedBuffer getBuffer() {
        if (this.grafBuffer == null) {
            this.grafBuffer = new SharedBuffer();
        }
        return this.grafBuffer;
    }

    public SharedBuffer getBuffer(ChartingHandle handle) {
        SharedBuffer sb = (SharedBuffer)this.buffers.get(handle);
        if (sb == null) {
            sb = new SharedBuffer();
            sb.setHandle(handle);
            this.buffers.put(handle, sb);
        }
        return sb;
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    public void update(Graphics g) {
        Dimension dim = this.getSize();
        if (this.bi == null || this.bi.getWidth() != dim.width || this.bi.getHeight() != dim.height) {
            this.bi = new BufferedImage(dim.width, dim.height, 1);
            this.big = this.bi.getGraphics();
        }
        this.big.setColor(this.background);
        this.big.fillRect(0, 0, dim.width, dim.height);
        if (this.myDim.height != dim.height || this.myDim.width != dim.width) {
            this.setDimensions(dim);
        }
        this.initDrawingRegion(this.big);
        if (this.grafBuffer != null) {
            this.plot(this.big, this.grafData, new Color(0, 0, 200));
        }
        Enumeration k = this.buffers.keys();
        while (k.hasMoreElements()) {
            ChartingHandle handle = (ChartingHandle)k.nextElement();
            double[] data = (double[])this.grafDataMul.get(handle);
            Color col = new Color(handle.getRedColor(), handle.getGreenColor(), handle.getBlueColor());
            if (data == null) continue;
            this.plot(this.big, data, col);
        }
        this.big.setColor(this.original);
        int plassering = new Double((double)this.myDim.width * 0.5).intValue();
        this.big.drawString("Current cycle is " + this.currentCycle, plassering, 70);
        g.drawImage(this.bi, 0, 0, this);
    }

    private void initDrawingRegion(Graphics g) {
        g.setColor(this.original);
        g.drawRect(0, 0, this.myDim.width - 1, this.myDim.height - 1);
        g.drawString("Y", 20, 12);
        this.plotLine(g, 0, 0.0, 0, this.max_y_value);
        g.drawString("X", this.myDim.width - 20, this.myDim.height - 20);
        this.plotLine(g, 0, 0.0, this.max_x_value, 0.0);
        g.drawString("0,0", 10, this.myDim.height - 10);
        int xx = new Float(this.max_x_value / this.X_ENHETER).intValue();
        int x = 0;
        String text = new Integer(new Double(this.X_INTERVALL).intValue()).toString();
        int i = 1;
        while (i < this.X_ENHETER + 1) {
            g.drawString(text, this.getAbsX(x += xx) - 15, this.myDim.height - 2);
            this.plotLine(g, x, 5.0 / this.stepY, x, -5.0 / this.stepY);
            this.plotXGridLine(g, x);
            text = new Integer(new Double(this.X_INTERVALL * (double)(++i)).intValue()).toString();
        }
        this.Y_ENHETER = 10;
        double yy = this.max_y_value / (double)this.Y_ENHETER;
        double y = 0.0;
        int prc = this.getPrecision(this.max_y_value);
        int exp = (int)Math.pow(10.0, prc);
        for (int i2 = 1; i2 < this.Y_ENHETER + 1; ++i2) {
            double valY = this.max_y_value / (double)this.Y_ENHETER * (double)(this.Y_ENHETER + 1 - i2);
            int truncY = new Double(valY * (double)exp).intValue();
            valY = new Double(truncY) / (double)exp;
            text = new Double(valY).toString();
            this.plotLine(g, new Double(-5.0 / this.stepX).intValue(), y += yy, new Double(5.0 / this.stepX).intValue(), y);
            this.plotYGridLine(g, y);
            g.drawString(text, 2, this.getAbsY(this.max_y_value - y + yy) + 2);
        }
    }

    private int getPrecision(double xMax) {
        int div = new Double(10.0 / xMax).intValue();
        if (div == 0) {
            div = 1;
        }
        double log10 = Math.log(div) / Math.log(10.0);
        int dec = new Double(log10).intValue() + 2;
        return dec;
    }

    private void plotLine(Graphics g, int start_x, double start_y, int slutt_x, double slutt_y) {
        int x1 = this.getAbsX(start_x);
        int y1 = this.getAbsY(start_y);
        int x2 = this.getAbsX(slutt_x);
        int y2 = this.getAbsY(slutt_y);
        g.drawLine(x1, y1, x2, y2);
    }

    private int getAbsX(int x) {
        int x1 = new Double((double)x * this.stepX).intValue();
        return x1 + this.X;
    }

    private int getAbsY(double y) {
        int y1 = new Double(y * this.stepY).intValue();
        return this.myDim.height - this.Y - y1;
    }

    private void plotYGridLine(Graphics g, double y) {
        g.setColor(this.gray);
        this.plotLine(g, 0, y, this.max_x_value, y);
        g.setColor(this.original);
    }

    private void plotXGridLine(Graphics g, int x) {
        g.setColor(this.gray);
        this.plotLine(g, x, 0.0, x, this.max_y_value);
        g.setColor(this.original);
    }

    private void plot(Graphics g, double[] grafData, Color col) {
        boolean firstPoint = false;
        g.setColor(col);
        for (int i = 2; i <= this.currentCycle; ++i) {
            if (grafData[i - 1] == 0.0 && !firstPoint) continue;
            this.plotLine(g, i - 1, grafData[i - 1], i, grafData[i]);
            firstPoint = true;
        }
    }

    public void start() {
        if (this.myThread == null) {
            this.myThread = new Thread((Runnable)this, "DrawingRegion");
            try {
                this.myThread.start();
            }
            catch (Exception e) {
                String msg = "DrawingRegion:start() : " + e.getMessage();
                log.fatal((Object)msg, (Throwable)e);
                System.exit(1);
            }
        }
    }

    public void run() {
        int i = 0;
        while (this.keepPlotting) {
            if (this.grafBuffer != null) {
                i = this.getData(null);
            }
            int imax = i;
            Enumeration k = this.buffers.keys();
            while (k.hasMoreElements()) {
                ChartingHandle handle = (ChartingHandle)k.nextElement();
                i = this.getData(handle);
                if (i <= imax) continue;
                imax = i;
            }
            if (imax > 0) {
                this.currentCycle = imax;
                this.repaint();
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.myThread = null;
    }

    private int getData(ChartingHandle handle) {
        double[] data;
        double[][] error;
        if (handle == null) {
            error = this.grafBuffer.get();
            data = this.grafData;
        } else {
            SharedBuffer buff = (SharedBuffer)this.buffers.get(handle);
            error = buff.getNoWait();
            data = (double[])this.grafDataMul.get(handle);
            if (data == null) {
                data = new double[this.max_x_value + 1];
                this.grafDataMul.put(handle, data);
            }
        }
        int cycle = 0;
        if (error != null) {
            int x;
            for (int i = 0; i < error.length && (x = new Double(error[i][1]).intValue()) != -1 && x < data.length; ++i) {
                data[x] = error[i][0];
                cycle = x;
            }
        }
        return cycle;
    }

    public int getMaxXvalue() {
        return this.max_x_value;
    }

    public void setMaxXvalue(int max_x_value) {
        this.max_x_value = max_x_value;
        this.copyBuffer(max_x_value);
        this.getXEnhet(max_x_value);
        this.setDimensions(this.myDim);
        this.repaint();
    }

    public double getMaxYvalue() {
        return this.max_y_value;
    }

    public void setMaxYvalue(double max_y_value) {
        this.max_y_value = max_y_value;
        this.setDimensions(this.myDim);
        this.repaint();
    }

    private void copyBuffer(int newSize) {
        double[] newBuff = new double[newSize + 1];
        int xMax = newSize;
        if (xMax > this.grafData.length) {
            xMax = this.grafData.length;
        }
        for (int i = 0; i < xMax; ++i) {
            newBuff[i] = this.grafData[i];
        }
        if (this.currentCycle >= xMax) {
            this.currentCycle = xMax - 1;
        }
        this.grafData = newBuff;
    }

    protected void removeHandle(ChartingHandle handle) {
        if (this.buffers != null) {
            this.buffers.remove(handle);
        }
        if (this.grafDataMul != null) {
            this.grafDataMul.remove(handle);
        }
    }
}

