/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.isomorphism;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jgrapht.Graph;

class GraphOrdering<V, E> {
    private Graph<V, E> graph;
    private Map<V, Integer> mapVertexToOrder;
    private ArrayList<V> mapOrderToVertex;
    private int vertexCount;
    private int[][] outgoingEdges;
    private int[][] incomingEdges;
    private Boolean[][] adjMatrix;
    private boolean cacheEdges;

    public GraphOrdering(Graph<V, E> graph, boolean orderByDegree, boolean cacheEdges) {
        this.graph = graph;
        this.cacheEdges = cacheEdges;
        ArrayList<V> vertexSet = new ArrayList<V>(graph.vertexSet());
        if (orderByDegree) {
            vertexSet.sort(new GeneralVertexDegreeComparator<V>(graph));
        }
        this.vertexCount = vertexSet.size();
        this.mapVertexToOrder = new HashMap<V, Integer>();
        this.mapOrderToVertex = new ArrayList(this.vertexCount);
        if (cacheEdges) {
            this.outgoingEdges = new int[this.vertexCount][];
            this.incomingEdges = new int[this.vertexCount][];
            this.adjMatrix = new Boolean[this.vertexCount][this.vertexCount];
        }
        Integer i = 0;
        for (Object vertex : vertexSet) {
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
            this.mapVertexToOrder.put((Integer)vertex, n);
            this.mapOrderToVertex.add(vertex);
        }
    }

    public GraphOrdering(Graph<V, E> graph) {
        this(graph, false, true);
    }

    public int getVertexCount() {
        return this.vertexCount;
    }

    public int[] getOutEdges(int vertexNumber) {
        if (this.cacheEdges && this.outgoingEdges[vertexNumber] != null) {
            return this.outgoingEdges[vertexNumber];
        }
        V v = this.getVertex(vertexNumber);
        Set edgeSet = this.graph.outgoingEdgesOf(v);
        int[] vertexArray = new int[edgeSet.size()];
        int i = 0;
        for (Object edge : edgeSet) {
            V source = this.graph.getEdgeSource(edge);
            V target = this.graph.getEdgeTarget(edge);
            vertexArray[i++] = this.mapVertexToOrder.get(source.equals(v) ? target : source);
        }
        if (this.cacheEdges) {
            this.outgoingEdges[vertexNumber] = vertexArray;
        }
        return vertexArray;
    }

    public int[] getInEdges(int vertexNumber) {
        if (this.cacheEdges && this.incomingEdges[vertexNumber] != null) {
            return this.incomingEdges[vertexNumber];
        }
        V v = this.getVertex(vertexNumber);
        Set edgeSet = this.graph.incomingEdgesOf(v);
        int[] vertexArray = new int[edgeSet.size()];
        int i = 0;
        for (Object edge : edgeSet) {
            V source = this.graph.getEdgeSource(edge);
            V target = this.graph.getEdgeTarget(edge);
            vertexArray[i++] = this.mapVertexToOrder.get(source.equals(v) ? target : source);
        }
        if (this.cacheEdges) {
            this.incomingEdges[vertexNumber] = vertexArray;
        }
        return vertexArray;
    }

    public boolean hasEdge(int v1Number, int v2Number) {
        Boolean containsEdge = null;
        if (this.cacheEdges) {
            containsEdge = this.adjMatrix[v1Number][v2Number];
        }
        if (!this.cacheEdges || containsEdge == null) {
            V v1 = this.getVertex(v1Number);
            V v2 = this.getVertex(v2Number);
            containsEdge = this.graph.containsEdge(v1, v2);
        }
        if (this.cacheEdges && this.adjMatrix[v1Number][v2Number] == null) {
            this.adjMatrix[v1Number][v2Number] = containsEdge;
        }
        return containsEdge;
    }

    public V getVertex(int vertexNumber) {
        return this.mapOrderToVertex.get(vertexNumber);
    }

    public E getEdge(int v1Number, int v2Number) {
        V v1 = this.getVertex(v1Number);
        V v2 = this.getVertex(v2Number);
        return this.graph.getEdge(v1, v2);
    }

    public int getVertexNumber(V v) {
        return this.mapVertexToOrder.get(v);
    }

    public int[] getEdgeNumbers(E e) {
        V v1 = this.graph.getEdgeSource(e);
        V v2 = this.graph.getEdgeTarget(e);
        int[] edge = new int[]{this.mapVertexToOrder.get(v1), this.mapVertexToOrder.get(v2)};
        return edge;
    }

    public Graph<V, E> getGraph() {
        return this.graph;
    }

    private static class GeneralVertexDegreeComparator<V2>
    implements Comparator<V2> {
        private Graph<V2, ?> graph;

        GeneralVertexDegreeComparator(Graph<V2, ?> graph) {
            this.graph = graph;
        }

        @Override
        public int compare(V2 v1, V2 v2) {
            return this.graph.edgesOf(v1).size() - this.graph.edgesOf(v2).size();
        }
    }
}

