/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.connectivity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.GraphTests;
import org.jgrapht.alg.interfaces.StrongConnectivityAlgorithm;
import org.jgrapht.graph.AsSubgraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleDirectedGraph;

abstract class AbstractStrongConnectivityInspector<V, E>
implements StrongConnectivityAlgorithm<V, E> {
    protected final Graph<V, E> graph;
    protected List<Set<V>> stronglyConnectedSets;
    protected List<Graph<V, E>> stronglyConnectedSubgraphs;

    public AbstractStrongConnectivityInspector(Graph<V, E> graph) {
        this.graph = GraphTests.requireDirected(graph);
    }

    @Override
    public Graph<V, E> getGraph() {
        return this.graph;
    }

    @Override
    public boolean isStronglyConnected() {
        return this.stronglyConnectedSets().size() == 1;
    }

    @Override
    public List<Graph<V, E>> getStronglyConnectedComponents() {
        if (this.stronglyConnectedSubgraphs == null) {
            List sets = this.stronglyConnectedSets();
            this.stronglyConnectedSubgraphs = new ArrayList<Graph<V, E>>(sets.size());
            for (Set set : sets) {
                this.stronglyConnectedSubgraphs.add((Graph<V, AsSubgraph>)new AsSubgraph(this.graph, set, null));
            }
        }
        return this.stronglyConnectedSubgraphs;
    }

    @Override
    public Graph<Graph<V, E>, DefaultEdge> getCondensation() {
        List sets = this.stronglyConnectedSets();
        SimpleDirectedGraph<Graph<Object, E>, DefaultEdge> condensation = new SimpleDirectedGraph<Graph<Object, E>, DefaultEdge>(DefaultEdge.class);
        HashMap vertexToComponent = new HashMap();
        for (Set set : sets) {
            AsSubgraph component = new AsSubgraph(this.graph, set, null);
            condensation.addVertex((Graph<Object, E>)component);
            for (Object v : set) {
                vertexToComponent.put(v, component);
            }
        }
        for (Set<Object> e : this.graph.edgeSet()) {
            V t;
            Graph tComponent;
            V s = this.graph.getEdgeSource(e);
            Graph sComponent = (Graph)vertexToComponent.get(s);
            if (sComponent == (tComponent = (Graph)vertexToComponent.get(t = this.graph.getEdgeTarget(e)))) continue;
            condensation.addEdge(sComponent, tComponent);
        }
        return condensation;
    }
}

