/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.xml;

import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jgap.Chromosome;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.Genotype;
import org.jgap.InvalidConfigurationException;
import org.jgap.UnsupportedRepresentationException;
import org.jgap.xml.GeneCreationException;
import org.jgap.xml.ImproperXMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLManager {
    private static final String GENOTYPE_TAG = "genotype";
    private static final String CHROMOSOME_TAG = "chromosome";
    private static final String GENES_TAG = "genes";
    private static final String GENE_TAG = "gene";
    private static final String SIZE_ATTRIBUTE = "size";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final DocumentBuilder m_documentCreator;
    private static final Object m_lock;

    static {
        m_lock = new Object();
        try {
            m_documentCreator = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserError) {
            throw new RuntimeException("XMLManager: Unable to setup DocumentBuilder: " + parserError.getMessage());
        }
    }

    private XMLManager() {
    }

    public static Document representChromosomeAsDocument(Chromosome a_subject) {
        Document chromosomeDocument;
        Object object = m_lock;
        synchronized (object) {
            chromosomeDocument = m_documentCreator.newDocument();
        }
        Element chromosomeElement = XMLManager.representChromosomeAsElement(a_subject, chromosomeDocument);
        chromosomeDocument.appendChild(chromosomeElement);
        return chromosomeDocument;
    }

    public static Document representGenotypeAsDocument(Genotype a_subject) {
        Document genotypeDocument;
        Object object = m_lock;
        synchronized (object) {
            genotypeDocument = m_documentCreator.newDocument();
        }
        Element genotypeElement = XMLManager.representGenotypeAsElement(a_subject, genotypeDocument);
        genotypeDocument.appendChild(genotypeElement);
        return genotypeDocument;
    }

    public static Element representGenesAsElement(Gene[] a_geneValues, Document a_xmlDocument) {
        Element genesElement = a_xmlDocument.createElement(GENES_TAG);
        int i = 0;
        while (i < a_geneValues.length) {
            Element geneElement = a_xmlDocument.createElement(GENE_TAG);
            geneElement.setAttribute(CLASS_ATTRIBUTE, a_geneValues[i].getClass().getName());
            Text alleleRepresentation = a_xmlDocument.createTextNode(a_geneValues[i].getPersistentRepresentation());
            geneElement.appendChild(alleleRepresentation);
            genesElement.appendChild(geneElement);
            ++i;
        }
        return genesElement;
    }

    public static Element representChromosomeAsElement(Chromosome a_subject, Document a_xmlDocument) {
        Element chromosomeElement = a_xmlDocument.createElement(CHROMOSOME_TAG);
        chromosomeElement.setAttribute(SIZE_ATTRIBUTE, Integer.toString(a_subject.size()));
        Element genesElement = XMLManager.representGenesAsElement(a_subject.getGenes(), a_xmlDocument);
        chromosomeElement.appendChild(genesElement);
        return chromosomeElement;
    }

    public static Element representGenotypeAsElement(Genotype a_subject, Document a_xmlDocument) {
        Chromosome[] population = a_subject.getChromosomes();
        Element genotypeTag = a_xmlDocument.createElement(GENOTYPE_TAG);
        genotypeTag.setAttribute(SIZE_ATTRIBUTE, Integer.toString(population.length));
        int i = 0;
        while (i < population.length) {
            Element chromosomeElement = XMLManager.representChromosomeAsElement(population[i], a_xmlDocument);
            genotypeTag.appendChild(chromosomeElement);
            ++i;
        }
        return genotypeTag;
    }

    public static Gene[] getGenesFromElement(Configuration a_activeConfiguration, Element a_xmlElement) throws ImproperXMLException, UnsupportedRepresentationException, GeneCreationException {
        if (a_xmlElement == null || !a_xmlElement.getTagName().equals(GENES_TAG)) {
            throw new ImproperXMLException("Unable to build Chromosome instance from XML Element: given Element is not a 'genes' element.");
        }
        ArrayList<Gene> genes = new ArrayList<Gene>();
        NodeList geneElements = a_xmlElement.getElementsByTagName(GENE_TAG);
        if (geneElements == null) {
            throw new ImproperXMLException("Unable to build Gene instances from XML Element: 'gene' sub-elements not found.");
        }
        int numberOfGeneNodes = geneElements.getLength();
        int i = 0;
        while (i < numberOfGeneNodes) {
            Gene thisGeneObject;
            Element thisGeneElement = (Element)geneElements.item(i);
            thisGeneElement.normalize();
            String geneClassName = thisGeneElement.getAttribute(CLASS_ATTRIBUTE);
            try {
                thisGeneObject = (Gene)Class.forName(geneClassName).newInstance();
            }
            catch (Exception e) {
                throw new GeneCreationException(e.getMessage());
            }
            NodeList children = thisGeneElement.getChildNodes();
            int childrenSize = children.getLength();
            String alleleRepresentation = null;
            int j = 0;
            while (j < childrenSize) {
                if (children.item(j).getNodeType() == 3) {
                    alleleRepresentation = children.item(j).getNodeValue();
                    break;
                }
                ++j;
            }
            if (alleleRepresentation == null) {
                throw new ImproperXMLException("Unable to build Gene instance from XML Element: value (allele) is missing representation.");
            }
            try {
                thisGeneObject.setValueFromPersistentRepresentation(alleleRepresentation);
            }
            catch (UnsupportedOperationException e) {
                throw new GeneCreationException("Unable to build Gene because it does not support the setValueFromPersistentRepresentation() method.");
            }
            genes.add(thisGeneObject);
            ++i;
        }
        return genes.toArray(new Gene[genes.size()]);
    }

    public static Chromosome getChromosomeFromElement(Configuration a_activeConfiguration, Element a_xmlElement) throws ImproperXMLException, InvalidConfigurationException, UnsupportedRepresentationException, GeneCreationException {
        if (a_xmlElement == null || !a_xmlElement.getTagName().equals(CHROMOSOME_TAG)) {
            throw new ImproperXMLException("Unable to build Chromosome instance from XML Element: given Element is not a 'chromosome' element.");
        }
        Element genesElement = (Element)a_xmlElement.getElementsByTagName(GENES_TAG).item(0);
        if (genesElement == null) {
            throw new ImproperXMLException("Unable to build Chromosome instance from XML Element: 'genes' sub-element not found.");
        }
        Gene[] geneAlleles = XMLManager.getGenesFromElement(a_activeConfiguration, genesElement);
        return new Chromosome(a_activeConfiguration, geneAlleles);
    }

    public static Genotype getGenotypeFromElement(Configuration a_activeConfiguration, Element a_xmlElement) throws ImproperXMLException, InvalidConfigurationException, UnsupportedRepresentationException, GeneCreationException {
        if (a_xmlElement == null || !a_xmlElement.getTagName().equals(GENOTYPE_TAG)) {
            throw new ImproperXMLException("Unable to build Genotype instance from XML Element: given Element is not a 'genotype' element.");
        }
        NodeList chromosomes = a_xmlElement.getElementsByTagName(CHROMOSOME_TAG);
        int numChromosomes = chromosomes.getLength();
        Chromosome[] population = new Chromosome[numChromosomes];
        int i = 0;
        while (i < numChromosomes) {
            population[i] = XMLManager.getChromosomeFromElement(a_activeConfiguration, (Element)chromosomes.item(i));
            ++i;
        }
        return new Genotype(a_activeConfiguration, population);
    }

    public static Genotype getGenotypeFromDocument(Configuration a_activeConfiguration, Document a_xmlDocument) throws ImproperXMLException, InvalidConfigurationException, UnsupportedRepresentationException, GeneCreationException {
        Element rootElement = a_xmlDocument.getDocumentElement();
        if (rootElement == null || !rootElement.getTagName().equals(GENOTYPE_TAG)) {
            throw new ImproperXMLException("Unable to build Genotype from XML Document: 'genotype' element must be at root of document.");
        }
        return XMLManager.getGenotypeFromElement(a_activeConfiguration, rootElement);
    }

    public static Chromosome getChromosomeFromDocument(Configuration a_activeConfiguration, Document a_xmlDocument) throws ImproperXMLException, InvalidConfigurationException, UnsupportedRepresentationException, GeneCreationException {
        Element rootElement = a_xmlDocument.getDocumentElement();
        if (rootElement == null || !rootElement.getTagName().equals(CHROMOSOME_TAG)) {
            throw new ImproperXMLException("Unable to build Chromosome instance from XML Document: 'chromosome' element must be at root of Document.");
        }
        return XMLManager.getChromosomeFromElement(a_activeConfiguration, rootElement);
    }
}

