/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jgap.Chromosome;
import org.jgap.Configuration;
import org.jgap.NaturalSelector;
import org.jgap.RandomGenerator;
import org.jgap.impl.Pool;
import org.jgap.impl.SlotCounter;

public class WeightedRouletteSelector
implements NaturalSelector {
    private static final BigDecimal ZERO_BIG_DECIMAL = new BigDecimal(0.0);
    private Map m_wheel = new HashMap();
    private double m_totalNumberOfUsedSlots = 0.0;
    private Pool m_counterPool = new Pool();

    public synchronized void add(Configuration a_activeConfigurator, Chromosome a_chromosomeToAdd) {
        SlotCounter counter = (SlotCounter)this.m_wheel.get(a_chromosomeToAdd);
        if (counter != null) {
            counter.increment();
        } else {
            a_chromosomeToAdd.setIsSelectedForNextGeneration(false);
            counter = (SlotCounter)this.m_counterPool.acquirePooledObject();
            if (counter == null) {
                counter = new SlotCounter();
            }
            counter.reset(a_chromosomeToAdd.getFitnessValue());
            this.m_wheel.put(a_chromosomeToAdd, counter);
        }
    }

    public synchronized Chromosome[] select(Configuration a_activeConfiguration, int a_howManyToSelect) {
        RandomGenerator generator = a_activeConfiguration.getRandomGenerator();
        Chromosome[] selections = new Chromosome[a_howManyToSelect];
        this.scaleFitnessValues();
        Set entries = this.m_wheel.entrySet();
        int numberOfEntries = entries.size();
        double[] fitnessValues = new double[numberOfEntries];
        double[] counterValues = new double[numberOfEntries];
        Chromosome[] chromosomes = new Chromosome[numberOfEntries];
        this.m_totalNumberOfUsedSlots = 0.0;
        Iterator entryIterator = entries.iterator();
        int i = 0;
        while (i < numberOfEntries) {
            Map.Entry chromosomeEntry = entryIterator.next();
            Chromosome currentChromosome = (Chromosome)chromosomeEntry.getKey();
            SlotCounter currentCounter = (SlotCounter)chromosomeEntry.getValue();
            fitnessValues[i] = currentCounter.getFitnessValue();
            counterValues[i] = currentCounter.getFitnessValue() * (double)currentCounter.getCounterValue();
            chromosomes[i] = currentChromosome;
            this.m_totalNumberOfUsedSlots += counterValues[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < a_howManyToSelect) {
            Chromosome selectedChromosome = this.spinWheel(generator, fitnessValues, counterValues, chromosomes);
            selectedChromosome.setIsSelectedForNextGeneration(true);
            selections[i2] = selectedChromosome;
            ++i2;
        }
        return selections;
    }

    private Chromosome spinWheel(RandomGenerator a_generator, double[] a_fitnessValues, double[] a_counterValues, Chromosome[] a_chromosomes) {
        double selectedSlot = Math.abs(a_generator.nextDouble() * this.m_totalNumberOfUsedSlots);
        double currentSlot = 0.0;
        int i = 0;
        while (i < a_counterValues.length) {
            if ((currentSlot += a_counterValues[i]) > selectedSlot) {
                int n = i;
                a_counterValues[n] = a_counterValues[n] - a_fitnessValues[i];
                this.m_totalNumberOfUsedSlots -= a_fitnessValues[i];
                return a_chromosomes[i];
            }
            ++i;
        }
        long totalSlotsLeft = 0L;
        int i2 = 0;
        while (i2 < a_counterValues.length) {
            totalSlotsLeft = (long)((double)totalSlotsLeft + a_counterValues[i2]);
            ++i2;
        }
        throw new RuntimeException("Logic Error. This code should never be reached. Please report this as a bug to the JGAP team: selected slot " + selectedSlot + " " + "exceeded " + totalSlotsLeft + " number of slots left. " + "We thought there were " + this.m_totalNumberOfUsedSlots + " slots left.");
    }

    public synchronized void empty() {
        this.m_counterPool.releaseAllObjects(this.m_wheel.values());
        this.m_wheel.clear();
        this.m_totalNumberOfUsedSlots = 0.0;
    }

    private void scaleFitnessValues() {
        double largestFitnessValue = 0.0;
        BigDecimal totalFitness = ZERO_BIG_DECIMAL;
        Iterator counterIterator = this.m_wheel.values().iterator();
        while (counterIterator.hasNext()) {
            SlotCounter counter = (SlotCounter)counterIterator.next();
            if (counter.getFitnessValue() > largestFitnessValue) {
                largestFitnessValue = counter.getFitnessValue();
            }
            BigDecimal counterFitness = new BigDecimal(counter.getFitnessValue());
            totalFitness = totalFitness.add(counterFitness.multiply(new BigDecimal((double)counter.getCounterValue())));
        }
        double scalingFactor = totalFitness.divide(new BigDecimal(largestFitnessValue), 4).doubleValue();
        counterIterator = this.m_wheel.values().iterator();
        while (counterIterator.hasNext()) {
            SlotCounter counter = (SlotCounter)counterIterator.next();
            counter.scaleFitnessValue(scalingFactor);
        }
    }
}

