/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.util.Random;
import java.util.StringTokenizer;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.RandomGenerator;
import org.jgap.UnsupportedRepresentationException;

public class StringGene
implements Gene {
    public static final String ALPHABET_CHARACTERS_UPPER = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String ALPHABET_CHARACTERS_LOWER = "abcdefghijklmnopqrstuvwxyz";
    public static final String ALPHABET_CHARACTERS_DIGITS = "0123456789";
    public static final String ALPHABET_CHARACTERS_SPECIAL = "+.*/\\,;@";
    private static final String CVS_REVISION = "$Revision: 1.7 $";
    private int m_minLength;
    private int m_maxLength;
    private String m_alphabet;
    private Random rn;
    protected String m_value = null;

    private void init() {
        this.rn = new Random();
    }

    public StringGene() {
        this.init();
    }

    public StringGene(int a_minLength, int a_maxLength) {
        this(a_minLength, a_maxLength, null);
    }

    public StringGene(int a_minLength, int a_maxLength, String a_alphabet) {
        if (a_minLength < 0) {
            throw new IllegalArgumentException("minimum length must be greater than zero!");
        }
        if (a_maxLength < a_minLength) {
            throw new IllegalArgumentException("minimum length must be smaller than or equal to maximum length!");
        }
        this.init();
        this.m_minLength = a_minLength;
        this.m_maxLength = a_maxLength;
        this.setAlphabet(a_alphabet);
    }

    public void cleanup() {
    }

    public void setToRandomValue(RandomGenerator a_numberGenerator) {
        if (this.m_alphabet == null || this.m_alphabet.length() < 1) {
            throw new IllegalStateException("The valid alphabet is empty!");
        }
        if (this.m_maxLength < this.m_minLength || this.m_maxLength < 1) {
            throw new IllegalStateException("Illegal valid maximum and/or minimum length of alphabet!");
        }
        int length = this.m_maxLength - this.m_minLength + 1;
        int i = a_numberGenerator.nextInt() % length;
        if (i < 0) {
            i = -i;
        }
        length = this.m_minLength + i;
        this.m_value = "";
        int alphabetLength = this.m_alphabet.length();
        int j = 0;
        while (j < length) {
            int index = a_numberGenerator.nextInt(alphabetLength);
            char value = this.m_alphabet.charAt(index);
            this.m_value = String.valueOf(this.m_value) + value;
            ++j;
        }
    }

    public void setValueFromPersistentRepresentation(String a_representation) throws UnsupportedRepresentationException {
        if (a_representation != null) {
            StringTokenizer tokenizer = new StringTokenizer(a_representation, ":");
            if (tokenizer.countTokens() != 4) {
                throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: it does not contain four tokens.");
            }
            String valueRepresentation = tokenizer.nextToken();
            String minLengthRepresentation = tokenizer.nextToken();
            String maxLengthRepresentation = tokenizer.nextToken();
            String alphabetRepresentation = tokenizer.nextToken();
            try {
                this.m_minLength = Integer.parseInt(minLengthRepresentation);
            }
            catch (NumberFormatException e) {
                throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: field 2 does not appear to be an integer value.");
            }
            try {
                this.m_maxLength = Integer.parseInt(maxLengthRepresentation);
            }
            catch (NumberFormatException e) {
                throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: field 3 does not appear to be an integer value.");
            }
            String tempValue = valueRepresentation.equals("null") ? null : (valueRepresentation.equals("\"\"") ? "" : valueRepresentation);
            if (tempValue != null) {
                if (this.m_minLength > tempValue.length()) {
                    throw new UnsupportedRepresentationException("The value given is shorter than the allowed maximum length.");
                }
                if (this.m_maxLength < tempValue.length()) {
                    throw new UnsupportedRepresentationException("The value given is longer than the allowed maximum length.");
                }
            }
            if (!this.isValidAlphabet(tempValue, alphabetRepresentation)) {
                throw new UnsupportedRepresentationException("The value given contains invalid characters.");
            }
            this.m_value = tempValue;
            this.m_alphabet = alphabetRepresentation;
        }
    }

    public String getPersistentRepresentation() throws UnsupportedOperationException {
        return String.valueOf(this.toString()) + ":" + this.m_minLength + ":" + this.m_maxLength + ":" + this.m_alphabet;
    }

    public Object getAllele() {
        return this.m_value;
    }

    public void setAllele(Object a_newValue) {
        if (a_newValue != null) {
            String temp = (String)a_newValue;
            if (temp.length() < this.m_minLength || temp.length() > this.m_maxLength) {
                throw new IllegalArgumentException("The given value is too short or too long!");
            }
            if (!this.isValidAlphabet(temp, this.m_alphabet)) {
                throw new IllegalArgumentException("The given value contains at least one invalid character.");
            }
        }
        this.m_value = (String)a_newValue;
    }

    public Gene newGene(Configuration a_activeConfiguration) {
        return new StringGene(this.m_minLength, this.m_maxLength, this.m_alphabet);
    }

    public int compareTo(Object other) {
        StringGene otherStringGene = (StringGene)other;
        if (otherStringGene == null) {
            return 1;
        }
        if (otherStringGene.m_value == null) {
            return this.m_value == null ? 0 : 1;
        }
        try {
            return this.m_value.compareTo(otherStringGene.m_value);
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public int size() {
        return this.m_value.length();
    }

    public int getMaxLength() {
        return this.m_maxLength;
    }

    public int getMinLength() {
        return this.m_minLength;
    }

    public void setMinLength(int m_minLength) {
        this.m_minLength = m_minLength;
    }

    public void setMaxLength(int m_maxLength) {
        this.m_maxLength = m_maxLength;
    }

    public String getAlphabet() {
        return this.m_alphabet;
    }

    public void setAlphabet(String a_alphabet) {
        if (this.containsString(a_alphabet, ":")) {
            throw new IllegalArgumentException("The alphabet may not contain a substring equal to the persistent field delimiter (which is : currently).");
        }
        this.m_alphabet = a_alphabet;
    }

    public String toString() {
        if (this.m_value == null) {
            return "null";
        }
        if (this.m_value.equals("")) {
            return "\"\"";
        }
        return this.m_value.toString();
    }

    public boolean equals(Object other) {
        try {
            return this.compareTo(other) == 0;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        if (this.m_value == null) {
            return 0;
        }
        return this.m_value.hashCode();
    }

    public String stringValue() {
        return this.m_value;
    }

    private boolean containsString(String totalString, String subString) {
        if (totalString == null || subString == null) {
            return false;
        }
        return totalString.indexOf(subString) >= 0;
    }

    private boolean isValidAlphabet(String a_value, String a_alphabet) {
        if (a_value == null || a_value.length() < 1) {
            return true;
        }
        if (a_alphabet == null) {
            return true;
        }
        if (a_alphabet.length() < 1) {
            return false;
        }
        int length = a_value.length();
        int i = 0;
        while (i < length) {
            char c = a_value.charAt(i);
            if (a_alphabet.indexOf(c) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void applyMutation(int index, double a_percentage) {
        String s = this.stringValue();
        char ch = s.charAt(index);
        int newValue = (int)Math.round((double)ch * (1.0 + a_percentage));
        s = String.valueOf(s.substring(0, index)) + ch + s.substring(index + 1);
        this.setAllele(s);
    }
}

